/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil;

import com.sun.corba.ee.spi.logging.LogWrapperBase;
import com.sun.corba.ee.spi.orb.ORB;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.WeakHashMap;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;

public class ClassInfoCache {
    private static Map<Class, ClassInfo> classData = new WeakHashMap<Class, ClassInfo>();

    public static synchronized ClassInfo get(Class cls) {
        ClassInfo result = classData.get(cls);
        if (result == null) {
            result = new ClassInfo(cls);
            classData.put(cls, result);
        }
        return result;
    }

    public static class ClassInfo {
        private boolean isAValueBase;
        private boolean isAString;
        private boolean isAIDLEntity;
        private LazyWrapper isARemote = new LazyWrapper(Remote.class);
        private LazyWrapper isARemoteException = new LazyWrapper(RemoteException.class);
        private LazyWrapper isAUserException = new LazyWrapper(UserException.class);
        private LazyWrapper isAObjectImpl = new LazyWrapper(ObjectImpl.class);
        private LazyWrapper isAORB = new LazyWrapper(ORB.class);
        private LazyWrapper isALogWrapperBase = new LazyWrapper(LogWrapperBase.class);
        private LazyWrapper isAStreamable = new LazyWrapper(Streamable.class);
        private LazyWrapper isAStreamableValue = new LazyWrapper(StreamableValue.class);
        private LazyWrapper isACustomValue = new LazyWrapper(CustomValue.class);
        private LazyWrapper isACORBAObject = new LazyWrapper(Object.class);
        private LazyWrapper isASerializable = new LazyWrapper(Serializable.class);
        private LazyWrapper isAExternalizable = new LazyWrapper(Externalizable.class);
        private LazyWrapper isAClass = new LazyWrapper(Class.class);
        private String repositoryId = null;
        private boolean isArray;
        private boolean isEnum;
        private boolean isInterface;
        private boolean isProxyClass;

        ClassInfo(Class cls) {
            this.isArray = cls.isArray();
            this.isEnum = cls.isEnum();
            this.isInterface = cls.isInterface();
            this.isProxyClass = Proxy.isProxyClass(cls);
            this.isAValueBase = ValueBase.class.isAssignableFrom(cls);
            this.isAString = String.class.isAssignableFrom(cls);
            this.isAIDLEntity = IDLEntity.class.isAssignableFrom(cls);
        }

        public synchronized String getRepositoryId() {
            return this.repositoryId;
        }

        public synchronized void setRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
        }

        public boolean isARemote(Class cls) {
            return this.isARemote.get(cls);
        }

        public boolean isARemoteException(Class cls) {
            return this.isARemoteException.get(cls);
        }

        public boolean isAUserException(Class cls) {
            return this.isAUserException.get(cls);
        }

        public boolean isAObjectImpl(Class cls) {
            return this.isAObjectImpl.get(cls);
        }

        public boolean isAORB(Class cls) {
            return this.isAORB.get(cls);
        }

        public boolean isALogWrapperBase(Class cls) {
            return this.isALogWrapperBase.get(cls);
        }

        public boolean isAIDLEntity(Class cls) {
            return this.isAIDLEntity;
        }

        public boolean isAStreamable(Class cls) {
            return this.isAStreamable.get(cls);
        }

        public boolean isAStreamableValue(Class cls) {
            return this.isAStreamableValue.get(cls);
        }

        public boolean isACustomValue(Class cls) {
            return this.isACustomValue.get(cls);
        }

        public boolean isAValueBase(Class cls) {
            return this.isAValueBase;
        }

        public boolean isACORBAObject(Class cls) {
            return this.isACORBAObject.get(cls);
        }

        public boolean isASerializable(Class cls) {
            return this.isASerializable.get(cls);
        }

        public boolean isAExternalizable(Class cls) {
            return this.isAExternalizable.get(cls);
        }

        public boolean isAString(Class cls) {
            return this.isAString;
        }

        public boolean isAClass(Class cls) {
            return this.isAClass.get(cls);
        }

        public boolean isArray() {
            return this.isArray;
        }

        public boolean isEnum() {
            return this.isEnum;
        }

        public boolean isInterface() {
            return this.isInterface;
        }

        public boolean isProxyClass() {
            return this.isProxyClass;
        }

        public static class LazyWrapper {
            Class isAClass;
            boolean initialized;
            boolean value;

            public LazyWrapper(Class isAClass) {
                this.isAClass = isAClass;
                this.initialized = false;
                this.value = false;
            }

            synchronized boolean get(Class cls) {
                if (!this.initialized) {
                    this.initialized = true;
                    this.value = this.isAClass.isAssignableFrom(cls);
                }
                return this.value;
            }
        }
    }
}

