/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.appserv.management.client.prefs.StoreException;
import com.sun.enterprise.admin.cli.AuthenticationException;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIManFileFinder;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.DirectoryClassLoader;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.InvalidCommandException;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.ValidOption;
import com.sun.enterprise.admin.cli.remote.RemoteException;
import com.sun.enterprise.admin.cli.remote.RemoteResponseManager;
import com.sun.enterprise.admin.cli.remote.RemoteSuccessException;
import com.sun.enterprise.admin.cli.util.AuthenticationInfo;
import com.sun.enterprise.admin.cli.util.HttpConnectorAddress;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import com.sun.enterprise.universal.GFBase64Encoder;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.FileUtils;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.net.NetUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.net.ssl.SSLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.admin.Payload;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.Inhabitants;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCommand
extends CLICommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(RemoteCommand.class);
    private static final String QUERY_STRING_INTRODUCER = "?";
    private static final String QUERY_STRING_SEPARATOR = "&";
    private static final String ADMIN_URI_PATH = "/__asadmin/";
    private static final String COMMAND_NAME_REGEXP = "^[a-zA-Z_][-a-zA-Z0-9_]*$";
    private static final String READ_TIMEOUT = "AS_ADMIN_READTIMEOUT";
    private static final int readTimeout;
    private String responseFormatType = "hk2-agent";
    private OutputStream userOut;
    private boolean returnOutput = false;
    private String output;
    private boolean returnAttributes = false;
    private Map<String, String> attrs;
    private boolean doUpload = false;
    private boolean addedUploadOption = false;
    private boolean doHelp = false;
    private Payload.Outbound outboundPayload;
    private String usage;
    private static ClassLoader moduleClassLoader;
    private static Habitat manHabitat;
    private static final String FILE_PAYLOAD_MIME_TYPE = "application/octet-stream";

    public RemoteCommand() throws CommandException {
        this.checkName();
    }

    public RemoteCommand(String name, ProgramOptions po, Environment env) throws CommandException {
        super(name, po, env);
        this.checkName();
    }

    private void checkName() throws CommandException {
        if (!this.name.matches(COMMAND_NAME_REGEXP)) {
            throw new CommandException("Illegal command name: " + this.name);
        }
    }

    public RemoteCommand(String name, ProgramOptions po, Environment env, String responseFormatType, OutputStream userOut) throws CommandException {
        this(name, po, env);
        this.responseFormatType = responseFormatType;
        this.userOut = userOut;
    }

    @Override
    protected void prepare() throws CommandException, CommandValidationException {
        try {
            this.processProgramOptions();
            this.initializeAuth();
            if (this.doHelp || this.programOpts.isHelp()) {
                this.commandOpts = new HashSet();
                ValidOption opt = new ValidOption("help", "BOOLEAN", 2, "false");
                opt.setShortName(QUERY_STRING_INTRODUCER);
                this.commandOpts.add(opt);
                return;
            }
            try {
                this.fetchCommandMetadata();
            }
            catch (AuthenticationException ex) {
                if (!this.updateAuthentication()) {
                    throw ex;
                }
                this.fetchCommandMetadata();
                logger.printDebugMessage("Updated authentication worked");
            }
            if (this.commandOpts == null) {
                String msg = this.metadataErrors != null ? this.metadataErrors.toString() : "";
                throw new CommandException(strings.get("InvalidCommand", new Object[]{this.name}), new InvalidCommandException(msg));
            }
            RemoteCommand.addOption(this.commandOpts, "help", '?', "BOOLEAN", false, "false");
        }
        catch (CommandException cex) {
            logger.printDebugMessage("RemoteCommand.prepare throws " + cex);
            throw cex;
        }
        catch (Exception e) {
            logger.printDebugMessage("RemoteCommand.prepare throws " + e);
            throw new CommandException(e.getMessage());
        }
    }

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        if (this.doHelp || this.programOpts.isHelp() || this.getBooleanOption("help")) {
            return;
        }
        super.validate();
    }

    @Override
    protected boolean checkHelp() throws CommandException, CommandValidationException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int executeCommand() throws CommandException, CommandValidationException {
        block28: {
            try {
                this.initializeDoUpload();
                if (this.doUpload) {
                    this.outboundPayload = PayloadImpl.Outbound.newInstance();
                }
                StringBuilder uriString = new StringBuilder(ADMIN_URI_PATH).append(this.name).append(QUERY_STRING_INTRODUCER);
                GFBase64Encoder encoder = new GFBase64Encoder();
                if (this.doHelp) {
                    this.addStringOption(uriString, "help", "true");
                }
                for (ValidOption opt : this.commandOpts) {
                    String paramName = opt.getName();
                    String paramValue = (String)this.options.get(paramName);
                    if (paramValue == null) {
                        paramValue = this.env.getStringOption(paramName);
                    }
                    if (paramValue == null) {
                        if (opt.isValueRequired() != 1) continue;
                        throw new CommandException(strings.get("missingOption", new Object[]{paramName}));
                    }
                    if (opt.getType().equals("FILE")) {
                        this.addFileOption(uriString, paramName, paramValue);
                        continue;
                    }
                    if (opt.getType().equals("PASSWORD")) {
                        this.addStringOption(uriString, paramName, encoder.encode(paramValue.getBytes()));
                        continue;
                    }
                    this.addStringOption(uriString, paramName, paramValue);
                }
                for (String operand : this.operands) {
                    if (this.operandType.equals("FILE")) {
                        this.addFileOption(uriString, "DEFAULT", operand);
                        continue;
                    }
                    this.addStringOption(uriString, "DEFAULT", operand);
                }
                uriString.setLength(uriString.length() - 1);
                try {
                    this.executeRemoteCommand(uriString.toString());
                }
                catch (AuthenticationException ex) {
                    if (this.updateAuthentication()) {
                        this.executeRemoteCommand(uriString.toString());
                        break block28;
                    }
                    throw ex;
                }
            }
            catch (CommandException ex) {
                Reader r;
                if ((this.programOpts.isHelp() || this.getBooleanOption("help")) && (r = this.getLocalManPage()) != null) {
                    try {
                        int cnt;
                        BufferedReader br = new BufferedReader(r);
                        PrintWriter pw = new PrintWriter(System.out);
                        char[] buf = new char[8192];
                        while ((cnt = br.read(buf)) > 0) {
                            pw.write(buf, 0, cnt);
                        }
                        pw.flush();
                        int n = 0;
                        return n;
                    }
                    catch (IOException ioex2) {
                    }
                    finally {
                        try {
                            r.close();
                        }
                        catch (IOException ioex3) {}
                    }
                }
                throw ex;
            }
            catch (IOException ioex) {
                throw new CommandException("I/O Error", ioex);
            }
        }
        return 0;
    }

    private void executeRemoteCommand(String uri) throws CommandException {
        this.doHttpCommand(uri, this.chooseRequestMethod(), new HttpCommand(){

            public void doCommand(HttpURLConnection urlConnection) throws CommandException, IOException {
                if (RemoteCommand.this.doUpload) {
                    urlConnection.setChunkedStreamingMode(0);
                    urlConnection.setRequestProperty("Content-Type", RemoteCommand.this.outboundPayload.getContentType());
                }
                urlConnection.connect();
                if (RemoteCommand.this.doUpload) {
                    RemoteCommand.this.outboundPayload.writeTo(urlConnection.getOutputStream());
                    RemoteCommand.this.outboundPayload = null;
                }
                InputStream in = urlConnection.getInputStream();
                String responseContentType = urlConnection.getContentType();
                PayloadImpl.Inbound inboundPayload = PayloadImpl.Inbound.newInstance((String)responseContentType, (InputStream)in);
                boolean isReportProcessed = false;
                PayloadFilesManager.Perm downloadedFilesMgr = new PayloadFilesManager.Perm();
                Iterator partIt = inboundPayload.parts();
                while (partIt.hasNext()) {
                    if (!isReportProcessed) {
                        RemoteCommand.this.handleResponse(RemoteCommand.this.options, ((Payload.Part)partIt.next()).getInputStream(), urlConnection.getResponseCode(), RemoteCommand.this.userOut);
                        isReportProcessed = true;
                        continue;
                    }
                    RemoteCommand.this.processDataPart((PayloadFilesManager)downloadedFilesMgr, (Payload.Part)partIt.next());
                }
            }
        });
    }

    public String executeAndReturnOutput(String ... args) throws CommandException, CommandValidationException {
        this.returnOutput = true;
        this.execute(args);
        this.returnOutput = false;
        return this.output;
    }

    public Map<String, String> executeAndReturnAttributes(String ... args) throws CommandException, CommandValidationException {
        this.returnAttributes = true;
        this.execute(args);
        this.returnAttributes = false;
        return this.attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHttpCommand(String uriString, String httpMethod, HttpCommand cmd) throws CommandException {
        HttpURLConnection urlConnection = null;
        try {
            HttpConnectorAddress url = new HttpConnectorAddress(this.programOpts.getHost(), this.programOpts.getPort(), this.programOpts.isSecure());
            logger.printDebugMessage("URI: " + uriString);
            logger.printDebugMessage("URL: " + url.toString());
            logger.printDebugMessage("URL: " + url.toURL(uriString.toString()).toString());
            logger.printDebugMessage("Using auth info: User: " + this.programOpts.getUser() + ", Password: " + (RemoteCommand.ok(this.programOpts.getPassword()) ? "<non-null>" : "<null>"));
            String user = this.programOpts.getUser();
            String pwd = this.programOpts.getPassword();
            if (user != null || pwd != null) {
                url.setAuthenticationInfo(new AuthenticationInfo(user, pwd));
            }
            urlConnection = (HttpURLConnection)url.openConnection(uriString.toString());
            urlConnection.setRequestProperty("User-Agent", this.responseFormatType);
            urlConnection.setRequestProperty("Authorization", url.getBasicAuthString());
            urlConnection.setRequestMethod(httpMethod);
            urlConnection.setReadTimeout(readTimeout);
            cmd.doCommand(urlConnection);
            logger.printDebugMessage("doHttpCommand succeeds");
        }
        catch (ConnectException ce) {
            logger.printDebugMessage("doHttpCommand: connect exception " + ce);
            String msg = strings.get("ConnectException", new Object[]{this.programOpts.getHost(), this.programOpts.getPort() + ""});
            throw new CommandException(msg, ce);
        }
        catch (UnknownHostException he) {
            logger.printDebugMessage("doHttpCommand: host exception " + he);
            String msg = strings.get("UnknownHostException", new Object[]{this.programOpts.getHost()});
            throw new CommandException(msg, he);
        }
        catch (SocketException se) {
            logger.printDebugMessage("doHttpCommand: socket exception " + se);
            try {
                boolean serverAppearsSecure = NetUtils.isSecurePort((String)this.programOpts.getHost(), (int)this.programOpts.getPort());
                if (serverAppearsSecure && !this.programOpts.isSecure()) {
                    String msg = strings.get("ServerMaybeSecure", new Object[]{this.programOpts.getHost(), this.programOpts.getPort() + ""});
                    logger.printMessage(msg);
                    this.programOpts.setSecure(true);
                    try {
                        this.doHttpCommand(uriString, httpMethod, cmd);
                    }
                    finally {
                        this.programOpts.setSecure(false);
                    }
                    return;
                }
                throw new CommandException(se);
            }
            catch (IOException io) {
                logger.printExceptionStackTrace(io);
                throw new CommandException(io);
            }
        }
        catch (SSLException se) {
            logger.printDebugMessage("doHttpCommand: SSL exception " + se);
            try {
                boolean serverAppearsSecure = NetUtils.isSecurePort((String)this.programOpts.getHost(), (int)this.programOpts.getPort());
                if (!serverAppearsSecure && this.programOpts.isSecure()) {
                    String msg = strings.get("ServerIsNotSecure", new Object[]{this.programOpts.getHost(), this.programOpts.getPort() + ""});
                    logger.printError(msg);
                }
                throw new CommandException(se);
            }
            catch (IOException io) {
                logger.printExceptionStackTrace(io);
                throw new CommandException(io);
            }
        }
        catch (IOException e) {
            logger.printDebugMessage("doHttpCommand: IO exception " + e);
            String msg = "I/O Error: " + e.getMessage();
            if (urlConnection != null) {
                try {
                    int rc = urlConnection.getResponseCode();
                    if (401 == rc) {
                        ProgramOptions.PasswordLocation pwloc = this.programOpts.getPasswordLocation();
                        if (pwloc == ProgramOptions.PasswordLocation.PASSWORD_FILE) {
                            msg = strings.get("InvalidCredentialsFromFile", new Object[]{this.programOpts.getUser(), this.programOpts.getPasswordFile()});
                        } else if (pwloc == ProgramOptions.PasswordLocation.LOGIN_FILE) {
                            try {
                                LoginInfoStore store = LoginInfoStoreFactory.getDefaultStore();
                                msg = strings.get("InvalidCredentialsFromLogin", new Object[]{this.programOpts.getUser(), store.getName()});
                            }
                            catch (StoreException ex) {}
                        } else {
                            msg = strings.get("InvalidCredentials", new Object[]{this.programOpts.getUser()});
                        }
                        throw new AuthenticationException(msg);
                    }
                    msg = "Status: " + rc;
                }
                catch (IOException ioex) {
                    // empty catch block
                }
            }
            throw new CommandException(msg, e);
        }
        catch (Exception e) {
            logger.printDebugMessage("doHttpCommand: exception " + e);
            logger.printExceptionStackTrace(e);
            throw new CommandException(e);
        }
    }

    @Override
    public String getUsage() {
        if (this.usage == null) {
            return super.getUsage();
        }
        StringBuilder usageText = new StringBuilder();
        usageText.append(strings.get("Usage", new Object[]{strings.get("Usage.asadmin")}));
        usageText.append(" ");
        usageText.append(this.usage);
        return usageText.toString();
    }

    @Override
    public Reader getManPage() {
        try {
            this.doHelp = true;
            String manpage = this.executeAndReturnOutput(this.name);
            this.doHelp = false;
            return new StringReader(manpage);
        }
        catch (CommandException cex) {
        }
        catch (CommandValidationException cvex) {
            // empty catch block
        }
        Reader r = this.getLocalManPage();
        return r != null ? r : super.getManPage();
    }

    private Reader getLocalManPage() {
        logger.printDetailMessage(strings.get("NoRemoteManPage"));
        String cmdClass = RemoteCommand.getCommandClass(this.getName());
        ClassLoader mcl = RemoteCommand.getModuleClassLoader();
        if (cmdClass != null && mcl != null) {
            return CLIManFileFinder.getCommandManFile(this.getName(), cmdClass, Locale.getDefault(), mcl);
        }
        return null;
    }

    private void processDataPart(PayloadFilesManager downloadedFilesMgr, Payload.Part part) throws IOException {
        Properties partProps = part.getProperties();
        String dataRequestType = partProps.getProperty("data-request-type");
        if (dataRequestType.equals("file-xfer")) {
            downloadedFilesMgr.extractFile(part);
        }
    }

    private StringBuilder addStringOption(StringBuilder uriString, String name, String option) {
        try {
            String encodedOption = URLEncoder.encode(option, "UTF-8");
            uriString.append(name).append('=').append(encodedOption).append(QUERY_STRING_SEPARATOR);
        }
        catch (UnsupportedEncodingException e) {
            logger.printError("Error encoding value for: " + name + ", Value:" + option + ", parameter value will be ignored");
        }
        return uriString;
    }

    private StringBuilder addFileOption(StringBuilder uriString, String optionName, String filename) throws IOException {
        File f = SmartFile.sanitize((File)new File(filename));
        logger.printDebugMessage("FILE PARAM: " + optionName + " = " + f);
        if (this.doUpload) {
            this.outboundPayload.attachFile(FILE_PAYLOAD_MIME_TYPE, f.toURI(), optionName, null, f);
        }
        if (f != null) {
            String pathToPass = this.doUpload ? f.getName() : f.getPath();
            this.addStringOption(uriString, optionName, pathToPass);
        }
        return uriString;
    }

    private String chooseRequestMethod() {
        if (this.doUpload) {
            return "POST";
        }
        return "GET";
    }

    private void handleResponse(Map<String, String> params, InputStream in, int code, OutputStream userOut) throws IOException, CommandException {
        if (userOut == null) {
            this.handleResponse(params, in, code);
        } else {
            FileUtils.copyStream((InputStream)in, (OutputStream)userOut);
        }
    }

    private void handleResponse(Map<String, String> params, InputStream in, int code) throws IOException, CommandException {
        RemoteResponseManager rrm = null;
        try {
            rrm = new RemoteResponseManager(in, code);
            rrm.process();
        }
        catch (RemoteSuccessException rse) {
            if (this.returnOutput) {
                this.output = rse.getMessage();
            } else if (this.returnAttributes) {
                this.attrs = rrm.getMainAtts();
            } else {
                logger.printMessage(rse.getMessage());
            }
            return;
        }
        catch (RemoteException rfe) {
            if (rfe.getRemoteCause().indexOf("CommandNotFoundException") > 0) {
                throw new CommandException(rfe.getMessage(), new InvalidCommandException());
            }
            throw new CommandException("remote failure: " + rfe.getMessage(), rfe);
        }
    }

    protected void fetchCommandMetadata() throws CommandException {
        StringBuilder uriString = new StringBuilder(ADMIN_URI_PATH).append(this.name).append(QUERY_STRING_INTRODUCER);
        this.addStringOption(uriString, "Xhelp", "true");
        uriString.setLength(uriString.length() - 1);
        this.doHttpCommand(uriString.toString(), "GET", new HttpCommand(){

            public void doCommand(HttpURLConnection urlConnection) throws CommandException, IOException {
                urlConnection.setRequestProperty("User-Agent", "metadata");
                urlConnection.connect();
                InputStream in = urlConnection.getInputStream();
                String responseContentType = urlConnection.getContentType();
                PayloadImpl.Inbound inboundPayload = PayloadImpl.Inbound.newInstance((String)responseContentType, (InputStream)in);
                boolean isReportProcessed = false;
                Iterator partIt = inboundPayload.parts();
                while (partIt.hasNext()) {
                    if (!isReportProcessed) {
                        RemoteCommand.this.metadataErrors = new StringBuilder();
                        RemoteCommand.this.commandOpts = RemoteCommand.this.parseMetadata(((Payload.Part)partIt.next()).getInputStream(), RemoteCommand.this.metadataErrors);
                        logger.printDebugMessage("fetchCommandMetadata: got command opts: " + RemoteCommand.this.commandOpts);
                        isReportProcessed = true;
                        continue;
                    }
                    partIt.next();
                }
            }
        });
    }

    private Set<ValidOption> parseMetadata(InputStream in, StringBuilder errors) {
        if (logger.isLoggable(Level.FINER)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                FileUtils.copyStream((InputStream)in, (OutputStream)baos);
            }
            catch (IOException ex) {
                // empty catch block
            }
            in = new ByteArrayInputStream(baos.toByteArray());
            String response = baos.toString();
            logger.printDebugMessage("------- RAW METADATA RESPONSE ---------");
            logger.printDebugMessage(response);
            logger.printDebugMessage("------- RAW METADATA RESPONSE ---------");
        }
        LinkedHashSet<ValidOption> valid = new LinkedHashSet<ValidOption>();
        boolean sawFile = false;
        try {
            NamedNodeMap attrs;
            Node n;
            int i;
            DocumentBuilder d = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = d.parse(in);
            NodeList cmd = doc.getElementsByTagName("command");
            Node cmdnode = cmd.item(0);
            if (cmdnode == null) {
                Node report = doc.getElementsByTagName("action-report").item(0);
                String cause = RemoteCommand.getAttr(report.getAttributes(), "failure-cause");
                if (cause != null) {
                    errors.append(cause);
                }
                return null;
            }
            NamedNodeMap cmdattrs = cmdnode.getAttributes();
            this.usage = RemoteCommand.getAttr(cmdattrs, "usage");
            String dashOk = RemoteCommand.getAttr(cmdattrs, "unknown-options-are-operands");
            if (dashOk != null) {
                this.unknownOptionsAreOperands = Boolean.parseBoolean(dashOk);
            }
            NodeList opts = doc.getElementsByTagName("option");
            for (i = 0; i < opts.getLength(); ++i) {
                n = opts.item(i);
                attrs = n.getAttributes();
                ValidOption opt = new ValidOption(RemoteCommand.getAttr(attrs, "name"), RemoteCommand.getAttr(attrs, "type"), Boolean.parseBoolean(RemoteCommand.getAttr(attrs, "optional")) ? 2 : 1, RemoteCommand.getAttr(attrs, "default"));
                String sn = RemoteCommand.getAttr(attrs, "short");
                if (RemoteCommand.ok(sn)) {
                    opt.setShortName(sn);
                }
                if (opt.getType().equals("PASSWORD") && RemoteCommand.getAttr(attrs, "description") != null) {
                    opt.setDefaultValue(RemoteCommand.getAttr(attrs, "description"));
                }
                valid.add(opt);
                if (!opt.getType().equals("FILE")) continue;
                sawFile = true;
            }
            opts = doc.getElementsByTagName("operand");
            for (i = 0; i < opts.getLength(); ++i) {
                n = opts.item(i);
                attrs = n.getAttributes();
                this.operandName = RemoteCommand.getAttr(attrs, "name");
                this.operandType = RemoteCommand.getAttr(attrs, "type");
                this.operandMin = Integer.parseInt(RemoteCommand.getAttr(attrs, "min"));
                String max = RemoteCommand.getAttr(attrs, "max");
                this.operandMax = max.equals("unlimited") ? Integer.MAX_VALUE : Integer.parseInt(max);
                if (!this.operandType.equals("FILE")) continue;
                sawFile = true;
            }
            if (sawFile) {
                valid.add(new ValidOption("upload", "BOOLEAN", 2, null));
                this.addedUploadOption = true;
            }
        }
        catch (ParserConfigurationException pex) {
            return null;
        }
        catch (SAXException sex) {
            return null;
        }
        catch (IOException ioex) {
            return null;
        }
        return valid;
    }

    private static String getAttr(NamedNodeMap attrs, String name) {
        Node n = attrs.getNamedItem(name);
        if (n != null) {
            return n.getNodeValue();
        }
        return null;
    }

    private void initializeDoUpload() throws CommandException {
        boolean sawFile = false;
        boolean sawDirectory = false;
        for (Map.Entry param : this.options.entrySet()) {
            String paramName = (String)param.getKey();
            ValidOption opt = this.getValidOption(paramName);
            if (opt == null || !opt.getType().equals("FILE")) continue;
            sawFile = true;
            String filename = (String)param.getValue();
            File file = new File(filename);
            if (!file.isDirectory()) continue;
            sawDirectory = true;
        }
        if (this.operandType != null && this.operandType.equals("FILE")) {
            for (String filename : this.operands) {
                sawFile = true;
                File file = new File(filename);
                if (!file.isDirectory()) continue;
                sawDirectory = true;
            }
        }
        if (sawFile) {
            String upString = this.getOption("upload");
            if (RemoteCommand.ok(upString)) {
                this.doUpload = Boolean.parseBoolean(upString);
            } else {
                boolean bl = this.doUpload = !RemoteCommand.isLocal(this.programOpts.getHost());
            }
            if (sawDirectory && this.doUpload) {
                logger.printDebugMessage("--upload=" + upString + ", doUpload=" + this.doUpload);
                throw new CommandException(strings.get("CantUploadDirectory"));
            }
        }
        if (this.addedUploadOption) {
            this.options.remove("upload");
        }
        logger.printDebugMessage("doUpload set to " + this.doUpload);
    }

    private static boolean isLocal(String hostname) {
        if (hostname.equalsIgnoreCase("localhost")) {
            return true;
        }
        try {
            InetAddress ia = InetAddress.getByName(hostname);
            return NetUtils.isLocal((String)ia.getHostAddress());
        }
        catch (UnknownHostException ex) {
            return false;
        }
    }

    private ValidOption getValidOption(String name) {
        for (ValidOption opt : this.commandOpts) {
            if (!opt.getName().equals(name)) continue;
            return opt;
        }
        return null;
    }

    protected boolean updateAuthentication() {
        Console cons;
        if (this.programOpts.isInteractive() && (cons = System.console()) != null) {
            String puser;
            String password;
            ProgramOptions.PasswordLocation pwloc = this.programOpts.getPasswordLocation();
            if (pwloc == ProgramOptions.PasswordLocation.PASSWORD_FILE) {
                logger.printDetailMessage(strings.get("BadPasswordFromFile", new Object[]{this.programOpts.getPasswordFile()}));
            } else if (pwloc == ProgramOptions.PasswordLocation.LOGIN_FILE) {
                try {
                    LoginInfoStore store = LoginInfoStoreFactory.getDefaultStore();
                    logger.printDetailMessage(strings.get("BadPasswordFromLogin", new Object[]{store.getName()}));
                }
                catch (StoreException ex) {
                    // empty catch block
                }
            }
            String user = null;
            if (this.programOpts.getUser() == null) {
                cons.printf("%s ", strings.get("AdminUserPrompt"));
                user = cons.readLine();
                if (user == null) {
                    return false;
                }
            }
            if ((password = RemoteCommand.ok(puser = RemoteCommand.ok(user) ? user : this.programOpts.getUser()) ? this.readPassword(strings.get("AdminUserPasswordPrompt", new Object[]{puser})) : this.readPassword(strings.get("AdminPasswordPrompt"))) == null) {
                return false;
            }
            if (RemoteCommand.ok(user)) {
                this.programOpts.setUser(user);
            }
            this.programOpts.setPassword(password, ProgramOptions.PasswordLocation.USER);
            return true;
        }
        return false;
    }

    private void initializeAuth() throws CommandException {
        LoginInfo li = null;
        try {
            LoginInfoStore store = LoginInfoStoreFactory.getDefaultStore();
            li = store.read(this.programOpts.getHost(), this.programOpts.getPort());
            if (li == null) {
                return;
            }
        }
        catch (StoreException se) {
            logger.printDebugMessage("Login info could not be read from ~/.asadminpass file");
            return;
        }
        if (this.programOpts.getUser() == null) {
            logger.printDebugMessage("Getting user name from ~/.asadminpass: " + li.getUser());
            this.programOpts.setUser(li.getUser());
            if (this.programOpts.getPassword() == null) {
                logger.printDebugMessage("Getting password from ~/.asadminpass");
                this.programOpts.setPassword(li.getPassword(), ProgramOptions.PasswordLocation.LOGIN_FILE);
            }
        } else if (this.programOpts.getUser().equals(li.getUser()) && this.programOpts.getPassword() == null) {
            logger.printDebugMessage("Getting password from ~/.asadminpass");
            this.programOpts.setPassword(li.getPassword(), ProgramOptions.PasswordLocation.LOGIN_FILE);
        }
    }

    private static String getCommandClass(String cmdName) {
        Habitat h = RemoteCommand.getManHabitat();
        String cname = "org.glassfish.api.admin.AdminCommand";
        for (Inhabitant command : h.getInhabitantsByContract(cname)) {
            for (String name : Inhabitants.getNamesFor((Inhabitant)command, (String)cname)) {
                if (!name.equals(cmdName)) continue;
                return command.typeName();
            }
        }
        return null;
    }

    private static Habitat getManHabitat() {
        if (manHabitat != null) {
            return manHabitat;
        }
        StaticModulesRegistry registry = new StaticModulesRegistry(RemoteCommand.getModuleClassLoader());
        manHabitat = registry.createHabitat("default");
        return manHabitat;
    }

    private static ClassLoader getModuleClassLoader() {
        if (moduleClassLoader != null) {
            return moduleClassLoader;
        }
        try {
            File installDir = new File(System.getProperty("com.sun.aas.installRoot"));
            File modulesDir = new File(installDir, "modules");
            moduleClassLoader = new DirectoryClassLoader(modulesDir, CLICommand.class.getClassLoader());
            return moduleClassLoader;
        }
        catch (IOException ioex) {
            return null;
        }
    }

    static {
        String rt = System.getProperty(READ_TIMEOUT);
        if (rt == null) {
            rt = System.getenv(READ_TIMEOUT);
        }
        readTimeout = rt != null ? Integer.parseInt(rt) : 600000;
    }

    static interface HttpCommand {
        public void doCommand(HttpURLConnection var1) throws CommandException, IOException;
    }
}

