/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.common_impl;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.RepositoryChangeListener;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import com.sun.enterprise.module.common_impl.DefaultModuleDefinition;
import com.sun.enterprise.module.common_impl.Jar;
import com.sun.enterprise.module.common_impl.ModuleId;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoryImpl
implements Repository {
    private final String name;
    private final URI location;
    private Map<ModuleId, ModuleDefinition> moduleDefs;
    private List<URI> libraries;
    protected List<RepositoryChangeListener> listeners;

    public AbstractRepositoryImpl(String name, URI location) {
        this.name = name;
        this.location = location;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    public ModuleDefinition find(String name, String version) {
        return this.moduleDefs.get(AbstractFactory.getInstance().createModuleId(name, version));
    }

    @Override
    public List<ModuleDefinition> findAll() {
        return new ArrayList<ModuleDefinition>(this.moduleDefs.values());
    }

    @Override
    public List<ModuleDefinition> findAll(String name) {
        ArrayList<ModuleDefinition> result = new ArrayList<ModuleDefinition>();
        for (ModuleDefinition md : this.findAll()) {
            if (!name.equals(md.getName())) continue;
            result.add(md);
        }
        return result;
    }

    @Override
    public void initialize() throws IOException {
        assert (this.moduleDefs == null);
        this.moduleDefs = new HashMap<ModuleId, ModuleDefinition>();
        this.libraries = new ArrayList<URI>();
        this.loadModuleDefs(this.moduleDefs, this.libraries);
    }

    protected abstract void loadModuleDefs(Map<ModuleId, ModuleDefinition> var1, List<URI> var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModuleDefinition loadJar(File jar) throws IOException {
        Attributes attr;
        String bundleName;
        Jar jarFile = Jar.create(jar);
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            String simpleName = jarFile.getBaseName();
            File manifestFile = new File(jar.getParentFile(), simpleName + ".mf");
            if (manifestFile.exists()) {
                InputStream is = null;
                try {
                    is = new BufferedInputStream(new FileInputStream(manifestFile));
                    manifest = new Manifest(is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
        }
        if (manifest != null && (bundleName = (attr = manifest.getMainAttributes()).getValue("Bundle-SymbolicName")) != null) {
            return this.newModuleDefinition(jar, attr);
        }
        return null;
    }

    protected void add(ModuleDefinition def) {
        this.moduleDefs.put(AbstractFactory.getInstance().createModuleId(def), def);
    }

    protected void remove(ModuleDefinition def) {
        this.moduleDefs.remove(AbstractFactory.getInstance().createModuleId(def));
    }

    protected void addLibrary(URI location) {
        this.libraries.add(location);
    }

    protected void removeLibrary(URI location) {
        this.libraries.remove(location);
    }

    @Override
    public void shutdown() throws IOException {
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        for (ModuleDefinition moduleDef : this.findAll()) {
            s.append(moduleDef.getName()).append(":");
        }
        return s.toString();
    }

    @Override
    public List<URI> getJarLocations() {
        return Collections.unmodifiableList(this.libraries);
    }

    @Override
    public synchronized boolean addListener(RepositoryChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<RepositoryChangeListener>();
        }
        return this.listeners.add(listener);
    }

    @Override
    public synchronized boolean removeListener(RepositoryChangeListener listener) {
        if (this.listeners == null) {
            return false;
        }
        return this.listeners.remove(this.listeners);
    }

    protected ModuleDefinition newModuleDefinition(File jar, Attributes attr) throws IOException {
        return new DefaultModuleDefinition(jar, attr);
    }
}

