/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaCache;
import org.eclipse.persistence.sessions.IdentityMapAccessor;
import org.eclipse.persistence.sessions.server.ServerSession;

public class CacheImpl
implements JpaCache {
    private IdentityMapAccessor accessor;
    private EntityManagerFactoryImpl emf;
    private ServerSession serversession;

    public CacheImpl(EntityManagerFactoryImpl emf, IdentityMapAccessor accessor) {
        this.accessor = accessor;
        this.emf = emf;
        this.serversession = emf.getServerSession();
    }

    public boolean contains(Class cls, Object id) {
        this.emf.verifyOpen();
        Object pk = this.createPrimaryKeyFromId(cls, id);
        ClassDescriptor descriptor = this.serversession.getDescriptor(cls);
        CacheKey key = ((org.eclipse.persistence.internal.sessions.IdentityMapAccessor)this.accessor).getCacheKeyForObject(pk, cls, descriptor);
        return key != null && key.getObject() != null && !descriptor.getCacheInvalidationPolicy().isInvalidated(key);
    }

    public void evict(Class cls, Object id) {
        this.emf.verifyOpen();
        this.accessor.invalidateObject(this.createPrimaryKeyFromId(cls, id), cls);
    }

    public void evict(Class cls) {
        this.emf.verifyOpen();
        this.accessor.invalidateClass(cls);
    }

    public void evictAll() {
        this.emf.verifyOpen();
        this.accessor.invalidateAll();
    }

    private Object createPrimaryKeyFromId(Class cls, Object id) {
        CMP3Policy policy = (CMP3Policy)this.serversession.getDescriptor(cls).getCMPPolicy();
        Object primaryKey = policy.createPrimaryKeyFromId(id, (AbstractSession)this.serversession);
        return primaryKey;
    }

    public void clear() {
        this.emf.verifyOpen();
        this.accessor.initializeAllIdentityMaps();
    }

    public void clear(Class cls) {
        this.emf.verifyOpen();
        this.accessor.initializeIdentityMap(cls);
    }

    public void clearQueryCache() {
        this.emf.verifyOpen();
        this.accessor.clearQueryCache();
    }

    public void clearQueryCache(String queryName) {
        this.emf.verifyOpen();
        this.accessor.clearQueryCache(queryName);
    }

    public long timeToLive(Object object) {
        this.emf.verifyOpen();
        return this.accessor.getRemainingValidTime(object);
    }

    public boolean isValid(Object object) {
        this.emf.verifyOpen();
        return this.accessor.isValid(object);
    }

    public boolean isValid(Class cls, Object id) {
        this.emf.verifyOpen();
        return this.accessor.isValid(this.createPrimaryKeyFromId(cls, id), cls);
    }

    public void print() {
        this.emf.verifyOpen();
        this.accessor.printIdentityMaps();
    }

    public void print(Class cls) {
        this.emf.verifyOpen();
        this.accessor.printIdentityMap(cls);
    }

    public void printLocks() {
        this.emf.verifyOpen();
        this.accessor.printIdentityMapLocks();
    }

    public void validate() {
        this.emf.verifyOpen();
        this.accessor.validateCache();
    }

    public Object getObject(Class cls, Object id) {
        this.emf.verifyOpen();
        return this.accessor.getFromIdentityMap(this.createPrimaryKeyFromId(cls, id), cls);
    }

    public Object putObject(Object object) {
        this.emf.verifyOpen();
        return this.accessor.putInIdentityMap(object);
    }

    public Object removeObject(Object object) {
        this.emf.verifyOpen();
        return this.accessor.removeFromIdentityMap(object);
    }

    public Object removeObject(Class cls, Object id) {
        this.emf.verifyOpen();
        return this.accessor.removeFromIdentityMap(this.createPrimaryKeyFromId(cls, id), cls);
    }

    public boolean contains(Object object) {
        return this.contains(object.getClass(), this.getId(object));
    }

    public void evict(Object object) {
        this.emf.verifyOpen();
        this.accessor.invalidateObject(object);
    }

    public Object getId(Object object) {
        this.emf.verifyOpen();
        ClassDescriptor cdesc = this.serversession.getDescriptor(object.getClass());
        CMP3Policy policy = (CMP3Policy)cdesc.getCMPPolicy();
        return policy.createPrimaryKeyInstance(object, (AbstractSession)this.serversession);
    }
}

