/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.sql.Blob;
import java.util.Collection;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import org.eclipse.persistence.annotations.Mutable;
import org.eclipse.persistence.annotations.ReturnInsert;
import org.eclipse.persistence.annotations.ReturnUpdate;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.EnumeratedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.LobMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.ReturnInsertMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.GeneratedValueMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;

public class BasicAccessor
extends DirectAccessor {
    private Boolean m_mutable;
    private boolean m_returnUpdate;
    private ColumnMetadata m_column;
    private DatabaseField m_field;
    private GeneratedValueMetadata m_generatedValue;
    private ReturnInsertMetadata m_returnInsert;
    private SequenceGeneratorMetadata m_sequenceGenerator;
    private TableGeneratorMetadata m_tableGenerator;

    public BasicAccessor() {
        super("<basic>");
    }

    public BasicAccessor(String xmlElement) {
        super(xmlElement);
    }

    public BasicAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        MetadataAnnotation basic = this.getAnnotation(Basic.class);
        if (basic != null) {
            this.setFetch((String)basic.getAttribute("fetch"));
            this.setOptional((Boolean)basic.getAttribute("optional"));
        }
        this.m_column = new ColumnMetadata(this.getAnnotation(Column.class), accessibleObject);
        MetadataAnnotation mutable = this.getAnnotation(Mutable.class);
        if (mutable != null) {
            this.m_mutable = (Boolean)mutable.getAttributeBooleanDefaultTrue("value");
        }
        if (this.isAnnotationPresent(GeneratedValue.class)) {
            this.m_generatedValue = new GeneratedValueMetadata(this.getAnnotation(GeneratedValue.class));
        }
        if (this.isAnnotationPresent(SequenceGenerator.class)) {
            this.m_sequenceGenerator = new SequenceGeneratorMetadata(this.getAnnotation(SequenceGenerator.class), accessibleObject);
        }
        if (this.isAnnotationPresent(TableGenerator.class)) {
            this.m_tableGenerator = new TableGeneratorMetadata(this.getAnnotation(TableGenerator.class), accessibleObject);
        }
        if (this.isAnnotationPresent(ReturnInsert.class)) {
            this.m_returnInsert = new ReturnInsertMetadata(this.getAnnotation(ReturnInsert.class), accessibleObject);
        }
        this.m_returnUpdate = this.isAnnotationPresent(ReturnUpdate.class);
    }

    public ColumnMetadata getColumn() {
        return this.m_column;
    }

    protected ColumnMetadata getColumn(String loggingCtx) {
        return this.m_column == null ? super.getColumn(loggingCtx) : this.m_column;
    }

    public String getDefaultFetchType() {
        return FetchType.EAGER.name();
    }

    protected DatabaseField getField() {
        return this.m_field;
    }

    public GeneratedValueMetadata getGeneratedValue() {
        return this.m_generatedValue;
    }

    public Boolean getMutable() {
        return this.m_mutable;
    }

    public ReturnInsertMetadata getReturnInsert() {
        return this.m_returnInsert;
    }

    public String getReturnUpdate() {
        return null;
    }

    public SequenceGeneratorMetadata getSequenceGenerator() {
        return this.m_sequenceGenerator;
    }

    public TableGeneratorMetadata getTableGenerator() {
        return this.m_tableGenerator;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        if (this.m_column == null) {
            this.m_column = new ColumnMetadata(accessibleObject);
        } else {
            this.initXMLObject(this.m_column, accessibleObject);
        }
        this.initXMLObject(this.m_returnInsert, accessibleObject);
        this.initXMLObject(this.m_sequenceGenerator, accessibleObject);
        this.initXMLObject(this.m_tableGenerator, accessibleObject);
    }

    public boolean isBasic() {
        return true;
    }

    protected boolean isCollectionClass(MetadataClass cls) {
        return cls.extendsInterface(Collection.class);
    }

    protected boolean isMapClass(MetadataClass cls) {
        return cls.extendsInterface(Map.class);
    }

    public boolean isReturnUpdate() {
        return this.m_returnUpdate;
    }

    public void process() {
        DirectToFieldMapping mapping = new DirectToFieldMapping();
        this.setMapping((DatabaseMapping)mapping);
        this.m_field = this.getDatabaseField(this.getDescriptor().getPrimaryTable(), "metadata_default_column");
        if (this.hasAttributeType() || this.getAccessibleObject().isGenericType()) {
            mapping.setAttributeClassification(this.getJavaClass(this.getReferenceClass()));
        }
        mapping.setField(this.m_field);
        mapping.setIsReadOnly(this.m_field.isReadOnly());
        mapping.setAttributeName(this.getAttributeName());
        mapping.setIsOptional(this.isOptional());
        mapping.setIsLazy(this.usesIndirection());
        this.setAccessorMethods((DatabaseMapping)mapping);
        this.processMappingValueConverter((DatabaseMapping)mapping, this.getConvert(), this.getReferenceClass());
        if (this.m_mutable != null) {
            mapping.setIsMutable(this.m_mutable.booleanValue());
        }
        this.processReturnInsertAndUpdate();
        this.processGeneratedValue();
        if (this.m_tableGenerator != null) {
            this.getProject().addTableGenerator(this.m_tableGenerator, this.getDescriptor().getDefaultCatalog(), this.getDescriptor().getDefaultSchema());
        }
        if (this.m_sequenceGenerator != null) {
            this.getProject().addSequenceGenerator(this.m_sequenceGenerator, this.getDescriptor().getDefaultCatalog(), this.getDescriptor().getDefaultSchema());
        }
    }

    protected void processEnumerated(EnumeratedMetadata enumerated, DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        if (this.isCollectionClass(referenceClass) || this.isMapClass(referenceClass)) {
            this.processSerialized(mapping, referenceClass, isForMapKey);
        } else {
            super.processEnumerated(enumerated, mapping, referenceClass, isForMapKey);
        }
    }

    protected void processGeneratedValue() {
        if (this.m_generatedValue != null) {
            for (MetadataDescriptor owningDescriptor : this.getOwningDescriptors()) {
                DatabaseField existingSequenceNumberField = owningDescriptor.getSequenceNumberField();
                if (existingSequenceNumberField == null) {
                    owningDescriptor.setSequenceNumberField(this.m_field);
                    this.getProject().addGeneratedValue(this.m_generatedValue, owningDescriptor.getJavaClass());
                    continue;
                }
                throw ValidationException.onlyOneGeneratedValueIsAllowed((Object)owningDescriptor.getJavaClass(), (String)existingSequenceNumberField.getQualifiedName(), (String)this.m_field.getQualifiedName());
            }
        }
    }

    protected void processLob(LobMetadata lob, DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        if (this.isCollectionClass(referenceClass) || this.isMapClass(referenceClass)) {
            this.processSerialized(mapping, referenceClass, this.getMetadataClass(Blob.class), isForMapKey);
        } else {
            super.processLob(lob, mapping, referenceClass, isForMapKey);
        }
    }

    protected void processReturnInsert() {
        if (this.m_returnInsert != null) {
            this.m_returnInsert.process(this.getDescriptor(), this.m_field);
        }
    }

    protected void processReturnUpdate() {
        if (this.isReturnUpdate()) {
            this.getDescriptor().addFieldForUpdate(this.m_field);
        }
    }

    public void setColumn(ColumnMetadata column) {
        this.m_column = column;
    }

    public void setGeneratedValue(GeneratedValueMetadata value) {
        this.m_generatedValue = value;
    }

    public void setMutable(Boolean mutable) {
        this.m_mutable = mutable;
    }

    public void setReturnInsert(ReturnInsertMetadata returnInsert) {
        this.m_returnInsert = returnInsert;
    }

    public void setReturnUpdate(String ignore) {
        this.m_returnUpdate = true;
    }

    public void setSequenceGenerator(SequenceGeneratorMetadata sequenceGenerator) {
        this.m_sequenceGenerator = sequenceGenerator;
    }

    public void setTableGenerator(TableGeneratorMetadata tableGenerator) {
        this.m_tableGenerator = tableGenerator;
    }
}

