/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.CLIProcessExecutor;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.optional.DatabaseCommand;
import com.sun.enterprise.admin.cli.util.CLIUtil;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.OS;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="stop-database")
@Scoped(value=PerLookup.class)
public final class StopDatabaseCommand
extends DatabaseCommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(StopDatabaseCommand.class);

    protected void prepare() throws CommandException, CommandValidationException {
        LinkedHashSet opts = new LinkedHashSet();
        StopDatabaseCommand.addOption(opts, (String)"dbhost", (char)'\u0000', (String)"STRING", (boolean)false, (String)"0.0.0.0");
        StopDatabaseCommand.addOption(opts, (String)"dbport", (char)'\u0000', (String)"STRING", (boolean)false, (String)"1527");
        StopDatabaseCommand.addOption(opts, (String)"dbuser", (char)'\u0000', (String)"STRING", (boolean)false, null);
        StopDatabaseCommand.addOption(opts, (String)"dbpasswordfile", (char)'\u0000', (String)"FILE", (boolean)false, null);
        StopDatabaseCommand.addOption(opts, (String)"help", (char)'?', (String)"BOOLEAN", (boolean)false, (String)"false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 0;
        this.processProgramOptions();
    }

    public String[] stopDatabaseCmd() throws Exception {
        this.dbUser = this.getOption("dbuser");
        this.passwords = new HashMap();
        String dbPasswordFile = this.getOption("dbpasswordfile");
        if (StopDatabaseCommand.ok((String)dbPasswordFile)) {
            this.passwords = CLIUtil.readPasswordFileOptions((String)dbPasswordFile, (boolean)true);
            this.dbPassword = (String)this.passwords.get("AS_ADMIN_DBPASSWORD");
        }
        if (this.dbUser == null && this.dbPassword == null) {
            if (OS.isDarwin()) {
                return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-Dderby.storage.fileSyncTransactionLog=True", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.admin.cli.optional.DerbyControl", "shutdown", this.dbHost, this.dbPort, "false"};
            }
            return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.admin.cli.optional.DerbyControl", "shutdown", this.dbHost, this.dbPort, "false"};
        }
        if (OS.isDarwin()) {
            return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-Dderby.storage.fileSyncTransactionLog=True", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.admin.cli.optional.DerbyControl", "shutdown", this.dbHost, this.dbPort, "false", this.dbUser, this.dbPassword};
        }
        return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.admin.cli.optional.DerbyControl", "shutdown", this.dbHost, this.dbPort, "false", this.dbUser, this.dbPassword};
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            this.prepareProcessExecutor();
            CLIProcessExecutor cpe = new CLIProcessExecutor();
            cpe.execute("pingDatabaseCmd", this.pingDatabaseCmd(false), true);
            if (cpe.exitValue() > 0) {
                throw new CommandException(strings.get("StopDatabaseStatus", new Object[]{this.dbHost, this.dbPort}));
            }
            if (cpe.exitValue() < 0) {
                throw new CommandException(strings.get("UnableToStopDatabase", new Object[]{"derby.log"}));
            }
            cpe.execute("stopDatabaseCmd", this.stopDatabaseCmd(), true);
            if (cpe.exitValue() > 0) {
                throw new CommandException(strings.get("UnableToStopDatabase", new Object[]{"derby.log"}));
            }
        }
        catch (Exception e) {
            throw new CommandException(strings.get("UnableToStopDatabase", new Object[]{"derby.log"}), (Throwable)e);
        }
        return 0;
    }
}

