/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.config.GrizzlyEmbeddedHttps;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.grizzly.util.ClassLoaderUtil;
import com.sun.grizzly.util.net.SSLImplementation;
import com.sun.grizzly.util.net.ServerSocketFactory;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class SSLConfigHolder {
    public static final String APP_BUFFER_ATTR_NAME = "TMP_DECODED_BUFFER";
    private static final Logger logger = GrizzlyEmbeddedHttps.logger();
    protected SSLImplementation sslImplementation;
    protected SSLContext sslContext;
    protected String[] enabledCipherSuites = null;
    protected String[] enabledProtocols = null;
    protected boolean clientMode = false;
    protected boolean needClientAuth = false;
    protected boolean wantClientAuth = false;

    public void setSSLConfig(SSLConfig sslConfig) {
        this.sslContext = sslConfig.createSSLContext();
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setSSLImplementation(SSLImplementation sslImplementation) {
        this.sslImplementation = sslImplementation;
    }

    public SSLImplementation getSSLImplementation() {
        return this.sslImplementation;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public SSLEngine createSSLEngine() {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "newSSLEngine: " + sslEngine);
        }
        if (this.enabledCipherSuites != null) {
            sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            sslEngine.setEnabledProtocols(this.enabledProtocols);
        }
        sslEngine.setUseClientMode(this.clientMode);
        sslEngine.setWantClientAuth(this.wantClientAuth);
        sslEngine.setNeedClientAuth(this.needClientAuth);
        return sslEngine;
    }

    public static SSLConfigHolder configureSSL(Ssl ssl) {
        SSLConfigHolder config = new SSLConfigHolder();
        if (SSLConfigHolder.configureSSL(ssl, config)) {
            return config;
        }
        return null;
    }

    public static boolean configureSSL(Ssl ssl, SSLConfigHolder sslConfigHolder) {
        LinkedList<String> tmpSSLArtifactsList = new LinkedList<String>();
        if (ssl != null) {
            String ssl2Ciphers;
            if (Boolean.parseBoolean(ssl.getClientAuthEnabled())) {
                sslConfigHolder.setNeedClientAuth(true);
            }
            if (Boolean.parseBoolean(ssl.getSsl2Enabled())) {
                tmpSSLArtifactsList.add("SSLv2");
            }
            if (Boolean.parseBoolean(ssl.getSsl3Enabled())) {
                tmpSSLArtifactsList.add("SSLv3");
            }
            if (Boolean.parseBoolean(ssl.getTlsEnabled())) {
                tmpSSLArtifactsList.add("TLSv1");
            }
            if (Boolean.parseBoolean(ssl.getSsl3Enabled()) || Boolean.parseBoolean(ssl.getTlsEnabled())) {
                tmpSSLArtifactsList.add("SSLv2Hello");
            }
            if (tmpSSLArtifactsList.isEmpty()) {
                logger.log(Level.CONFIG, "pewebcontainer.all_ssl_protocols_disabled", ((Protocol)ssl.getParent()).getName());
            } else {
                String[] protocols = new String[tmpSSLArtifactsList.size()];
                tmpSSLArtifactsList.toArray(protocols);
                sslConfigHolder.setEnabledProtocols(protocols);
            }
            String auth = ssl.getClientAuth();
            if (auth != null) {
                if ("want".equalsIgnoreCase(auth.trim())) {
                    sslConfigHolder.setWantClientAuth(true);
                } else if ("need".equalsIgnoreCase(auth.trim())) {
                    sslConfigHolder.setNeedClientAuth(true);
                }
            }
            if (ssl.getClassname() != null) {
                SSLImplementation impl = (SSLImplementation)ClassLoaderUtil.load(ssl.getClassname());
                if (impl != null) {
                    sslConfigHolder.setSSLImplementation(impl);
                } else {
                    logger.log(Level.WARNING, "Unable to load SSLImplementation");
                }
            }
            tmpSSLArtifactsList.clear();
            String ssl3Ciphers = ssl.getSsl3TlsCiphers();
            if (ssl3Ciphers != null && ssl3Ciphers.length() > 0) {
                String[] ssl3CiphersArray;
                for (String cipher : ssl3CiphersArray = ssl3Ciphers.split(",")) {
                    tmpSSLArtifactsList.add(cipher.trim());
                }
            }
            if ((ssl2Ciphers = ssl.getSsl2Ciphers()) != null && ssl2Ciphers.length() > 0) {
                String[] ssl2CiphersArray;
                for (String cipher : ssl2CiphersArray = ssl2Ciphers.split(",")) {
                    tmpSSLArtifactsList.add(cipher.trim());
                }
            }
            if (tmpSSLArtifactsList.isEmpty()) {
                logger.log(Level.WARNING, "pewebcontainer.all_ssl_ciphers_disabled", ((Protocol)ssl.getParent()).getName());
            } else {
                String[] enabledCiphers = new String[tmpSSLArtifactsList.size()];
                tmpSSLArtifactsList.toArray(enabledCiphers);
                sslConfigHolder.setEnabledCipherSuites(enabledCiphers);
            }
        }
        try {
            SSLConfigHolder.initializeSSL(ssl, sslConfigHolder);
            return true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "SSL support could not be configured!", e);
            return false;
        }
    }

    private static void initializeSSL(Ssl ssl, SSLConfigHolder sslConfigHolder) throws Exception {
        SSLImplementation sslHelper = SSLImplementation.getInstance();
        ServerSocketFactory serverSF = sslHelper.getServerSocketFactory();
        if (ssl != null) {
            if (ssl.getCrlFile() != null) {
                SSLConfigHolder.setAttribute(serverSF, "crlFile", ssl.getCrlFile(), null, null);
            }
            if (ssl.getTrustAlgorithm() != null) {
                SSLConfigHolder.setAttribute(serverSF, "trustAlgorithm", ssl.getTrustAlgorithm(), null, null);
            }
            SSLConfigHolder.setAttribute(serverSF, "trustMaxCertLength", ssl.getTrustMaxCertLength(), null, null);
        }
        SSLConfigHolder.setAttribute(serverSF, "keystore", ssl != null ? ssl.getKeyStore() : null, "javax.net.ssl.keyStore", null);
        SSLConfigHolder.setAttribute(serverSF, "keystoreType", ssl != null ? ssl.getKeyStoreType() : null, "javax.net.ssl.keyStoreType", "JKS");
        SSLConfigHolder.setAttribute(serverSF, "keystorePass", ssl != null ? ssl.getKeyStorePassword() : null, "javax.net.ssl.keyStorePassword", "changeit");
        SSLConfigHolder.setAttribute(serverSF, "truststore", ssl != null ? ssl.getTrustStore() : null, "javax.net.ssl.trustStore", null);
        SSLConfigHolder.setAttribute(serverSF, "truststoreType", ssl != null ? ssl.getTrustStoreType() : null, "javax.net.ssl.trustStoreType", "JKS");
        SSLConfigHolder.setAttribute(serverSF, "truststorePass", ssl != null ? ssl.getTrustStorePassword() : null, "javax.net.ssl.trustStorePassword", "changeit");
        serverSF.setAttribute("keyAlias", ssl != null ? ssl.getCertNickname() : null);
        serverSF.init();
        sslConfigHolder.setSSLImplementation(sslHelper);
        sslConfigHolder.setSSLContext(serverSF.getSSLContext());
    }

    public static boolean isAllowLazyInit(Ssl ssl) {
        return ssl == null || Boolean.parseBoolean(ssl.getAllowLazyInit());
    }

    private static void setAttribute(ServerSocketFactory serverSF, String name, String value, String property, String defaultValue) {
        serverSF.setAttribute(name, value == null ? System.getProperty(property, defaultValue) : value);
    }
}

