/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet;

import com.sun.grizzly.http.servlet.FilterChainImpl;
import com.sun.grizzly.http.servlet.FilterConfigImpl;
import com.sun.grizzly.http.servlet.HttpServletRequestImpl;
import com.sun.grizzly.http.servlet.HttpServletResponseImpl;
import com.sun.grizzly.http.servlet.ServletConfigImpl;
import com.sun.grizzly.http.servlet.ServletContextImpl;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.ClassLoaderUtil;
import com.sun.grizzly.util.Grizzly;
import com.sun.grizzly.util.IntrospectionUtils;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.Cookie;
import com.sun.grizzly.util.http.HttpRequestURIDecoder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletAdapter
extends GrizzlyAdapter {
    public static final int REQUEST_RESPONSE_NOTES = 29;
    public static final int SERVLETCONFIG_NOTES = 30;
    public static final String LOAD_ON_STARTUP = "load-on-startup";
    protected volatile Servlet servletInstance = null;
    private FilterChainImpl filterChain = new FilterChainImpl();
    private transient ArrayList<String> listeners;
    private String servletPath = "";
    private String contextPath = "";
    private boolean loadOnStartup = false;
    private HashMap<String, String> contextParameters;
    private HashMap<String, String> servletInitParameters;
    private volatile boolean filterChainConfigured = false;
    private ReentrantLock filterChainReady = new ReentrantLock();
    private final ServletContextImpl servletCtx;
    private ServletConfigImpl servletConfig;
    protected HashMap<String, Object> properties = new HashMap();
    protected boolean initialize = true;
    protected ClassLoader classLoader;

    public ServletAdapter() {
        this(".");
    }

    public ServletAdapter(Servlet servlet) {
        this(".");
        this.servletInstance = servlet;
    }

    public ServletAdapter(String publicDirectory) {
        this(publicDirectory, new ServletContextImpl(), new HashMap<String, String>(), new HashMap<String, String>(), new ArrayList<String>());
    }

    protected ServletAdapter(String publicDirectory, ServletContextImpl servletCtx, HashMap<String, String> contextParameters, HashMap<String, String> servletInitParameters, ArrayList<String> listeners) {
        this(publicDirectory, servletCtx, contextParameters, servletInitParameters, listeners, true);
    }

    protected ServletAdapter(String publicDirectory, ServletContextImpl servletCtx, HashMap<String, String> contextParameters, HashMap<String, String> servletInitParameters, ArrayList<String> listeners, boolean initialize) {
        super(publicDirectory);
        this.servletCtx = servletCtx;
        this.servletConfig = new ServletConfigImpl(servletCtx, servletInitParameters);
        this.contextParameters = contextParameters;
        this.servletInitParameters = servletInitParameters;
        this.listeners = listeners;
        this.initialize = initialize;
    }

    protected ServletAdapter(String publicDirectory, ServletContextImpl servletCtx, HashMap<String, String> contextParameters, HashMap<String, String> servletInitParameters, boolean initialize) {
        super(publicDirectory);
        this.servletCtx = servletCtx;
        this.servletConfig = new ServletConfigImpl(servletCtx, servletInitParameters);
        this.contextParameters = contextParameters;
        this.servletInitParameters = servletInitParameters;
        this.initialize = initialize;
    }

    public ServletAdapter(Servlet servlet, ServletContextImpl servletContext) {
        super(".");
        this.servletInstance = servlet;
        this.servletCtx = servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        block9: {
            try {
                if (this.initialize) {
                    this.initWebDir();
                    this.configureClassLoader(((File)this.fileFolders.peek()).getCanonicalPath());
                }
                if (this.classLoader != null) {
                    ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.classLoader);
                    try {
                        this.configureServletEnv();
                        this.setResourcesContextPath(this.contextPath);
                        if (this.loadOnStartup) {
                            this.loadServlet();
                        }
                        break block9;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(prevClassLoader);
                    }
                }
                this.configureServletEnv();
                this.setResourcesContextPath(this.contextPath);
                if (this.loadOnStartup) {
                    this.loadServlet();
                }
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "start", t);
            }
        }
    }

    protected void configureClassLoader(String applicationPath) throws IOException {
        if (this.classLoader == null) {
            this.classLoader = ClassLoaderUtil.createURLClassLoader((String)applicationPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(GrizzlyRequest request, GrizzlyResponse response) {
        if (this.classLoader != null) {
            ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                this.doService(request, response);
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevClassLoader);
            }
        } else {
            this.doService(request, response);
        }
    }

    public void doService(GrizzlyRequest request, GrizzlyResponse response) {
        try {
            Cookie[] cookies;
            Request req = request.getRequest();
            Response res = response.getResponse();
            String uri = request.getRequestURI();
            if (!uri.startsWith(this.contextPath)) {
                this.customizeErrorPage(response, "Resource Not Found", 404);
                return;
            }
            HttpServletRequestImpl httpRequest = (HttpServletRequestImpl)req.getNote(29);
            HttpServletResponseImpl httpResponse = (HttpServletResponseImpl)res.getNote(29);
            if (httpRequest == null) {
                httpRequest = new HttpServletRequestImpl(request);
                httpResponse = new HttpServletResponseImpl(response);
                req.setNote(29, (Object)httpRequest);
                res.setNote(29, (Object)httpResponse);
            }
            if ((cookies = request.getCookies()) != null) {
                for (Cookie c : cookies) {
                    if (!"JSESSIONID".equals(c.getName())) continue;
                    request.setRequestedSessionId(c.getValue());
                    request.setRequestedSessionCookie(true);
                    break;
                }
            }
            this.loadServlet();
            httpRequest.setContextImpl(this.servletCtx);
            httpRequest.setServletPath(this.servletPath);
            httpRequest.initSession();
            httpResponse.addHeader("server", "grizzly/" + Grizzly.getDotedVersion());
            this.filterChain.invokeFilterChain((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        catch (Throwable ex) {
            this.logger.log(Level.SEVERE, "service exception:", ex);
            this.customizeErrorPage(response, "Internal Error", 500);
        }
    }

    public void customizeErrorPage(GrizzlyResponse response, String message, int errorCode) {
        response.setStatus(errorCode, message);
        response.setContentType("text/html");
        try {
            response.getWriter().write("<html><body><h1>" + message + "</h1></body></html>");
            response.getWriter().flush();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadServlet() throws ServletException {
        try {
            this.filterChainReady.lock();
            if (this.filterChainConfigured) {
                return;
            }
            if (this.servletInstance == null) {
                String servletClassName = System.getProperty("com.sun.grizzly.servletClass");
                if (servletClassName != null) {
                    this.servletInstance = (Servlet)ClassLoaderUtil.load((String)servletClassName);
                }
                if (this.servletInstance != null) {
                    this.logger.info("Loading Servlet: " + this.servletInstance.getClass().getName());
                }
            }
            if (this.servletInstance != null) {
                this.servletInstance.init((ServletConfig)this.servletConfig);
            }
            this.filterChain.setServlet(this.servletConfig, this.servletInstance);
            this.filterChain.init();
            this.filterChainConfigured = true;
        }
        finally {
            this.filterChainReady.unlock();
        }
    }

    protected void configureServletEnv() throws ServletException {
        MessageBytes c = MessageBytes.newInstance();
        if (!this.contextPath.equals("")) {
            char[] ch = this.contextPath.toCharArray();
            c.setChars(ch, 0, ch.length);
            HttpRequestURIDecoder.normalize((MessageBytes)c);
            this.contextPath = c.getCharChunk().toString();
        }
        if (this.contextPath.equals("/")) {
            this.contextPath = "";
        }
        if (this.initialize) {
            this.servletCtx.setInitParameter(this.contextParameters);
            this.servletCtx.setContextPath(this.contextPath);
            this.servletCtx.setBasePath(this.getRootFolder() + File.separatorChar + this.contextPath);
            this.configureProperties(this.servletCtx);
            this.servletCtx.initListeners(this.listeners);
        }
        this.servletConfig.setInitParameters(this.servletInitParameters);
        this.configureProperties(this.servletConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterService(GrizzlyRequest request, GrizzlyResponse response) throws Exception {
        try {
            HttpServletRequestImpl httpRequest = (HttpServletRequestImpl)request.getRequest().getNote(29);
            HttpServletResponseImpl httpResponse = (HttpServletResponseImpl)response.getResponse().getNote(29);
            if (httpRequest != null) {
                httpRequest.recycle();
                httpResponse.recycle();
            }
        }
        finally {
            this.filterChain.recycle();
        }
    }

    public void addInitParameter(String name, String value) {
        this.servletInitParameters.put(name, value);
    }

    public void addContextParameter(String name, String value) {
        this.contextParameters.put(name, value);
    }

    public void addFilter(Filter filter, String filterName, Map initParameters) {
        FilterConfigImpl filterConfig = new FilterConfigImpl(this.servletCtx);
        filterConfig.setFilter(filter);
        filterConfig.setFilterName(filterName);
        filterConfig.setInitParameters(initParameters);
        this.filterChain.addFilter(filterConfig);
    }

    public Servlet getServletInstance() {
        return this.servletInstance;
    }

    public void setServletInstance(Servlet servletInstance) {
        this.servletInstance = servletInstance;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
        if (!servletPath.equals("") && !servletPath.startsWith("/")) {
            servletPath = "/" + servletPath;
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void addServletListener(String listenerName) {
        if (listenerName == null) {
            return;
        }
        this.listeners.add(listenerName);
    }

    public boolean removeServletListener(String listenerName) {
        return listenerName != null && this.listeners.remove(listenerName);
    }

    private void configureProperties(Object object) {
        for (String s : this.properties.keySet()) {
            String value = this.properties.get(s).toString();
            IntrospectionUtils.setProperty((Object)object, (String)s, (String)value);
        }
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        int pos;
        if (name.equalsIgnoreCase(LOAD_ON_STARTUP) && value != null && new Integer(value.toString()) <= 1) {
            this.loadOnStartup = true;
        }
        if ((pos = name.indexOf("-")) > 0) {
            String pre = name.substring(0, pos);
            String post = name.substring(pos + 1, pos + 2).toUpperCase() + name.substring(pos + 2);
            name = pre + post;
        }
        this.properties.put(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.classLoader != null) {
            ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                super.destroy();
                this.servletCtx.destroyListeners();
                this.filterChain.destroy();
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevClassLoader);
            }
        } else {
            super.destroy();
            this.servletCtx.destroyListeners();
            this.filterChain.destroy();
        }
    }

    public ServletAdapter newServletAdapter(Servlet servlet) {
        ServletAdapter sa = new ServletAdapter(".", this.servletCtx, this.contextParameters, new HashMap<String, String>(), this.listeners, false);
        if (this.classLoader != null) {
            sa.setClassLoader(this.classLoader);
        }
        sa.setServletInstance(servlet);
        sa.setServletPath(this.servletPath);
        return sa;
    }

    protected ServletContextImpl getServletCtx() {
        return this.servletCtx;
    }

    protected ArrayList<String> getListeners() {
        return this.listeners;
    }

    protected HashMap<String, String> getContextParameters() {
        return this.contextParameters;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

