/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.web.WebApplication;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import java.util.Dictionary;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.glassfish.api.ActionReport;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.osgijavaeebase.OSGiApplicationInfo;
import org.glassfish.osgijavaeebase.OSGiContainer;
import org.glassfish.osgijavaeebase.OSGiDeploymentRequest;
import org.glassfish.osgijavaeebase.OSGiUndeploymentRequest;
import org.glassfish.osgiweb.OSGiWebDeploymentRequest;
import org.glassfish.osgiweb.OSGiWebUndeploymentRequest;
import org.glassfish.server.ServerEnvironmentImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OSGiWebContainer
extends OSGiContainer {
    private static final Logger logger = Logger.getLogger(OSGiWebContainer.class.getPackage().getName());
    private ThreadLocal<BundleContext> currentBundleContext = new ThreadLocal();

    public OSGiWebContainer(BundleContext ctx) {
        super(ctx);
    }

    protected void preDeploy(Bundle b) {
        this.currentBundleContext.set(b.getBundleContext());
    }

    protected void postDeploy(OSGiApplicationInfo osgiAppInfo) {
        assert (osgiAppInfo != null);
        ServletContext sc = this.getServletContext(osgiAppInfo.getAppInfo());
        assert (sc.getAttribute("osgi-bundlecontext") == osgiAppInfo.getBundle().getBundleContext());
        this.registerService(osgiAppInfo.getBundle(), sc);
    }

    protected OSGiUndeploymentRequest createOSGiUndeploymentRequest(Deployment deployer, ServerEnvironmentImpl env, ActionReport reporter, OSGiApplicationInfo osgiAppInfo) {
        return new OSGiWebUndeploymentRequest(deployer, env, reporter, osgiAppInfo);
    }

    protected OSGiDeploymentRequest createOSGiDeploymentRequest(Deployment deployer, ArchiveFactory archiveFactory, ServerEnvironmentImpl env, ActionReport reporter, Bundle b) {
        return new OSGiWebDeploymentRequest(deployer, archiveFactory, env, reporter, b);
    }

    private ServletContext getServletContext(ApplicationInfo appInfo) {
        if (appInfo.getModuleInfos().size() == 1) {
            ModuleInfo m = (ModuleInfo)appInfo.getModuleInfos().iterator().next();
            EngineRef e = m.getEngineRefForContainer(WebContainer.class);
            assert (e != null);
            WebApplication a = (WebApplication)e.getApplicationContainer();
            Set wms = a.getWebModules();
            assert (wms.size() == 1);
            if (wms.size() == 1) {
                return ((WebModule)wms.iterator().next()).getServletContext();
            }
        }
        return null;
    }

    private void registerService(Bundle b, ServletContext sc) {
        BundleContext bctx;
        Properties props = new Properties();
        props.setProperty("osgi.web.symbolicname", b.getSymbolicName());
        String cpath = (String)b.getHeaders().get("Web-ContextPath");
        props.setProperty("osgi.web.contextpath", cpath);
        String version = (String)b.getHeaders().get("Bundle-Version");
        if (version != null) {
            props.setProperty("osgi.web.version", version);
        }
        if ((bctx = b.getBundleContext()) != null) {
            bctx.registerService(ServletContext.class.getName(), (Object)sc, (Dictionary)props);
            logger.logp(Level.INFO, "OSGiWebContainer", "registerService", "Registered ServletContext as a service with properties: {0} ", new Object[]{props});
        } else {
            logger.logp(Level.WARNING, "OSGiWebContainer", "registerService", "Not able to register ServletContext as a service as bctx is null");
        }
    }

    BundleContext getCurrentBundleContext() {
        return this.currentBundleContext.get();
    }
}

