/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import com.sun.hk2.component.InjectionResolver;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.logging.Logger;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.component.UnsatisfiedDepedencyException;

public class InjectionManager {
    public void inject(Object component, InjectionResolver ... targets) {
        this.inject(component, component.getClass(), targets);
    }

    public void inject(Object component, Class type, InjectionResolver ... targets) {
        try {
            assert (component != null);
            for (Class currentClass = type; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
                Injectable injectable;
                Object value;
                Object inject;
                for (Field field : currentClass.getDeclaredFields()) {
                    for (InjectionResolver target : targets) {
                        inject = field.getAnnotation(target.type);
                        if (inject == null) continue;
                        Class<?> fieldType = field.getType();
                        try {
                            value = target.getValue(component, field, fieldType);
                            if (value != null) {
                                field.setAccessible(true);
                                field.set(component, value);
                                try {
                                    injectable = (Injectable)Injectable.class.cast(value);
                                    if (injectable != null) {
                                        injectable.injectedInto(component);
                                    }
                                }
                                catch (Exception e) {}
                                continue;
                            }
                            if (target.isOptional(field, inject)) continue;
                            Logger.getAnonymousLogger().info("Cannot inject " + field + " in component" + component);
                            throw new UnsatisfiedDepedencyException(field);
                        }
                        catch (ComponentException e) {
                            if (target.isOptional(field, inject)) continue;
                            throw new UnsatisfiedDepedencyException(field, (Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            throw new ComponentException("Injection failed on " + field.toGenericString(), e);
                        }
                        catch (RuntimeException e) {
                            throw new ComponentException("Injection failed on " + field.toGenericString(), e);
                        }
                    }
                }
                for (AccessibleObject accessibleObject : currentClass.getDeclaredMethods()) {
                    for (InjectionResolver target : targets) {
                        inject = ((Method)accessibleObject).getAnnotation(target.type);
                        if (inject == null) continue;
                        if (((Method)accessibleObject).getReturnType() != Void.TYPE) {
                            if (Collection.class.isAssignableFrom(((Method)accessibleObject).getReturnType())) {
                                this.injectCollection(component, (Method)accessibleObject, target.getValue(component, accessibleObject, ((Method)accessibleObject).getReturnType()));
                                continue;
                            }
                            throw new ComponentException("Injection failed on %s : setter method is not declared with a void return type", ((Method)accessibleObject).toGenericString());
                        }
                        Class<?>[] paramTypes = ((Method)accessibleObject).getParameterTypes();
                        if (paramTypes.length > 1) {
                            throw new ComponentException("injection failed on %s : setter method takes more than 1 parameter", ((Method)accessibleObject).toGenericString());
                        }
                        if (paramTypes.length == 0) {
                            throw new ComponentException("injection failed on %s : setter method does not take a parameter", ((Method)accessibleObject).toGenericString());
                        }
                        try {
                            value = target.getValue(component, accessibleObject, paramTypes[0]);
                            if (value != null) {
                                ((Method)accessibleObject).setAccessible(true);
                                ((Method)accessibleObject).invoke(component, value);
                                try {
                                    injectable = (Injectable)Injectable.class.cast(value);
                                    if (injectable != null) {
                                        injectable.injectedInto(component);
                                    }
                                }
                                catch (Exception e) {}
                                continue;
                            }
                            if (target.isOptional(accessibleObject, inject)) continue;
                            throw new UnsatisfiedDepedencyException((Method)accessibleObject);
                        }
                        catch (IllegalAccessException e) {
                            throw new ComponentException("Injection failed on " + ((Method)accessibleObject).toGenericString(), e);
                        }
                        catch (InvocationTargetException e) {
                            throw new ComponentException("Injection failed on " + ((Method)accessibleObject).toGenericString(), e);
                        }
                        catch (RuntimeException e) {
                            throw new ComponentException("Injection failed on " + ((Method)accessibleObject).toGenericString(), e);
                        }
                    }
                }
            }
        }
        catch (LinkageError e) {
            Class cls = type;
            LinkageError x = new LinkageError("Failed to inject " + cls + " from " + cls.getClassLoader());
            x.initCause(e);
            throw x;
        }
    }

    private void injectCollection(Object component, Method method, Object value) {
        if (value == null) {
            return;
        }
        Collection c = (Collection)Collection.class.cast(value);
        Collection target = null;
        try {
            target = (Collection)Collection.class.cast(method.invoke(component, new Object[0]));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return;
        }
        target.addAll(c);
    }
}

