/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgimain;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.osgimain.Jar;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main
implements BundleActivator {
    public static final String BUNDLES_DIR = "org.jvnet.hk2.osgimain.bundlesDir";
    public static final String EXCLUDED_SUBDIRS = "org.jvnet.hk2.osgimain.excludedSubDirs";
    public static final String HK2_CACHE_DIR = "com.sun.enterprise.hk2.cacheDir";
    public static final String INHABITANTS_CACHE = "inhabitants";
    public static final String AUTO_START_BUNDLES_PROP = "org.jvnet.hk2.osgimain.autostartBundles";
    private static final Logger logger = Logger.getLogger(Main.class.getPackage().getName());
    private BundleContext context;
    private File bundlesDir;
    private Collection<File> excludedSubDirs = new HashSet<File>();
    private List<URI> autoStartBundleLocations = new ArrayList<URI>();
    private Map<URI, Jar> currentManagedBundles = new HashMap<URI, Jar>();
    private static final String THIS_JAR_NAME = "osgi-main.jar";

    public void start(BundleContext context) throws Exception {
        String excludedFilesProp;
        this.context = context;
        this.bundlesDir = new File(context.getProperty(BUNDLES_DIR));
        if (this.bundlesDir == null) {
            return;
        }
        String autostartBundlesProp = context.getProperty(AUTO_START_BUNDLES_PROP);
        if (autostartBundlesProp != null) {
            String bundleRelPath;
            StringTokenizer st = new StringTokenizer(autostartBundlesProp, ",");
            while (st.hasMoreTokens() && !(bundleRelPath = st.nextToken().trim()).isEmpty()) {
                URI bundleURI = new File(this.bundlesDir, bundleRelPath).toURI().normalize();
                this.autoStartBundleLocations.add(bundleURI);
            }
        }
        if ((excludedFilesProp = context.getProperty(EXCLUDED_SUBDIRS)) != null) {
            for (String s : excludedFilesProp.split(",")) {
                this.excludedSubDirs.add(new File(this.bundlesDir, s.trim()));
            }
        }
        this.traverse();
        for (URI location : this.autoStartBundleLocations) {
            long id = this.currentManagedBundles.get(location).getBundleId();
            if (id < 0L) {
                logger.logp(Level.WARNING, "Main", "start", "Not able to locate autostart bundle for location = {0}", new Object[]{location});
                continue;
            }
            Bundle bundle = context.getBundle(id);
            if (bundle == null) continue;
            try {
                bundle.start(1);
            }
            catch (BundleException e) {
                logger.logp(Level.WARNING, "Main", "start", "Exception while starting bundle " + bundle, e);
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        ArrayList<URI> bundlesToStop = new ArrayList<URI>(this.autoStartBundleLocations);
        Collections.reverse(bundlesToStop);
        for (URI location : bundlesToStop) {
            long id = this.currentManagedBundles.get(location).getBundleId();
            if (id < 0L) {
                logger.logp(Level.WARNING, "Main", "stop", "Not able to locate autostart bundle for location = {0}", new Object[]{location});
                continue;
            }
            Bundle bundle = context.getBundle(id);
            if (bundle == null) continue;
            bundle.stop();
        }
    }

    private Set<Jar> discoverJars() {
        final HashSet<Jar> jars = new HashSet<Jar>();
        this.bundlesDir.listFiles(new FileFilter(){
            final String JAR_EXT = ".jar";

            public boolean accept(File file) {
                if (file.isDirectory() && !Main.this.excludedSubDirs.contains(file)) {
                    file.listFiles(this);
                } else if (file.isFile() && file.getName().endsWith(".jar") && !file.getName().equals(Main.THIS_JAR_NAME)) {
                    jars.add(new Jar(file));
                    return true;
                }
                return false;
            }
        });
        return jars;
    }

    private void initCurrentManagedBundles() {
        Bundle[] bundles = this.context.getBundles();
        String watchedDirPath = this.bundlesDir.toURI().normalize().getPath();
        long thisBundleId = this.context.getBundle().getBundleId();
        for (Bundle bundle : bundles) {
            try {
                Jar jar;
                String path;
                long id = bundle.getBundleId();
                if (id == 0L || id == thisBundleId || (path = (jar = new Jar(bundle)).getPath()) == null || !path.regionMatches(0, watchedDirPath, 0, watchedDirPath.length())) continue;
                this.currentManagedBundles.put(jar.getURI(), jar);
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
    }

    private void traverse() {
        this.initCurrentManagedBundles();
        Collection<Jar> current = this.currentManagedBundles.values();
        Set<Jar> discovered = this.discoverJars();
        HashSet<Jar> newBundles = new HashSet<Jar>(discovered);
        newBundles.removeAll(current);
        HashSet<Jar> deletedBundles = new HashSet<Jar>(current);
        deletedBundles.removeAll(discovered);
        HashSet<Jar> existingBundles = new HashSet<Jar>(discovered);
        existingBundles.retainAll(current);
        this.uninstall(deletedBundles);
        int updated = this.update(existingBundles);
        this.install(newBundles);
        if (newBundles.size() + deletedBundles.size() + updated > 0) {
            this.refresh();
        }
    }

    private void uninstall(Collection<Jar> bundles) {
        for (Jar jar : bundles) {
            Bundle bundle = this.context.getBundle(jar.getBundleId());
            if (bundle == null || this.isExcludedFile(new File(jar.getPath()))) continue;
            try {
                bundle.uninstall();
                logger.logp(Level.INFO, "Main", "uninstall", "Uninstalled bundle {0} installed from {1} ", new Object[]{bundle.getBundleId(), jar.getPath()});
            }
            catch (Exception e) {
                logger.logp(Level.WARNING, "Main", "uninstall", "Failed to uninstall bundle " + jar.getPath(), e);
            }
        }
    }

    private int update(Collection<Jar> jars) {
        int updated = 0;
        for (Jar jar : jars) {
            Bundle bundle;
            Jar existingJar;
            if (!jar.isNewer(existingJar = this.currentManagedBundles.get(jar.getURI())) || (bundle = this.context.getBundle(existingJar.getBundleId())) == null) continue;
            try {
                bundle.update();
                ++updated;
                logger.logp(Level.INFO, "Main", "update", "Updated bundle {0} from {1} ", new Object[]{bundle.getBundleId(), jar.getPath()});
            }
            catch (Exception e) {
                logger.logp(Level.WARNING, "Main", "update", "Failed to update " + jar.getPath(), e);
            }
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install(Collection<Jar> jars) {
        for (Jar jar : jars) {
            try {
                String path = jar.getPath();
                File file = new File(path);
                FileInputStream is = new FileInputStream(file);
                try {
                    Bundle b = this.context.installBundle(jar.getURI().toString(), (InputStream)is);
                    this.currentManagedBundles.put(jar.getURI(), new Jar(b));
                    logger.logp(Level.FINE, "Main", "install", "Installed bundle {0} from {1} ", new Object[]{b.getBundleId(), jar.getURI()});
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            catch (Exception e) {
                logger.logp(Level.WARNING, "Main", "install", "Failed to install " + jar.getURI(), e);
            }
        }
    }

    private void refresh() {
        File inhabitantsCache;
        ServiceReference reference = this.context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin pa = (PackageAdmin)PackageAdmin.class.cast(this.context.getService(reference));
        pa.refreshPackages(null);
        this.context.ungetService(reference);
        String cacheDir = System.getProperty(HK2_CACHE_DIR);
        if (cacheDir != null && (inhabitantsCache = new File(cacheDir, INHABITANTS_CACHE)).exists()) {
            inhabitantsCache.delete();
        }
    }

    private boolean isExcludedFile(File f) {
        String path = f.getPath();
        for (File excludedSubDir : this.excludedSubDirs) {
            String excludedSubDirPath = excludedSubDir.getPath();
            if (!path.regionMatches(0, excludedSubDirPath, 0, excludedSubDirPath.length())) continue;
            return true;
        }
        return false;
    }
}

