/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.WeakObjectWrapper;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLObjectBuilder
extends ObjectBuilder {
    private Boolean isXMLDescriptor;

    public XMLObjectBuilder(ClassDescriptor descriptor) {
        super(descriptor);
    }

    public AbstractRecord buildRow(Object object, AbstractSession session, DatabaseField xmlField, XMLRecord parentRecord) {
        if (this.isXmlDescriptor() && ((XMLDescriptor)this.getDescriptor()).shouldPreserveDocument()) {
            CacheKey cacheKey;
            Object pk = this.extractPrimaryKeyFromObject(object, session);
            if (pk == null || pk instanceof CacheId && ((CacheId)pk).getPrimaryKey().length == 0) {
                pk = new CacheId(new Object[]{new WeakObjectWrapper(object)});
            }
            if ((cacheKey = session.getIdentityMapAccessorInstance().getCacheKeyForObject(pk, this.getDescriptor().getJavaClass(), this.getDescriptor())) != null && cacheKey.getRecord() != null) {
                XMLRecord nestedRecord = (XMLRecord)cacheKey.getRecord();
                nestedRecord.setMarshaller(parentRecord.getMarshaller());
                nestedRecord.setLeafElementType(parentRecord.getLeafElementType());
                parentRecord.setLeafElementType(null);
                return this.buildIntoNestedRow(nestedRecord, object, session);
            }
        }
        Element newNode = XPathEngine.getInstance().createUnownedElement(parentRecord.getDOM(), (XMLField)xmlField);
        DOMRecord nestedRecord = new DOMRecord(newNode);
        nestedRecord.setNamespaceResolver(parentRecord.getNamespaceResolver());
        nestedRecord.setMarshaller(parentRecord.getMarshaller());
        nestedRecord.setLeafElementType(parentRecord.getLeafElementType());
        parentRecord.setLeafElementType(null);
        return this.buildIntoNestedRow(nestedRecord, object, session);
    }

    public AbstractRecord createRecord(AbstractSession session) {
        return this.createRecord(this.getDescriptor().getTableName(), session);
    }

    public AbstractRecord createRecord(int size, AbstractSession session) {
        return this.createRecord(this.getDescriptor().getTableName(), session);
    }

    public AbstractRecord createRecord(String rootName, AbstractSession session) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        DOMRecord xmlRec = new DOMRecord(rootName, namespaceResolver);
        xmlRec.setSession(session);
        return xmlRec;
    }

    public AbstractRecord createRecord(String rootName, String rootUri, AbstractSession session) {
        DOMRecord xmlRec = new DOMRecord(rootName, rootUri);
        xmlRec.setSession(session);
        return xmlRec;
    }

    public AbstractRecord createRecord(String rootName, Node parent, AbstractSession session) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        DOMRecord xmlRec = new DOMRecord(rootName, namespaceResolver, parent);
        xmlRec.setSession(session);
        return xmlRec;
    }

    public AbstractRecord createRecordFor(Object attributeValue, XMLField xmlField, XMLRecord parentRecord, XMLMapping mapping) {
        DocumentPreservationPolicy policy = parentRecord.getDocPresPolicy();
        Element newNode = null;
        if (policy != null) {
            newNode = (Element)policy.getNodeForObject(attributeValue);
        }
        if (newNode == null) {
            newNode = XPathEngine.getInstance().createUnownedElement(parentRecord.getDOM(), xmlField);
            if (xmlField.isSelfField()) {
                policy.addObjectToCache(attributeValue, newNode, mapping);
            } else {
                policy.addObjectToCache(attributeValue, newNode);
            }
        }
        DOMRecord nestedRecord = new DOMRecord(newNode);
        nestedRecord.setMarshaller(parentRecord.getMarshaller());
        nestedRecord.setLeafElementType(parentRecord.getLeafElementType());
        parentRecord.setLeafElementType(null);
        nestedRecord.setDocPresPolicy(policy);
        nestedRecord.setXOPPackage(parentRecord.isXOPPackage());
        return nestedRecord;
    }

    public AbstractRecord createRecordFor(Object object, DocumentPreservationPolicy docPresPolicy) {
        Element cachedNode = null;
        DOMRecord record = null;
        if (docPresPolicy != null) {
            cachedNode = (Element)docPresPolicy.getNodeForObject(object);
        }
        if (cachedNode == null) {
            record = new DOMRecord(this.getDescriptor().getTableName(), this.getNamespaceResolver());
            docPresPolicy.addObjectToCache(object, ((XMLRecord)record).getDOM());
        } else {
            record = new DOMRecord(cachedNode);
        }
        record.setDocPresPolicy(docPresPolicy);
        return record;
    }

    public AbstractRecord createRecordFor(Object object, DocumentPreservationPolicy docPresPolicy, String rootName, String rootUri) {
        Element cachedNode = null;
        DOMRecord record = null;
        if (docPresPolicy != null) {
            cachedNode = (Element)docPresPolicy.getNodeForObject(object);
        }
        if (cachedNode == null) {
            record = new DOMRecord(rootName, rootUri);
            docPresPolicy.addObjectToCache(object, ((XMLRecord)record).getDOM());
        } else {
            record = new DOMRecord(cachedNode);
        }
        record.setDocPresPolicy(docPresPolicy);
        return record;
    }

    protected AbstractRecord createRecordForPKExtraction(int size, AbstractSession session) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        DOMRecord xmlRec = new DOMRecord(this.getDescriptor().getTableName(), namespaceResolver);
        xmlRec.setSession(session);
        return xmlRec;
    }

    public Object buildObject(ObjectBuildingQuery query, AbstractRecord databaseRow, JoinedAttributeManager joinManager) throws DatabaseException, QueryException {
        DocumentPreservationPolicy docPresPolicy;
        XMLRecord row = (XMLRecord)databaseRow;
        row.setSession(query.getSession());
        XMLUnmarshaller unmarshaller = row.getUnmarshaller();
        Object parent = row.getOwningObject();
        Object pk = this.extractPrimaryKeyFromRow(databaseRow, query.getSession());
        if (!this.isXmlDescriptor() && !this.getDescriptor().isDescriptorTypeAggregate()) {
            return super.buildObject(query, databaseRow, joinManager);
        }
        query.getSession().startOperationProfile("object building", query, Integer.MAX_VALUE);
        ClassDescriptor concreteDescriptor = this.getDescriptor();
        Object domainObject = null;
        if (concreteDescriptor.hasInheritance() && parent == null) {
            QName leafElementType;
            Class classValue = concreteDescriptor.getInheritancePolicy().classFromRow(databaseRow, query.getSession());
            if (classValue == null && this.isXmlDescriptor() && (leafElementType = ((XMLDescriptor)concreteDescriptor).getDefaultRootElementType()) != null) {
                Object indicator = concreteDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(leafElementType);
                if (indicator == null) {
                    throw DescriptorException.missingClassForIndicatorFieldValue(leafElementType, concreteDescriptor.getInheritancePolicy().getDescriptor());
                }
                classValue = (Class)indicator;
            }
            if (classValue != null) {
                concreteDescriptor = query.getSession().getDescriptor(classValue);
                if (concreteDescriptor == null && query.hasPartialAttributeExpressions()) {
                    concreteDescriptor = this.getDescriptor();
                }
                if (concreteDescriptor == null) {
                    throw QueryException.noDescriptorForClassFromInheritancePolicy(query, classValue);
                }
            } else if (Modifier.isAbstract(concreteDescriptor.getJavaClass().getModifiers())) {
                throw DescriptorException.missingClassIndicatorField(databaseRow, concreteDescriptor.getInheritancePolicy().getDescriptor());
            }
        }
        domainObject = concreteDescriptor.getObjectBuilder().buildNewInstance();
        row.setCurrentObject(domainObject);
        if (unmarshaller != null && unmarshaller.getUnmarshalListener() != null) {
            unmarshaller.getUnmarshalListener().beforeUnmarshal(domainObject, parent);
        }
        concreteDescriptor.getObjectBuilder().buildAttributesIntoObject(domainObject, databaseRow, query, joinManager, false);
        if (this.isXmlDescriptor() && ((XMLDescriptor)concreteDescriptor).getPrimaryKeyFieldNames().size() > 0) {
            if (pk == null || ((CacheId)pk).getPrimaryKey().length == 0) {
                pk = new CacheId(new Object[]{new WeakObjectWrapper(domainObject)});
            }
            CacheKey key = query.getSession().getIdentityMapAccessorInstance().acquireDeferredLock(pk, concreteDescriptor.getJavaClass(), concreteDescriptor);
            if (((XMLDescriptor)concreteDescriptor).shouldPreserveDocument()) {
                key.setRecord(databaseRow);
            }
            key.setObject(domainObject);
            key.releaseDeferredLock();
        }
        if ((docPresPolicy = ((DOMRecord)row).getDocPresPolicy()) != null) {
            ((DOMRecord)row).getDocPresPolicy().addObjectToCache(domainObject, ((DOMRecord)row).getDOM());
        }
        query.getSession().endOperationProfile("object building", query, Integer.MAX_VALUE);
        if (unmarshaller != null && unmarshaller.getUnmarshalListener() != null) {
            unmarshaller.getUnmarshalListener().afterUnmarshal(domainObject, parent);
        }
        return domainObject;
    }

    public AbstractRecord buildRow(AbstractRecord databaseRow, Object object, AbstractSession session) {
        return this.buildRow(databaseRow, object, session, false);
    }

    public AbstractRecord buildRow(AbstractRecord databaseRow, Object object, AbstractSession session, boolean wasXMLRoot) {
        XMLRecord row = (XMLRecord)databaseRow;
        row.setSession(session);
        XMLMarshaller marshaller = row.getMarshaller();
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().beforeMarshal(object);
        }
        this.writeOutMappings(row, object, session);
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(row);
        }
        this.addNamespaceDeclarations(row.getDocument());
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().afterMarshal(object);
        }
        return row;
    }

    public void writeOutMappings(XMLRecord row, Object object, AbstractSession session) {
        Vector<DatabaseMapping> mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            mapping.writeFromObjectIntoRow(object, row, session, DatabaseMapping.WriteType.UNDEFINED);
        }
    }

    public void addNamespaceDeclarations(Document document) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        if (namespaceResolver == null) {
            return;
        }
        Element docElement = document.getDocumentElement();
        if (namespaceResolver.getDefaultNamespaceURI() != null) {
            docElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespaceResolver.getDefaultNamespaceURI());
        }
        Enumeration prefixes = namespaceResolver.getPrefixes();
        while (prefixes.hasMoreElements()) {
            String prefix = (String)prefixes.nextElement();
            String namespace = namespaceResolver.resolveNamespacePrefix(prefix);
            docElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespace);
        }
    }

    public void buildAttributesIntoObject(Object domainObject, AbstractRecord databaseRow, ObjectBuildingQuery query, JoinedAttributeManager joinManager, boolean forRefresh) throws DatabaseException {
        ((XMLRecord)databaseRow).setSession(query.getSession().getExecutionSession(query));
        super.buildAttributesIntoObject(domainObject, databaseRow, query, joinManager, forRefresh);
    }

    public AbstractRecord extractPrimaryKeyRowFromExpression(Expression expression, AbstractRecord translationRow, AbstractSession session) {
        AbstractRecord primaryKeyRow = this.createRecord(this.getPrimaryKeyMappings().size(), session);
        expression.getBuilder().setSession(session.getRootSession(null));
        boolean isValid = expression.extractPrimaryKeyValues(true, this.getDescriptor(), primaryKeyRow, translationRow);
        if (!isValid) {
            return null;
        }
        if (primaryKeyRow.size() != this.getDescriptor().getPrimaryKeyFields().size()) {
            return null;
        }
        return primaryKeyRow;
    }

    public Object extractPrimaryKeyFromExpression(boolean requiresExactMatch, Expression expression, AbstractRecord translationRow, AbstractSession session) {
        AbstractRecord primaryKeyRow = this.createRecord(this.getPrimaryKeyMappings().size(), session);
        expression.getBuilder().setSession(session.getRootSession(null));
        boolean isValid = expression.extractPrimaryKeyValues(requiresExactMatch, this.getDescriptor(), primaryKeyRow, translationRow);
        if (requiresExactMatch && !isValid) {
            return null;
        }
        if (primaryKeyRow.size() != this.getDescriptor().getPrimaryKeyFields().size()) {
            return null;
        }
        return this.extractPrimaryKeyFromRow(primaryKeyRow, session);
    }

    public Object extractPrimaryKeyFromObject(Object domainObject, AbstractSession session) {
        if (this.getDescriptor().hasInheritance() && domainObject.getClass() != this.getDescriptor().getJavaClass() && !domainObject.getClass().getSuperclass().equals(this.getDescriptor().getJavaClass())) {
            return session.getDescriptor(domainObject.getClass()).getObjectBuilder().extractPrimaryKeyFromObject(domainObject, session);
        }
        if (this.getDescriptor().getPrimaryKeyFields().size() == 0) {
            return null;
        }
        return super.extractPrimaryKeyFromObject(domainObject, session);
    }

    public AbstractRecord buildIntoNestedRow(AbstractRecord row, Object object, AbstractSession session) {
        return this.buildIntoNestedRow(row, null, object, session, null, null, false);
    }

    public AbstractRecord buildIntoNestedRow(AbstractRecord row, Object object, AbstractSession session, XMLDescriptor refDesc, XMLField xmlField) {
        return this.buildIntoNestedRow(row, null, object, session, refDesc, xmlField, false);
    }

    public AbstractRecord buildIntoNestedRow(AbstractRecord row, Object originalObject, Object object, AbstractSession session, XMLDescriptor refDesc, XMLField xmlField, boolean wasXMLRoot) {
        XMLDescriptor xmlDescriptor;
        XMLRecord record = (XMLRecord)row;
        record.setSession(session);
        XMLMarshaller marshaller = record.getMarshaller();
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().beforeMarshal(object);
        }
        List extraNamespaces = null;
        if (this.isXmlDescriptor()) {
            xmlDescriptor = (XMLDescriptor)this.getDescriptor();
            extraNamespaces = this.addExtraNamespacesToNamespaceResolver(xmlDescriptor, record, session);
            this.writeExtraNamespaces(extraNamespaces, record);
            this.addXsiTypeAndClassIndicatorIfRequired(record, xmlDescriptor, refDesc, xmlField, originalObject, object, wasXMLRoot, false);
        }
        this.writeOutMappings(record, object, session);
        if (this.isXmlDescriptor()) {
            xmlDescriptor = (XMLDescriptor)this.getDescriptor();
            this.removeExtraNamespacesFromNamespaceResolver(record, extraNamespaces, session);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(row);
        }
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().afterMarshal(object);
        }
        return row;
    }

    protected void writeXsiTypeAttribute(XMLDescriptor xmlDescriptor, XMLRecord row, String typeValue, boolean addToNamespaceResolver) {
        String xsiPrefix = null;
        boolean generated = false;
        xsiPrefix = row.getNamespaceResolver().resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        if (xsiPrefix == null) {
            xsiPrefix = xmlDescriptor.getNonNullNamespaceResolver().generatePrefix("xsi");
            generated = true;
            this.writeNamespace(row, xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance", addToNamespaceResolver);
        }
        XMLField xmlField = (XMLField)xmlDescriptor.buildField(XMLConstants.ATTRIBUTE + xsiPrefix + ':' + "type");
        if (generated) {
            xmlField.getLastXPathFragment().setGeneratedPrefix(true);
        }
        xmlField.getLastXPathFragment().setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        row.add(xmlField, typeValue);
    }

    protected XMLField writeNamespace(XMLRecord nestedRecord, String prefix, String url, boolean addToNamespaceResolver) {
        XMLField xmlField = new XMLField("@xmlns:" + prefix);
        xmlField.setNamespaceResolver(nestedRecord.getNamespaceResolver());
        xmlField.getXPathFragment().setNamespaceURI("http://www.w3.org/2000/xmlns/");
        nestedRecord.add(xmlField, url);
        if (addToNamespaceResolver) {
            nestedRecord.getNamespaceResolver().put(prefix, url);
        }
        return xmlField;
    }

    public NamespaceResolver getNamespaceResolver() {
        NamespaceResolver namespaceResolver = null;
        if (this.isXmlDescriptor()) {
            namespaceResolver = ((XMLDescriptor)this.getDescriptor()).getNamespaceResolver();
        } else if (this.getDescriptor() instanceof EISDescriptor) {
            namespaceResolver = ((EISDescriptor)this.getDescriptor()).getNamespaceResolver();
        }
        return namespaceResolver;
    }

    protected boolean isXmlDescriptor() {
        if (this.isXMLDescriptor == null) {
            this.isXMLDescriptor = this.getDescriptor() instanceof XMLDescriptor;
        }
        return this.isXMLDescriptor;
    }

    public void setDescriptor(ClassDescriptor aDescriptor) {
        super.setDescriptor(aDescriptor);
        this.isXMLDescriptor = null;
    }

    protected List addExtraNamespacesToNamespaceResolver(XMLDescriptor desc, XMLRecord marshalRecord, AbstractSession session) {
        if (((XMLLogin)session.getDatasourceLogin()).hasEqualNamespaceResolvers()) {
            return null;
        }
        ArrayList<Namespace> returnList = new ArrayList<Namespace>();
        for (Map.Entry<String, String> entry : desc.getNonNullNamespaceResolver().getPrefixesToNamespaces().entrySet()) {
            String prefix = marshalRecord.getNamespaceResolver().resolveNamespaceURI(entry.getValue());
            if (prefix == null || prefix.length() == 0) {
                marshalRecord.getNamespaceResolver().put(entry.getKey(), entry.getValue());
                returnList.add(new Namespace(entry.getKey(), entry.getValue()));
                continue;
            }
            if (prefix.equals(entry.getKey())) continue;
            marshalRecord.getNamespaceResolver().put(entry.getKey(), entry.getValue());
            returnList.add(new Namespace(entry.getKey(), entry.getValue()));
        }
        return returnList;
    }

    public void writeExtraNamespaces(List extraNamespaces, XMLRecord xmlRecord) {
        if (extraNamespaces == null) {
            return;
        }
        if (xmlRecord.getDOM().getNodeType() != 1) {
            return;
        }
        for (int i = 0; i < extraNamespaces.size(); ++i) {
            Namespace next = (Namespace)extraNamespaces.get(i);
            ((Element)xmlRecord.getDOM()).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + next.getPrefix(), next.getNamespaceURI());
        }
    }

    public void removeExtraNamespacesFromNamespaceResolver(XMLRecord marshalRecord, List extraNamespaces, AbstractSession session) {
        if (extraNamespaces == null) {
            return;
        }
        for (int i = 0; i < extraNamespaces.size(); ++i) {
            Namespace nextExtraNamespace = (Namespace)extraNamespaces.get(i);
            String uri = marshalRecord.getNamespaceResolver().resolveNamespacePrefix(nextExtraNamespace.getPrefix());
            if (uri == null || !uri.equals(nextExtraNamespace.getNamespaceURI())) continue;
            marshalRecord.getNamespaceResolver().removeNamespace(nextExtraNamespace.getPrefix());
        }
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        DatabaseMapping sequenceMapping;
        this.getMappingsByField().clear();
        this.getReadOnlyMappingsByField().clear();
        this.getMappingsByAttribute().clear();
        this.getCloningMappings().clear();
        this.getEagerMappings().clear();
        this.getRelationshipMappings().clear();
        Enumeration<DatabaseMapping> mappings = this.descriptor.getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = mappings.nextElement();
            if (!mapping.isWriteOnly()) {
                this.getMappingsByAttribute().put(mapping.getAttributeName(), mapping);
            }
            if (mapping.isCloningRequired()) {
                this.getCloningMappings().add(mapping);
            }
            if (mapping.isForeignReferenceMapping() && ((ForeignReferenceMapping)mapping).usesIndirection() && !mapping.isLazy()) {
                this.getEagerMappings().add(mapping);
            }
            if (!mapping.isDirectToFieldMapping()) {
                this.getRelationshipMappings().add(mapping);
            }
            for (DatabaseField field : mapping.getFields()) {
                if (mapping.isReadOnly()) {
                    List<DatabaseMapping> readOnlyMappings = this.getReadOnlyMappingsByField().get(field);
                    if (readOnlyMappings == null) {
                        readOnlyMappings = new ArrayList<DatabaseMapping>();
                        this.getReadOnlyMappingsByField().put(field, readOnlyMappings);
                    }
                    readOnlyMappings.add(mapping);
                    continue;
                }
                if (mapping.isAggregateObjectMapping()) {
                    ObjectBuilder aggregateObjectBuilder = ((AggregateObjectMapping)mapping).getReferenceDescriptor().getObjectBuilder();
                    DatabaseMapping aggregatedFieldMapping = aggregateObjectBuilder.getMappingForField(field);
                    if (aggregatedFieldMapping == null) {
                        List<DatabaseMapping> readOnlyMappings = this.getReadOnlyMappingsByField().get(field);
                        if (readOnlyMappings == null) {
                            readOnlyMappings = new ArrayList<DatabaseMapping>();
                            this.getReadOnlyMappingsByField().put(field, readOnlyMappings);
                        }
                        readOnlyMappings.add(mapping);
                        continue;
                    }
                    this.getMappingsByField().put(field, mapping);
                    continue;
                }
                if (this.getMappingsByField().containsKey(field)) continue;
                this.getMappingsByField().put(field, mapping);
            }
        }
        this.isSimple = this.getRelationshipMappings().isEmpty();
        this.initializePrimaryKey(session);
        this.initializeJoinedAttributes();
        if (this.descriptor.usesSequenceNumbers() && (sequenceMapping = this.getMappingForField(this.descriptor.getSequenceNumberField())) != null && sequenceMapping.isDirectToFieldMapping()) {
            this.setSequenceMapping((AbstractDirectMapping)sequenceMapping);
        }
    }

    public boolean isXMLObjectBuilder() {
        return true;
    }

    public boolean addXsiTypeAndClassIndicatorIfRequired(XMLRecord record, XMLDescriptor xmlDescriptor, XMLDescriptor referenceDescriptor, XMLField xmlField, Object originalObject, Object obj, boolean wasXMLRoot, boolean addToNamespaceResolver) {
        if (wasXMLRoot) {
            XMLSchemaReference xmlRef = xmlDescriptor.getSchemaReference();
            if (this.descriptor != null) {
                XMLRoot xr = (XMLRoot)originalObject;
                if (xmlDescriptor.getSchemaReference() == null) {
                    return false;
                }
                QName qName = new QName(xr.getNamespaceURI(), xr.getLocalName());
                XMLDescriptor xdesc = record.getMarshaller().getXMLContext().getDescriptor(qName);
                if (xdesc != null) {
                    boolean writeTypeAttribute;
                    boolean bl = writeTypeAttribute = xdesc.getJavaClass() != this.descriptor.getJavaClass();
                    if (writeTypeAttribute && xmlRef != null) {
                        String typeValue = xmlRef.getSchemaContext().substring(1);
                        this.writeXsiTypeAttribute(xmlDescriptor, record, typeValue, addToNamespaceResolver);
                        return true;
                    }
                    return false;
                }
                String xmlRootLocalName = xr.getLocalName();
                String xmlRootUri = xr.getNamespaceURI();
                boolean writeTypeAttribute = true;
                for (int i = 0; i < this.descriptor.getTableNames().size(); ++i) {
                    if (!writeTypeAttribute) {
                        return false;
                    }
                    String defaultRootQualifiedName = (String)xmlDescriptor.getTableNames().get(i);
                    if (defaultRootQualifiedName != null) {
                        String defaultRootLocalName = null;
                        String defaultRootUri = null;
                        int colonIndex = defaultRootQualifiedName.indexOf(58);
                        if (colonIndex > 0) {
                            String defaultRootPrefix = defaultRootQualifiedName.substring(0, colonIndex);
                            defaultRootLocalName = defaultRootQualifiedName.substring(colonIndex + 1);
                            if (xmlDescriptor.getNamespaceResolver() != null) {
                                defaultRootUri = xmlDescriptor.getNamespaceResolver().resolveNamespacePrefix(defaultRootPrefix);
                            }
                        } else {
                            defaultRootLocalName = defaultRootQualifiedName;
                        }
                        if (xmlRootLocalName == null || (defaultRootLocalName != null || xmlRootLocalName != null) && !defaultRootLocalName.equals(xmlRootLocalName) || (defaultRootUri != null || xmlRootUri != null) && (xmlRootUri == null || defaultRootUri == null || !defaultRootUri.equals(xmlRootUri))) continue;
                        return false;
                    }
                    if (xmlRootLocalName != null) continue;
                    return false;
                }
                if (writeTypeAttribute && xmlRef != null) {
                    String typeValue = this.getTypeValueToWrite(record, xmlRef, addToNamespaceResolver);
                    this.writeXsiTypeAttribute(xmlDescriptor, record, typeValue, addToNamespaceResolver);
                    return true;
                }
            }
            return false;
        }
        return this.addXsiTypeAndClassIndicatorIfRequired(record, xmlDescriptor, referenceDescriptor, xmlField, addToNamespaceResolver);
    }

    public boolean addXsiTypeAndClassIndicatorIfRequired(XMLRecord record, XMLDescriptor xmlDescriptor, XMLDescriptor referenceDescriptor, XMLField xmlField, boolean addToNamespaceResolver) {
        XMLField indicatorField;
        XMLField indicatorField2;
        boolean xsiTypeIndicatorField = false;
        if (xmlDescriptor.hasInheritance() && (indicatorField2 = (XMLField)xmlDescriptor.getInheritancePolicy().getClassIndicatorField()) != null) {
            if (indicatorField2.getLastXPathFragment().getNamespaceURI() != null && indicatorField2.getLastXPathFragment().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance") && indicatorField2.getLastXPathFragment().getLocalName().equals("type")) {
                xsiTypeIndicatorField = true;
            }
            if (!xsiTypeIndicatorField) {
                xmlDescriptor.getInheritancePolicy().addClassIndicatorFieldToRow(record);
            }
        }
        if (referenceDescriptor != null && referenceDescriptor == xmlDescriptor) {
            return false;
        }
        QName leafType = null;
        if (xmlField != null) {
            leafType = xmlField.getLeafElementType();
            XMLSchemaReference xmlRef = xmlDescriptor.getSchemaReference();
            if (xmlRef != null) {
                String typeValue = this.getTypeValueToWrite(record, xmlRef, addToNamespaceResolver);
                if (leafType == null && referenceDescriptor == null) {
                    this.writeXsiTypeAttribute(xmlDescriptor, record, typeValue, addToNamespaceResolver);
                    return true;
                }
                if (xmlRef.getType() == 1 && xmlRef.isGlobalDefinition()) {
                    QName ctxQName = xmlRef.getSchemaContextAsQName(xmlDescriptor.getNamespaceResolver());
                    if (leafType != null && !ctxQName.equals(leafType)) {
                        this.writeXsiTypeAttribute(xmlDescriptor, record, typeValue, addToNamespaceResolver);
                        return true;
                    }
                }
            }
        }
        if (xmlDescriptor.hasInheritance() && !xmlDescriptor.getInheritancePolicy().isRootParentDescriptor() && (indicatorField = (XMLField)xmlDescriptor.getInheritancePolicy().getClassIndicatorField()) != null && xsiTypeIndicatorField) {
            String classIndicatorValue = (String)xmlDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(xmlDescriptor.getJavaClass());
            int nsindex = classIndicatorValue.indexOf(58);
            String localName = null;
            String prefix = null;
            if (nsindex != -1) {
                localName = classIndicatorValue.substring(nsindex + 1);
                prefix = classIndicatorValue.substring(0, nsindex);
            } else {
                localName = classIndicatorValue;
            }
            String namespaceURI = xmlDescriptor.getNonNullNamespaceResolver().resolveNamespacePrefix(prefix);
            QName classIndicatorQName = new QName(namespaceURI, localName);
            if (leafType == null || !classIndicatorQName.equals(leafType)) {
                xmlDescriptor.getInheritancePolicy().addClassIndicatorFieldToRow(record);
                return true;
            }
            return false;
        }
        return false;
    }

    private String getTypeValueToWrite(XMLRecord record, XMLSchemaReference xmlRef, boolean addToNamespaceResolver) {
        String typeValue = xmlRef.getSchemaContext();
        if (typeValue == null) {
            QName contextAsQName = xmlRef.getSchemaContextAsQName();
            if (contextAsQName != null) {
                String uri = contextAsQName.getNamespaceURI();
                String localPart = contextAsQName.getLocalPart();
                String prefix = record.getNamespaceResolver().resolveNamespaceURI(uri);
                if (prefix == null) {
                    String defaultUri = record.getNamespaceResolver().getDefaultNamespaceURI();
                    if (defaultUri != null && defaultUri.equals(uri)) {
                        return localPart;
                    }
                    prefix = record.getNamespaceResolver().generatePrefix();
                    this.writeNamespace(record, prefix, uri, addToNamespaceResolver);
                    return prefix + ':' + localPart;
                }
                return prefix + ':' + localPart;
            }
            return null;
        }
        return typeValue.substring(1);
    }
}

