/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.DirectMapContainerPolicy;
import org.eclipse.persistence.internal.queries.DirectMapUsableContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DirectMapChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.DirectReadQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.changesets.ChangeRecord;

public class DirectMapMapping
extends DirectCollectionMapping
implements MapComponentMapping {
    public DirectMapMapping() {
        DataReadQuery query = new DataReadQuery();
        this.selectionQuery = query;
        this.containerPolicy = new DirectMapContainerPolicy(ClassConstants.Hashtable_Class);
        this.isListOrderFieldSupported = false;
    }

    private DirectMapUsableContainerPolicy getDirectMapUsableContainerPolicy() {
        return (DirectMapUsableContainerPolicy)((Object)this.containerPolicy);
    }

    public Converter getKeyConverter() {
        return this.getDirectMapUsableContainerPolicy().getKeyConverter();
    }

    public void setKeyConverter(Converter keyConverter) {
        this.getDirectMapUsableContainerPolicy().setKeyConverter(keyConverter, this);
    }

    public void setKeyConverterClassName(String keyConverterClassName) {
        this.getDirectMapUsableContainerPolicy().setKeyConverterClassName(keyConverterClassName, this);
    }

    public void addToCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        collectionChangeRecord.addAdditionChange(newKey, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildCloneForPartObject(Object attributeValue, Object original, Object clone, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        if (attributeValue == null) {
            return this.containerPolicy.containerInstance(1);
        }
        Object clonedAttributeValue = this.containerPolicy.containerInstance(this.containerPolicy.sizeFor(attributeValue));
        Object temporaryCollection = null;
        Object object = attributeValue;
        synchronized (object) {
            temporaryCollection = this.containerPolicy.cloneFor(attributeValue);
        }
        Object keysIterator = this.containerPolicy.iteratorFor(temporaryCollection);
        while (this.containerPolicy.hasNext(keysIterator)) {
            Map.Entry entry = (Map.Entry)this.containerPolicy.nextEntry(keysIterator, unitOfWork);
            Object cloneKey = this.containerPolicy.buildCloneForKey(entry.getKey(), clone, unitOfWork, isExisting);
            Object cloneValue = this.buildElementClone(entry.getValue(), clone, unitOfWork, isExisting);
            this.containerPolicy.addInto(cloneKey, cloneValue, clonedAttributeValue, unitOfWork);
        }
        return clonedAttributeValue;
    }

    public void calculateDeferredChanges(org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractSession session) {
        DirectMapChangeRecord collectionRecord = (DirectMapChangeRecord)changeRecord;
        this.compareCollectionsForChange(collectionRecord.getOriginalCollection(), collectionRecord.getLatestCollection(), collectionRecord, session);
    }

    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow) {
        if (this.containerPolicy.isMappedKeyMapPolicy()) {
            Object values = this.getAttributeValueFromObject(object);
            Object iterator = this.containerPolicy.iteratorFor(values);
            while (this.containerPolicy.hasNext(iterator)) {
                Object wrappedObject = this.containerPolicy.nextEntry(iterator, uow);
                this.containerPolicy.cascadeDiscoverAndPersistUnregisteredNewObjects(wrappedObject, newObjects, unregisteredExistingObjects, visitedObjects, uow);
            }
        }
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        if (this.containerPolicy.isMappedKeyMapPolicy()) {
            Object values = this.getAttributeValueFromObject(object);
            Object iterator = this.containerPolicy.iteratorFor(values);
            while (this.containerPolicy.hasNext(iterator)) {
                Object wrappedObject = this.containerPolicy.nextEntry(iterator, uow);
                this.containerPolicy.cascadePerformRemoveIfRequired(wrappedObject, uow, visitedObjects);
            }
        }
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        if (this.containerPolicy.isMappedKeyMapPolicy()) {
            Object values = this.getAttributeValueFromObject(object);
            Object iterator = this.containerPolicy.iteratorFor(values);
            while (this.containerPolicy.hasNext(iterator)) {
                Object wrappedObject = this.containerPolicy.nextEntry(iterator, uow);
                this.containerPolicy.cascadeRegisterNewIfRequired(wrappedObject, uow, visitedObjects);
            }
        }
    }

    public org.eclipse.persistence.internal.sessions.ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = null;
        Object backUpAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(clone);
        if (cloneAttribute != null && !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        Map cloneObjectCollection = (Map)this.getRealCollectionAttributeValueFromObject(clone, session);
        HashMap originalKeyValues = new HashMap(10);
        HashMap cloneKeyValues = new HashMap(10);
        if (!owner.isNew()) {
            backUpAttribute = this.getAttributeValueFromObject(backUp);
            if (backUpAttribute == null && cloneAttribute == null) {
                return null;
            }
            Map backUpCollection = (Map)this.getRealCollectionAttributeValueFromObject(backUp, session);
            Object backUpIter = this.containerPolicy.iteratorFor(backUpCollection);
            while (this.containerPolicy.hasNext(backUpIter)) {
                Map.Entry entry = (Map.Entry)this.containerPolicy.nextEntry(backUpIter, session);
                originalKeyValues.put(entry.getKey(), backUpCollection.get(entry.getKey()));
            }
        }
        Object cloneIter = this.containerPolicy.iteratorFor(cloneObjectCollection);
        while (this.containerPolicy.hasNext(cloneIter)) {
            Map.Entry wrappedFirstObject = (Map.Entry)this.containerPolicy.nextEntry(cloneIter, session);
            Object firstValue = wrappedFirstObject.getValue();
            Object firstKey = wrappedFirstObject.getKey();
            Object backupValue = originalKeyValues.get(firstKey);
            if (!originalKeyValues.containsKey(firstKey)) {
                cloneKeyValues.put(firstKey, cloneObjectCollection.get(firstKey));
                continue;
            }
            if (backupValue == null && firstValue != null || !backupValue.equals(firstValue)) {
                cloneKeyValues.put(firstKey, cloneObjectCollection.get(firstKey));
                continue;
            }
            originalKeyValues.remove(firstKey);
        }
        if (cloneKeyValues.isEmpty() && originalKeyValues.isEmpty() && !owner.isNew()) {
            return null;
        }
        DirectMapChangeRecord changeRecord = new DirectMapChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        changeRecord.addAdditionChange(cloneKeyValues);
        changeRecord.addRemoveChange(originalKeyValues);
        return changeRecord;
    }

    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        Object firstObjectMap = this.getRealCollectionAttributeValueFromObject(firstObject, session);
        Object secondObjectMap = this.getRealCollectionAttributeValueFromObject(secondObject, session);
        DirectMapUsableContainerPolicy mapContainerPolicy = this.getDirectMapUsableContainerPolicy();
        return mapContainerPolicy.compareContainers(firstObjectMap, secondObjectMap);
    }

    public Object createMapComponentFromRow(AbstractRecord dbRow, ObjectBuildingQuery query, AbstractSession session) {
        Object key = dbRow.get(this.getDirectField());
        if (this.getValueConverter() != null) {
            key = this.getValueConverter().convertDataValueToObjectValue(key, session);
        }
        return key;
    }

    public DatabaseField getDirectKeyField() {
        return this.getDirectMapUsableContainerPolicy().getDirectKeyField(null);
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        this.getDirectMapUsableContainerPolicy().setDescriptorForKeyMapping(this.getDescriptor());
        super.initialize(session);
        this.getDirectMapUsableContainerPolicy().setValueField(this.directField, this.valueConverter);
        if (this.getValueConverter() != null) {
            this.getValueConverter().initialize(this, session);
        }
    }

    protected void initializeDeleteQuery(AbstractSession session) {
        if (!this.getDeleteQuery().hasSessionName()) {
            this.getDeleteQuery().setSessionName(session.getName());
        }
        if (this.hasCustomDeleteQuery()) {
            return;
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression directKeyExp = null;
        List<DatabaseField> identityFields = this.getContainerPolicy().getIdentityFieldsForMapKey();
        for (DatabaseField field : identityFields) {
            Expression fieldExpression = ((Expression)builder).getField(field).equal(builder.getParameter(field));
            if (directKeyExp == null) {
                directKeyExp = fieldExpression;
                continue;
            }
            directKeyExp = directKeyExp.and(fieldExpression);
        }
        Expression expression = null;
        SQLDeleteStatement statement = new SQLDeleteStatement();
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Expression subExp1 = ((Expression)builder).getField(referenceKey);
            Expression subExp2 = builder.getParameter(sourceKey);
            Expression subExpression = subExp1.equal(subExp2);
            expression = subExpression.and(expression);
        }
        expression = expression.and(directKeyExp);
        statement.setWhereClause(expression);
        statement.setTable(this.getReferenceTable());
        this.getDeleteQuery().setSQLStatement(statement);
    }

    protected void initializeInsertQuery(AbstractSession session) {
        super.initializeInsertQuery(session);
        this.getContainerPolicy().addFieldsForMapKey(this.getInsertQuery().getModifyRow());
    }

    protected void initializeSelectionStatement(AbstractSession session) {
        if (this.selectionQuery.isReadAllQuery()) {
            ((ReadAllQuery)this.selectionQuery).addAdditionalField((DatabaseField)this.getDirectField().clone());
        } else {
            SQLSelectStatement statement = (SQLSelectStatement)this.selectionQuery.getSQLStatement();
            statement.addTable(this.getReferenceTable());
            statement.addField((DatabaseField)this.getDirectField().clone());
            this.getContainerPolicy().addAdditionalFieldsToQuery(this.selectionQuery, null);
            statement.normalize(session, null);
        }
        if (this.selectionQuery.isDirectReadQuery()) {
            ((DirectReadQuery)this.selectionQuery).setResultType(0);
        }
    }

    public void iterateOnRealAttributeValue(DescriptorIterator iterator, Object realAttributeValue) {
        super.iterateOnRealAttributeValue(iterator, realAttributeValue);
        ContainerPolicy cp = this.getContainerPolicy();
        if (realAttributeValue != null && !iterator.shouldIterateOnPrimitives()) {
            Object iter = cp.iteratorFor(realAttributeValue);
            while (cp.hasNext(iter)) {
                Object wrappedObject = cp.nextEntry(iter, iterator.getSession());
                cp.iterateOnMapKey(iterator, wrappedObject);
            }
        }
    }

    public void iterateOnElement(DescriptorIterator iterator, Object element) {
        super.iterateOnElement(iterator, element);
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(element);
        while (cp.hasNext(iter)) {
            Object wrappedObject = cp.nextEntry(iter, iterator.getSession());
            cp.iterateOnMapKey(iterator, wrappedObject);
        }
    }

    public boolean isDirectMapMapping() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChangesIntoObject(Object target, org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, Object source, MergeManager mergeManager) {
        Map valueOfTarget = null;
        AbstractSession session = mergeManager.getSession();
        HashMap addObjects = ((DirectMapChangeRecord)changeRecord).getAddObjects();
        HashMap removeObjects = ((DirectMapChangeRecord)changeRecord).getRemoveObjects();
        valueOfTarget = this.isAttributeValueInstantiated(target) && !changeRecord.getOwner().isNew() ? (Map)this.getRealCollectionAttributeValueFromObject(target, session) : (Map)this.containerPolicy.containerInstance(addObjects.size());
        if (!this.isAttributeValueInstantiated(target)) {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                return;
            }
            Object valueOfSource = this.getRealCollectionAttributeValueFromObject(source, session);
            Object iterator = this.containerPolicy.iteratorFor(valueOfSource);
            while (this.containerPolicy.hasNext(iterator)) {
                Map.Entry entry = (Map.Entry)this.containerPolicy.nextEntry(iterator, session);
                this.containerPolicy.addInto(entry.getKey(), entry.getValue(), valueOfTarget, session);
            }
        } else {
            Object synchronizationTarget = valueOfTarget;
            if (valueOfTarget instanceof IndirectCollection) {
                synchronizationTarget = ((IndirectCollection)((Object)valueOfTarget)).getDelegateObject();
            }
            Map map = synchronizationTarget;
            synchronized (map) {
                for (Object keyToRemove : removeObjects.keySet()) {
                    this.containerPolicy.removeFrom(keyToRemove, null, valueOfTarget, session);
                }
                for (Object keyToAdd : addObjects.keySet()) {
                    Object nextItem = addObjects.get(keyToAdd);
                    if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                        if (this.containerPolicy.contains(nextItem, valueOfTarget, session)) continue;
                        this.containerPolicy.addInto(keyToAdd, nextItem, valueOfTarget, session);
                        continue;
                    }
                    this.containerPolicy.addInto(keyToAdd, nextItem, valueOfTarget, session);
                }
            }
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager) {
        DirectMapChangeRecord changeRecord;
        ObjectChangeSet changeSet;
        Map.Entry entry;
        if (isTargetUnInitialized && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(source)) {
            this.setAttributeValueInObject(target, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(source), mergeManager.getSession()));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.mergeRemoteValueHolder(target, source, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiated(target) : !this.isAttributeValueInstantiated(source)) {
            return;
        }
        Map valueOfSource = (Map)this.getRealCollectionAttributeValueFromObject(source, mergeManager.getSession());
        Object valueOfTarget = this.getRealCollectionAttributeValueFromObject(target, mergeManager.getSession());
        Object newContainer = this.containerPolicy.containerInstance(this.containerPolicy.sizeFor(valueOfSource));
        boolean fireChangeEvents = false;
        if (this.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && target instanceof ChangeTracker && ((ChangeTracker)target)._persistence_getPropertyChangeListener() != null) {
            fireChangeEvents = true;
            Object iterator = this.containerPolicy.iteratorFor(valueOfTarget);
            while (this.containerPolicy.hasNext(iterator)) {
                entry = (Map.Entry)this.containerPolicy.nextEntry(iterator, mergeManager.getSession());
                ((ObjectChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).internalPropertyChange(new MapChangeEvent(target, this.getAttributeName(), valueOfTarget, entry.getKey(), entry.getValue(), CollectionChangeEvent.REMOVE));
            }
            if (newContainer instanceof ChangeTracker) {
                ((ChangeTracker)newContainer)._persistence_setPropertyChangeListener(((ChangeTracker)target)._persistence_getPropertyChangeListener());
            }
            if (valueOfTarget instanceof ChangeTracker) {
                ((ChangeTracker)valueOfTarget)._persistence_setPropertyChangeListener(null);
            }
        }
        valueOfTarget = newContainer;
        Object sourceValuesIterator = this.containerPolicy.iteratorFor(valueOfSource);
        while (this.containerPolicy.hasNext(sourceValuesIterator)) {
            entry = (Map.Entry)this.containerPolicy.nextEntry(sourceValuesIterator, mergeManager.getSession());
            if (fireChangeEvents) {
                ((ObjectChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).internalPropertyChange(new MapChangeEvent(target, this.getAttributeName(), valueOfTarget, entry.getKey(), entry.getValue(), CollectionChangeEvent.ADD));
            }
            this.containerPolicy.addInto(entry.getKey(), entry.getValue(), valueOfTarget, mergeManager.getSession());
        }
        if (fireChangeEvents && this.getDescriptor().getObjectChangePolicy().isAttributeChangeTrackingPolicy() && (changeSet = ((AttributeChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).getObjectChangeSet()) != null && (changeRecord = (DirectMapChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName())) != null) {
            if (!changeRecord.isDeferred()) {
                if (!changeRecord.hasChanges()) {
                    changeSet.removeChange(this.getAttributeName());
                }
            } else {
                changeRecord.setLatestCollection(valueOfTarget);
            }
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    public void performDataModificationEvent(Object[] event, AbstractSession session) throws DatabaseException, DescriptorException {
        super.performDataModificationEvent(event, session);
        if (event[0] == "delete" && this.containerPolicy.shouldIncludeKeyInDeleteEvent()) {
            session.deleteObject(event[3]);
        }
    }

    public void postCalculateChanges(ChangeRecord changeRecord, UnitOfWorkImpl uow) {
        DirectMapChangeRecord mapChangeRecord = (DirectMapChangeRecord)changeRecord;
        for (Map.Entry entry : mapChangeRecord.getRemoveObjects().entrySet()) {
            this.containerPolicy.postCalculateChanges(entry.getKey(), entry.getValue(), this.referenceDescriptor, this, uow);
        }
    }

    public void postInsert(WriteObjectQuery query) throws DatabaseException {
        DatabaseRecord databaseRow = new DatabaseRecord();
        if (this.isReadOnly()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        if (this.containerPolicy.isEmpty(objects)) {
            return;
        }
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getSession());
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Object sourceKeyValue = query.getTranslationRow().get(sourceKey);
            databaseRow.put(referenceKey, sourceKeyValue);
        }
        Object keyIter = this.containerPolicy.iteratorFor(objects);
        while (this.containerPolicy.hasNext(keyIter)) {
            Map.Entry entry = (Map.Entry)this.containerPolicy.nextEntry(keyIter, query.getSession());
            Object value = this.getFieldValue(entry.getValue(), query.getSession());
            databaseRow.put(this.getDirectField(), value);
            ContainerPolicy.copyMapDataToRow(this.getContainerPolicy().getKeyMappingDataForWriteQuery(entry, query.getSession()), databaseRow);
            if (query.shouldCascadeOnlyDependentParts()) {
                Object[] event = new Object[]{"insert", this.getInsertQuery(), databaseRow.clone()};
                query.getSession().getCommitManager().addDataModificationEvent(this, event);
            } else {
                query.getSession().executeQuery((DatabaseQuery)this.getInsertQuery(), databaseRow);
            }
            this.getContainerPolicy().propogatePostInsert(query, entry);
        }
    }

    protected void postUpdateWithChangeSet(WriteObjectQuery writeQuery) throws DatabaseException {
        AbstractRecord thisRow;
        ObjectChangeSet changeSet = writeQuery.getObjectChangeSet();
        DirectMapChangeRecord changeRecord = (DirectMapChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            return;
        }
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Object sourceKeyValue = writeQuery.getTranslationRow().get(sourceKey);
            writeQuery.getTranslationRow().put(referenceKey, sourceKeyValue);
        }
        for (Map.Entry entry : changeRecord.getRemoveObjects().entrySet()) {
            thisRow = (AbstractRecord)writeQuery.getTranslationRow().clone();
            ContainerPolicy.copyMapDataToRow(this.containerPolicy.getKeyMappingDataForWriteQuery(entry, writeQuery.getSession()), thisRow);
            Object[] event = null;
            if (this.containerPolicy.shouldIncludeKeyInDeleteEvent()) {
                event = new Object[4];
                event[3] = this.containerPolicy.keyFromEntry(entry);
            } else {
                event = new Object[]{"delete", this.getDeleteQuery(), thisRow};
            }
            writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
        }
        for (Map.Entry entry : changeRecord.getAddObjects().entrySet()) {
            thisRow = (AbstractRecord)writeQuery.getTranslationRow().clone();
            Object value = changeRecord.getAddObjects().get(entry.getKey());
            value = this.getFieldValue(value, writeQuery.getSession());
            ContainerPolicy.copyMapDataToRow(this.containerPolicy.getKeyMappingDataForWriteQuery(entry, writeQuery.getSession()), thisRow);
            thisRow.add(this.getDirectField(), value);
            Object[] event = new Object[]{"insert", this.getInsertQuery(), thisRow};
            writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
        }
    }

    public void preDelete(DeleteObjectQuery query) throws DatabaseException {
        if (this.getContainerPolicy().propagatesEventsToCollection()) {
            Object queryObject = query.getObject();
            Object values = this.getAttributeValueFromObject(queryObject);
            Object iterator = this.containerPolicy.iteratorFor(values);
            while (this.containerPolicy.hasNext(iterator)) {
                Object wrappedObject = this.containerPolicy.nextEntry(iterator, query.getSession());
                this.containerPolicy.propogatePreDelete(query, wrappedObject);
            }
        }
        super.preDelete(query);
    }

    protected void initOrRebuildSelectQuery() {
        this.selectionQuery = this.containerPolicy.buildSelectionQueryForDirectCollectionMapping();
    }

    public void recordPrivateOwnedRemovals(Object object, UnitOfWorkImpl uow) {
        Iterator it = (Iterator)this.containerPolicy.iteratorFor(this.getRealAttributeValueFromObject(object, uow));
        while (it.hasNext()) {
            Object clone = it.next();
            this.containerPolicy.recordPrivateOwnedRemovals(clone, this.referenceDescriptor, uow);
        }
    }

    protected void removeFromCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        collectionChangeRecord.addRemoveChange(newKey, newValue);
    }

    public void setDirectKeyField(DatabaseField keyField) {
        this.getDirectMapUsableContainerPolicy().setKeyField(keyField, this.descriptor);
    }

    public void setDirectKeyFieldClassification(Class fieldType) {
        this.getDirectKeyField().setType(fieldType);
    }

    public void setDirectKeyFieldName(String fieldName) {
        this.setDirectKeyField(new DatabaseField(fieldName));
    }

    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        if (collectionChangeRecord.getOriginalCollection() == null) {
            collectionChangeRecord.setOriginalCollection(oldValue);
        }
        collectionChangeRecord.setLatestCollection(newValue);
        collectionChangeRecord.setIsDeferred(true);
        objectChangeSet.deferredDetectionRequiredOn(this.getAttributeName());
    }

    public void updateCollectionChangeRecord(CollectionChangeEvent event, ObjectChangeSet changeSet, UnitOfWorkImpl uow) {
        if (event != null) {
            Object key = null;
            if (event.getClass().equals(ClassConstants.MapChangeEvent_Class)) {
                key = ((MapChangeEvent)event).getKey();
            }
            if (event.getChangeType() == CollectionChangeEvent.ADD) {
                this.addToCollectionChangeRecord(key, event.getNewValue(), changeSet, uow);
            } else if (event.getChangeType() == CollectionChangeEvent.REMOVE) {
                this.removeFromCollectionChangeRecord(key, event.getNewValue(), changeSet, uow);
            } else {
                throw ValidationException.wrongCollectionChangeEventType(event.getChangeType());
            }
        }
    }

    public void useMapClass(Class concreteClass) {
        if (!Helper.classImplementsInterface(concreteClass, ClassConstants.Map_Class)) {
            throw DescriptorException.illegalContainerClass(concreteClass);
        }
        this.containerPolicy.setContainerClass(concreteClass);
    }

    public void useTransparentMap() {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useMapClass(ClassConstants.IndirectMap_Class);
    }

    public void setKeyClass(Class keyClass) {
        TypeConversionConverter converter = new TypeConversionConverter(this);
        converter.setObjectClass(keyClass);
        this.setKeyConverter(converter);
    }

    public Class getKeyClass() {
        if (this.getKeyConverter() == null || !(this.getKeyConverter() instanceof TypeConversionConverter)) {
            return null;
        }
        return ((TypeConversionConverter)this.getKeyConverter()).getObjectClass();
    }

    public void setValueClass(Class valueClass) {
        TypeConversionConverter converter = new TypeConversionConverter(this);
        converter.setObjectClass(valueClass);
        this.setValueConverter(converter);
    }

    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object objectToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            collectionChangeRecord.getAddObjects().put(referenceKey, objectToAdd);
            changeSet.addChange(collectionChangeRecord);
        } else if (collectionChangeRecord.getRemoveObjects().containsKey(referenceKey)) {
            collectionChangeRecord.getRemoveObjects().remove(referenceKey);
        } else {
            collectionChangeRecord.getAddObjects().put(referenceKey, objectToAdd);
        }
    }

    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object objectToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            collectionChangeRecord.getRemoveObjects().put(referenceKey, objectToRemove);
            changeSet.addChange(collectionChangeRecord);
        } else if (collectionChangeRecord.getAddObjects().containsKey(referenceKey)) {
            collectionChangeRecord.getAddObjects().remove(referenceKey);
        } else {
            collectionChangeRecord.getRemoveObjects().put(referenceKey, objectToRemove);
        }
    }

    public Class getValueClass() {
        if (!(this.getValueConverter() instanceof TypeConversionConverter)) {
            return null;
        }
        return ((TypeConversionConverter)this.getValueConverter()).getObjectClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractResultFromBatchQuery(DatabaseQuery query, AbstractRecord databaseRow, AbstractSession session, AbstractRecord argumentRow) {
        Hashtable referenceDataByKey = null;
        ContainerPolicy mappingContainerPolicy = this.getContainerPolicy();
        DatabaseQuery databaseQuery = query;
        synchronized (databaseQuery) {
            referenceDataByKey = this.getBatchReadObjects(query, session);
            mappingContainerPolicy = this.getContainerPolicy();
            if (referenceDataByKey == null) {
                List rows = (List)session.executeQuery(query, argumentRow);
                referenceDataByKey = new Hashtable();
                for (AbstractRecord referenceRow : rows) {
                    Object referenceKey = null;
                    referenceKey = query.isObjectBuildingQuery() ? this.getDirectMapUsableContainerPolicy().buildKey(databaseRow, (ObjectBuildingQuery)query, session) : this.getDirectMapUsableContainerPolicy().buildKey(databaseRow, null, session);
                    Object referenceValue = referenceRow.get(this.getDirectField());
                    Object eachCacheKey = this.extractKeyFromTargetRow(referenceRow, session);
                    Object container = referenceDataByKey.get(eachCacheKey);
                    if (container == null) {
                        container = mappingContainerPolicy.containerInstance();
                        referenceDataByKey.put(eachCacheKey, container);
                    }
                    if (this.getValueConverter() != null) {
                        referenceValue = this.getValueConverter().convertDataValueToObjectValue(referenceValue, query.getSession());
                    }
                    mappingContainerPolicy.addInto(referenceKey, referenceValue, container, query.getSession());
                }
                query.setProperty("batched objects", referenceDataByKey);
                query.setSession(null);
            }
        }
        Object result = referenceDataByKey.get(this.extractPrimaryKeyFromRow(databaseRow, session));
        if (result == null) {
            return mappingContainerPolicy.containerInstance();
        }
        return result;
    }

    protected Object valueFromRowInternalWithJoin(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        ContainerPolicy policy = this.getContainerPolicy();
        Object value = policy.containerInstance();
        ObjectBuilder objectBuilder = this.getDescriptor().getObjectBuilder();
        Object sourceKey = objectBuilder.extractPrimaryKeyFromRow(row, executionSession);
        List<AbstractRecord> rows = joinManager.getDataResultsByPrimaryKey().get(sourceKey);
        HashSet<Object> directValues = new HashSet<Object>();
        Converter valueConverter = this.getValueConverter();
        int size = rows.size();
        for (int index = 0; index < size; ++index) {
            AbstractRecord sourceRow;
            AbstractRecord targetRow = sourceRow = rows.get(index);
            Object directKey = this.containerPolicy.buildKeyFromJoinedRow(targetRow = this.trimRowForJoin(targetRow, joinManager, executionSession), joinManager, sourceQuery, executionSession);
            if (directKey == null) {
                return this.getIndirectionPolicy().valueFromRow(value);
            }
            if (directValues.contains(directKey)) continue;
            directValues.add(directKey);
            Object directValue = targetRow.get(this.directField);
            if (valueConverter != null) {
                directValue = valueConverter.convertDataValueToObjectValue(directValue, executionSession);
            }
            policy.addInto(directKey, directValue, value, executionSession);
        }
        return this.getIndirectionPolicy().valueFromRow(value);
    }
}

