/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.UnsupportedEncodingException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.OutputStreamRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FormattedOutputStreamRecord
extends OutputStreamRecord {
    private int numberOfTabs = 0;
    private boolean complexType = true;
    private boolean isLastEventText = false;

    public void endDocument() {
        this.outputStreamWrite(CR);
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.addPositionalNodes(xPathFragment, namespaceResolver);
        if (this.isStartElementOpen) {
            this.outputStreamWrite(CLOSE_ELEMENT);
        }
        if (!this.isLastEventText) {
            if (this.numberOfTabs > 0) {
                this.outputStreamWrite(CR);
            }
            this.outputStreamWriteTab();
        }
        this.isStartElementOpen = true;
        this.outputStreamWrite(OPEN_START_ELEMENT);
        this.outputStreamWrite(xPathFragment.getShortNameBytes());
        ++this.numberOfTabs;
        this.isLastEventText = false;
    }

    public void element(XPathFragment frag) {
        this.isLastEventText = false;
        if (this.isStartElementOpen) {
            this.outputStreamWrite(CLOSE_ELEMENT);
            this.isStartElementOpen = false;
        }
        this.outputStreamWrite(CR);
        this.outputStreamWriteTab();
        super.element(frag);
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.isLastEventText = false;
        --this.numberOfTabs;
        if (this.isStartElementOpen) {
            this.outputStreamWrite((byte)47);
            this.outputStreamWrite((byte)62);
            this.isStartElementOpen = false;
            return;
        }
        if (this.complexType) {
            this.outputStreamWrite(CR);
            this.outputStreamWriteTab();
        } else {
            this.complexType = true;
        }
        super.endElement(xPathFragment, namespaceResolver);
    }

    public void characters(String value) {
        super.characters(value);
        this.isLastEventText = true;
        this.complexType = false;
    }

    public void cdata(String value) {
        if (this.isStartElementOpen) {
            this.outputStreamWrite(CLOSE_ELEMENT);
            this.isStartElementOpen = false;
        }
        this.outputStreamWrite(CR);
        this.outputStreamWriteTab();
        super.cdata(value);
        this.complexType = true;
    }

    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (namespaceResolver != null) {
                resolverPfx = namespaceResolver.resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", resolverPfx + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else {
            try {
                FormattedOutputStreamRecordContentHandler handler = new FormattedOutputStreamRecordContentHandler();
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(handler);
                xfragReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                xfragReader.parse(node);
            }
            catch (SAXException sex) {
                throw XMLMarshalException.marshalException(sex);
            }
        }
    }

    private void outputStreamWriteTab() {
        for (int x = 0; x < this.numberOfTabs; ++x) {
            this.outputStreamWrite(SPACE);
            this.outputStreamWrite(SPACE);
            this.outputStreamWrite(SPACE);
        }
    }

    private class FormattedOutputStreamRecordContentHandler
    extends OutputStreamRecord.OutputStreamRecordContentHandler {
        private FormattedOutputStreamRecordContentHandler() {
            super(FormattedOutputStreamRecord.this);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            try {
                if (FormattedOutputStreamRecord.this.isStartElementOpen) {
                    FormattedOutputStreamRecord.this.outputStreamWrite(OutputStreamRecord.CLOSE_ELEMENT);
                }
                if (!FormattedOutputStreamRecord.this.isLastEventText) {
                    FormattedOutputStreamRecord.this.outputStreamWrite(OutputStreamRecord.CR);
                    FormattedOutputStreamRecord.this.outputStreamWriteTab();
                }
                FormattedOutputStreamRecord.this.outputStreamWrite(OutputStreamRecord.OPEN_START_ELEMENT);
                FormattedOutputStreamRecord.this.outputStreamWrite(qName.getBytes("UTF-8"));
                FormattedOutputStreamRecord.this.numberOfTabs++;
                FormattedOutputStreamRecord.this.isStartElementOpen = true;
                FormattedOutputStreamRecord.this.isLastEventText = false;
                this.handleAttributes(atts);
                this.writePrefixMappings();
            }
            catch (UnsupportedEncodingException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            FormattedOutputStreamRecord.this.isLastEventText = false;
            FormattedOutputStreamRecord.this.numberOfTabs--;
            if (FormattedOutputStreamRecord.this.isStartElementOpen) {
                FormattedOutputStreamRecord.this.outputStreamWrite((byte)47);
                FormattedOutputStreamRecord.this.outputStreamWrite((byte)62);
                FormattedOutputStreamRecord.this.isStartElementOpen = false;
                FormattedOutputStreamRecord.this.complexType = true;
                return;
            }
            if (FormattedOutputStreamRecord.this.complexType) {
                FormattedOutputStreamRecord.this.outputStreamWrite(OutputStreamRecord.CR);
                FormattedOutputStreamRecord.this.outputStreamWriteTab();
            } else {
                FormattedOutputStreamRecord.this.complexType = true;
            }
            super.endElement(namespaceURI, localName, qName);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (FormattedOutputStreamRecord.this.isProcessingCData) {
                FormattedOutputStreamRecord.this.cdata(new String(ch, start, length));
                return;
            }
            if (new String(ch).trim().length() == 0) {
                return;
            }
            super.characters(ch, start, length);
            FormattedOutputStreamRecord.this.isLastEventText = true;
            FormattedOutputStreamRecord.this.complexType = false;
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            if (FormattedOutputStreamRecord.this.isStartElementOpen) {
                FormattedOutputStreamRecord.this.outputStreamWrite(OutputStreamRecord.CLOSE_ELEMENT);
                FormattedOutputStreamRecord.this.outputStreamWrite(OutputStreamRecord.CR);
                FormattedOutputStreamRecord.this.isStartElementOpen = false;
            }
            this.writeComment(ch, start, length);
            FormattedOutputStreamRecord.this.complexType = false;
        }
    }
}

