/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerMonitor;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;

abstract class Monitor {
    Destination d = null;

    public Monitor(Destination destination) {
        this.d = destination;
    }

    protected abstract Hashtable getMonitorData();

    public void run() {
        Packet packet = new Packet(false);
        Hashtable hashtable = this.getMonitorData();
        if (hashtable == null) {
            return;
        }
        if (Monitor.writeMap(packet, hashtable, this.d.getDestinationName())) {
            try {
                PacketReference packetReference = PacketReference.createReference(packet, null);
                this.d.queueMessage(packetReference, false);
                Set set = this.d.routeNewMessage(packetReference);
                this.d.forwardMessage(set, packetReference);
            }
            catch (BrokerException brokerException) {
                Globals.getLogger().log(4, "Unable to writeMap for  metrics" + this.d, (Throwable)brokerException);
            }
            catch (SelectorFormatException selectorFormatException) {
                Globals.getLogger().log(4, "Internal Error ", (Throwable)selectorFormatException);
            }
        } else {
            Globals.getLogger().log(4, "Unable to writeMap for  metrics" + this.d);
        }
    }

    public void writeToSpecificMonitorConsumer(Consumer consumer) {
        Packet packet = new Packet(true);
        Hashtable hashtable = this.getMonitorData();
        if (hashtable == null) {
            return;
        }
        if (consumer == null) {
            return;
        }
        if (Monitor.writeMap(packet, hashtable, this.d.getDestinationName())) {
            try {
                PacketReference packetReference = PacketReference.createReference(packet, null);
                this.d.queueMessage(packetReference, false);
                ArrayList<Consumer> arrayList = new ArrayList<Consumer>(1);
                arrayList.add(consumer);
                packetReference.store(arrayList);
                consumer.routeMessage(packetReference, false);
            }
            catch (BrokerException brokerException) {
                Globals.getLogger().log(4, "Unable to writeMap for  metrics " + this.d + " : targeted for " + consumer.getConsumerUID(), (Throwable)brokerException);
            }
        } else {
            Globals.getLogger().log(4, "Unable to writeMap for  metrics" + this.d + " : targeted for " + consumer.getConsumerUID());
        }
    }

    private static boolean writeMap(Packet packet, Hashtable hashtable, String string) {
        try {
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            Long l = new Long(System.currentTimeMillis());
            hashtable2.put("type", string);
            hashtable2.put("timestamp", l);
            MQAddress mQAddress = Globals.getMQAddress();
            hashtable2.put("brokerAddress", mQAddress.toString());
            hashtable2.put("brokerHost", mQAddress.getHostName());
            hashtable2.put("brokerPort", new Integer(mQAddress.getPort()));
            packet.setProperties(hashtable2);
            packet.setPacketType(3);
            packet.setDestination(string);
            packet.setPriority(5);
            packet.setIP(InetAddress.getLocalHost().getAddress());
            packet.updateSequenceNumber();
            packet.updateTimestamp();
            packet.generateSequenceNumber(false);
            packet.generateTimestamp(false);
            packet.setIsQueue(false);
            packet.setTransactionID(0L);
            packet.setSendAcknowledge(false);
            packet.setPersistent(BrokerMonitor.PERSIST);
            packet.setExpiration(BrokerMonitor.TTL == 0L ? 0L : l + BrokerMonitor.TTL);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(hashtable);
            objectOutputStream.flush();
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            objectOutputStream.close();
            byteArrayOutputStream.close();
            packet.setMessageBody(byArray);
            return true;
        }
        catch (Exception exception) {
            Globals.getLogger().log(32, "Error sending metrics data", (Throwable)exception);
            return false;
        }
    }
}

