/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.common;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

public class I18NHelper {
    private static final String bundleSuffix = ".Bundle";
    private static Hashtable bundles = new Hashtable();
    private static Locale locale = Locale.getDefault();

    public static ResourceBundle loadBundle(String bundleName) {
        return I18NHelper.loadBundle(bundleName, I18NHelper.class.getClassLoader());
    }

    public static ResourceBundle loadBundle(String bundleName, ClassLoader loader) {
        ResourceBundle messages = (ResourceBundle)bundles.get(bundleName);
        if (messages == null) {
            messages = ResourceBundle.getBundle(bundleName, locale, loader);
            bundles.put(bundleName, messages);
        }
        return messages;
    }

    public static ResourceBundle loadBundle(Class classObject) {
        return I18NHelper.loadBundle(I18NHelper.getPackageName(classObject.getName()) + bundleSuffix, classObject.getClassLoader());
    }

    public static final String getMessage(ResourceBundle messages, String messageKey) {
        return messages.getString(messageKey);
    }

    public static final String getMessage(ResourceBundle messages, String messageKey, Object[] msgArgs) {
        for (int i = 0; i < msgArgs.length; ++i) {
            if (msgArgs[i] != null) continue;
            msgArgs[i] = "";
        }
        MessageFormat formatter = new MessageFormat(messages.getString(messageKey));
        return formatter.format(msgArgs);
    }

    public static final String getMessage(ResourceBundle messages, String messageKey, String arg) {
        Object[] args = new Object[]{arg};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    public static final String getMessage(ResourceBundle messages, String messageKey, String arg1, String arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    public static final String getMessage(ResourceBundle messages, String messageKey, String arg1, String arg2, String arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    public static final String getMessage(ResourceBundle messages, String messageKey, Object arg) {
        Object[] args = new Object[]{arg};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    public static final String getMessage(ResourceBundle messages, String messageKey, int arg) {
        Object[] args = new Object[]{new Integer(arg)};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    public static final String getMessage(ResourceBundle messages, String messageKey, boolean arg) {
        Object[] args = new Object[]{String.valueOf(arg)};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    private static String getPackageName(String className) {
        if (className != null) {
            int index = className.lastIndexOf(46);
            return index != -1 ? className.substring(0, index) : "";
        }
        return null;
    }
}

