/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.config.support.XMLStreamReaderFilter;

class DomainXmlReader
extends XMLStreamReaderFilter {
    private String configName;
    private final URL domainXml;
    private final String serverName;
    private final boolean onlyOneConfig;
    private Logger logger;
    private XMLInputFactory xif;
    private boolean foundConfig;
    private InputStream stream;
    private final List<ServerAndConfig> serverCheckList = new LinkedList<ServerAndConfig>();

    DomainXmlReader(URL theDomainXml, XMLInputFactory theXif, Logger theLogger) throws XMLStreamException {
        this.domainXml = theDomainXml;
        this.serverName = null;
        this.onlyOneConfig = false;
        this.logger = theLogger;
        this.xif = theXif;
        try {
            this.stream = this.domainXml.openStream();
            this.setParent(this.xif.createXMLStreamReader(this.domainXml.toExternalForm(), this.stream));
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    DomainXmlReader(URL theDomainXml, String theServerName, XMLInputFactory theXif, Logger theLogger) throws XMLStreamException {
        this.domainXml = theDomainXml;
        this.serverName = theServerName;
        this.onlyOneConfig = true;
        this.logger = theLogger;
        this.xif = theXif;
        try {
            this.stream = this.domainXml.openStream();
            this.setParent(this.xif.createXMLStreamReader(this.domainXml.toExternalForm(), this.stream));
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void close() throws XMLStreamException {
        super.close();
        try {
            this.stream.close();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    boolean filterOut() throws XMLStreamException {
        this.checkConfigRef(this.getParent());
        if (!this.getLocalName().equals("config")) {
            return false;
        }
        if (this.onlyOneConfig && this.configName == null) {
            this.parse2ndTime();
            if (this.configName == null) {
                throw new XMLStreamException("Failed to parse " + this.domainXml);
            }
        }
        String theConfigName = this.getAttributeValue(null, "name");
        if (this.onlyOneConfig) {
            if (this.configName.equals(theConfigName)) {
                this.foundConfig = true;
                return false;
            }
            return true;
        }
        this.setConfigName(theConfigName);
        return false;
    }

    String getConfigName() {
        return this.configName;
    }

    String configWasFound() {
        String m1 = "Could not locate the config element: ";
        String m2 = " for the server: ";
        String m3 = "\n";
        if (this.onlyOneConfig) {
            if (this.foundConfig) {
                return null;
            }
            return "Could not locate the config element: " + this.configName + " for the server: " + this.serverName + "\n";
        }
        String msg = "";
        for (ServerAndConfig sac : this.serverCheckList) {
            if (sac.serverName == null || sac.foundConfig) continue;
            msg = msg + "Could not locate the config element: " + sac.configName + " for the server: " + sac.serverName;
        }
        if (msg.length() > 0) {
            return msg;
        }
        return null;
    }

    private void parse2ndTime() throws XMLStreamException {
        if (!this.onlyOneConfig) {
            throw new RuntimeException("Programmer Error.  Called " + this.getClass().getName() + ".parse2ndTime() for DAS.  This is illegal.");
        }
        this.logger.info("Forced to parse " + this.domainXml + " twice because we didn't see <server> before <config>");
        try {
            InputStream stream2 = this.domainXml.openStream();
            XMLStreamReader xsr = this.xif.createXMLStreamReader(this.domainXml.toExternalForm(), stream2);
            while (this.configName == null) {
                switch (xsr.next()) {
                    case 1: {
                        this.checkConfigRef(xsr);
                        break;
                    }
                }
            }
            xsr.close();
            stream2.close();
            if (this.configName == null) {
                throw new RuntimeException(this.domainXml + " contains no <config> element that matches the config-ref in the server: " + this.serverName);
            }
        }
        catch (IOException e) {
            throw new XMLStreamException("Failed to parse " + this.domainXml, e);
        }
    }

    private void checkConfigRef(XMLStreamReader xsr) {
        String elementName = xsr.getLocalName();
        if (!elementName.equals("server")) {
            return;
        }
        if (this.onlyOneConfig && this.configName != null) {
            return;
        }
        String theServerName = xsr.getAttributeValue(null, "name");
        if (theServerName == null) {
            throw new RuntimeException("<server> element is missing @name at " + this.formatLocation(xsr));
        }
        if (this.onlyOneConfig && !this.serverName.equals(theServerName)) {
            return;
        }
        String theConfigName = xsr.getAttributeValue(null, "config-ref");
        if (theConfigName == null) {
            throw new RuntimeException("<server> element is missing @config-ref at " + this.formatLocation(xsr));
        }
        if (this.onlyOneConfig) {
            this.configName = theConfigName;
        } else {
            this.setServerName(theServerName, theConfigName);
        }
    }

    private void setServerName(String theServerName, String theConfigName) {
        if (theServerName == null || theConfigName == null) {
            throw new IllegalArgumentException("null args");
        }
        if (this.onlyOneConfig) {
            throw new RuntimeException("Internal Error: Can not call setServerName if onlyOneConfig is set.");
        }
        for (ServerAndConfig sac : this.serverCheckList) {
            if (!theConfigName.equals(sac.configName)) continue;
            sac.serverName = theServerName;
            sac.foundConfig = true;
            return;
        }
        ServerAndConfig sac = new ServerAndConfig();
        sac.serverName = theServerName;
        sac.configName = theConfigName;
        sac.foundConfig = false;
        this.serverCheckList.add(sac);
    }

    private void setConfigName(String theConfigName) {
        if (theConfigName == null) {
            throw new IllegalArgumentException("null arg");
        }
        for (ServerAndConfig sac : this.serverCheckList) {
            if (!theConfigName.equals(sac.configName)) continue;
            sac.foundConfig = true;
            return;
        }
        ServerAndConfig sac = new ServerAndConfig();
        sac.configName = theConfigName;
        this.serverCheckList.add(sac);
    }

    private String formatLocation(XMLStreamReader xsr) {
        return "line " + xsr.getLocation().getLineNumber() + " at " + xsr.getLocation().getSystemId();
    }

    private static class ServerAndConfig {
        String serverName;
        String configName;
        boolean foundConfig;

        private ServerAndConfig() {
        }
    }
}

