/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.config.support.ConfigResolver;
import org.glassfish.config.support.Create;
import org.glassfish.config.support.ElementDecorator;
import org.glassfish.config.support.GenericCommandModel;
import org.glassfish.config.support.GenericCrudCommand;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Scoped(value=PerLookup.class)
public class GenericCreateCommand
extends GenericCrudCommand
implements AdminCommand,
PostConstruct,
CommandModelProvider {
    @Inject
    Habitat habitat;
    @Inject
    Inhabitant<GenericCreateCommand> myself;
    boolean skipParamValidation = true;
    boolean valid = false;
    String commandName;
    Class<ConfigBeanProxy> targetType = null;
    Class<? extends ConfigResolver> resolverType;
    CommandModel model;
    String elementName;
    Create create;
    static final Logger logger = LogDomains.getLogger(GenericCreateCommand.class, (String)"javax.enterprise.system.tools.admin");

    public void postConstruct() {
        System.out.println("Lead " + this.myself);
        List<String> indexes = this.myself.metadata().get("index");
        if (indexes.size() != 1) {
            logger.log(Level.SEVERE, "Inhabitant has more than 1 index " + indexes.get(0));
            return;
        }
        String index = indexes.get(0);
        if (index.indexOf(":") == -1) {
            logger.log(Level.SEVERE, "This is not a named service " + index);
            return;
        }
        this.commandName = index.substring(index.indexOf(":") + 1);
        String targetTypeName = this.myself.metadata().get("targetType").get(0);
        try {
            this.targetType = this.loadClass(targetTypeName);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Cannot load target type", e);
        }
        this.create = this.targetType.getAnnotation(Create.class);
        this.resolverType = this.create.resolver();
        try {
            this.elementName = this.elementName(this.create.parentType(), this.targetType);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Cannot load child type", e);
        }
        System.out.println("I create " + this.targetType.getName() + " instances which gets added to " + this.create.parentType().getName() + " under " + this.elementName);
        try {
            this.model = new GenericCommandModel(this.targetType, this.create.resolver(), this.habitat.getComponent(DomDocument.class), this.commandName);
            for (String paramName : this.model.getParametersNames()) {
                CommandModel.ParamModel param = this.model.getModelFor(paramName);
                System.out.println("I take " + param.getName() + " parameters");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Class loadClass(String type) throws ClassNotFoundException {
        return this.myself.type().getClassLoader().loadClass(type);
    }

    public void execute(final AdminCommandContext context) {
        final InjectionManager manager = new InjectionManager();
        ConfigResolver resolver = this.habitat.getComponent(this.resolverType);
        manager.inject((Object)resolver, this.getInjectionResolver());
        ConfigBeanProxy target = resolver.resolve(context, this.elementName, this.create.parentType());
        if (target == null) {
            context.logger.severe("Cannot find the target configuration");
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<ConfigBeanProxy>(){

                @Override
                public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                    ConfigBeanProxy child = param.createChild(GenericCreateCommand.this.targetType);
                    manager.inject((Object)child, GenericCreateCommand.this.targetType, GenericCreateCommand.this.getInjectionResolver());
                    Dom dom = Dom.unwrap(param);
                    dom.insertAfter(null, GenericCreateCommand.this.elementName, Dom.unwrap(child));
                    ElementDecorator decorator = GenericCreateCommand.this.habitat.getComponent(GenericCreateCommand.this.create.decorator());
                    if (decorator == null) {
                        logger.severe("Cannot find " + GenericCreateCommand.this.create.decorator() + " component in the habitat");
                    } else {
                        decorator.decorate(context, child);
                    }
                    return child;
                }
            }, target);
        }
        catch (TransactionFailure e) {
            e.printStackTrace();
        }
    }

    public CommandModel getModel() {
        return this.model;
    }
}

