/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.config.support.ConfigResolver;
import org.glassfish.config.support.Delete;
import org.glassfish.config.support.GenericCommandModel;
import org.glassfish.config.support.GenericCreateCommand;
import org.glassfish.config.support.GenericCrudCommand;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Scoped(value=PerLookup.class)
public class GenericDeleteCommand
extends GenericCrudCommand
implements AdminCommand,
PostConstruct,
CommandModelProvider {
    @Inject
    Logger logger;
    @Inject
    Inhabitant<GenericCreateCommand> myself;
    @Inject
    Habitat habitat;
    String commandName;
    Class<ConfigBeanProxy> targetType = null;
    Class<? extends ConfigResolver> resolverType;
    CommandModel model;
    String elementName;
    Delete delete;

    public CommandModel getModel() {
        return this.model;
    }

    public void postConstruct() {
        System.out.println("Lead " + this.myself);
        List<String> indexes = this.myself.metadata().get("index");
        if (indexes.size() != 1) {
            this.logger.log(Level.SEVERE, "Inhabitant has more than 1 index " + indexes.get(0));
            return;
        }
        String index = indexes.get(0);
        if (index.indexOf(":") == -1) {
            this.logger.log(Level.SEVERE, "This is not a named service " + index);
            return;
        }
        this.commandName = index.substring(index.indexOf(":") + 1);
        String targetTypeName = this.myself.metadata().get("targetType").get(0);
        try {
            this.targetType = this.loadClass(targetTypeName);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Cannot load target type", e);
        }
        this.delete = this.targetType.getAnnotation(Delete.class);
        this.resolverType = this.delete.resolver();
        try {
            this.elementName = this.elementName(this.delete.parentType(), this.targetType);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Cannot load child type", e);
        }
        System.out.println("I delete " + this.targetType.getName() + " instances stored in " + this.delete.parentType().getName() + " under " + this.elementName);
        try {
            this.model = new GenericCommandModel(null, this.delete.resolver(), this.document, this.commandName);
            for (String paramName : this.model.getParametersNames()) {
                CommandModel.ParamModel param = this.model.getModelFor(paramName);
                System.out.println("I take " + param.getName() + " parameters");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Class loadClass(String type) throws ClassNotFoundException {
        return this.myself.type().getClassLoader().loadClass(type);
    }

    public void execute(AdminCommandContext context) {
        InjectionManager manager = new InjectionManager();
        ConfigResolver resolver = this.habitat.getComponent(this.resolverType);
        manager.inject((Object)resolver, this.getInjectionResolver());
        ConfigBeanProxy target = resolver.resolve(context, this.elementName, this.targetType);
        if (target == null) {
            context.logger.severe("Cannot find the target configuration");
            return;
        }
        ConfigBean child = (ConfigBean)ConfigBean.unwrap(target);
        try {
            ConfigSupport.deleteChild((ConfigBean)child.parent(), child);
        }
        catch (TransactionFailure e) {
            e.printStackTrace();
        }
    }
}

