/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.embed;

import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.arp.AsyncFilter;
import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.http.Management;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.deployer.DeployException;
import com.sun.grizzly.http.deployer.Deployable;
import com.sun.grizzly.http.deployer.Deployer;
import com.sun.grizzly.http.deployer.DeploymentConfiguration;
import com.sun.grizzly.http.deployer.DeploymentID;
import com.sun.grizzly.http.deployer.FromURIDeployer;
import com.sun.grizzly.http.embed.Statistics;
import com.sun.grizzly.ssl.SSLSelectorThread;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyAdapterChain;
import com.sun.grizzly.tcp.http11.GrizzlyListener;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.ClassLoaderUtil;
import com.sun.grizzly.util.net.SSLImplementation;
import com.sun.grizzly.util.net.jsse.JSSEImplementation;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyWebServer {
    private static final int DEFAULT_PORT = 8080;
    private static final String DEFAULT_WEB_RESOURCES_PATH = ".";
    private GrizzlyListener grizzlyListener;
    private ObjectInstance stMBean;
    private GrizzlyAdapterChain adapterChains = new GrizzlyAdapterChain();
    private HashMap<GrizzlyAdapter, String[]> adapters = new HashMap();
    private boolean isStarted = false;
    private ArrayList<AsyncFilter> asyncFilters = new ArrayList();
    private String webResourcesPath = ".";
    private String mBeanName = "com.sun.grizzly:type=GrizzlyWebServer,name=GrizzlyHttpEngine-8080";
    private Statistics statistics;

    public GrizzlyWebServer() {
        this(8080);
    }

    public GrizzlyWebServer(int port) {
        this(port, DEFAULT_WEB_RESOURCES_PATH);
    }

    public GrizzlyWebServer(String webResourcesPath) {
        this(8080, webResourcesPath);
    }

    public GrizzlyWebServer(int port, int maxThreads) {
        this(port, maxThreads, DEFAULT_WEB_RESOURCES_PATH);
    }

    public GrizzlyWebServer(int port, String webResourcesPath) {
        this(port, webResourcesPath, false);
    }

    public GrizzlyWebServer(int port, int maxThreads, String webResourcesPath) {
        this(port, maxThreads, webResourcesPath, false);
    }

    public GrizzlyWebServer(int port, String webResourcesPath, boolean secure) {
        this(port, 5, webResourcesPath, secure);
    }

    public GrizzlyWebServer(int port, int maxThreads, String webResourcesPath, boolean secure) {
        this.createSelectorThread(port, secure);
        this.setMaxThreads(maxThreads);
        this.webResourcesPath = webResourcesPath;
    }

    private void createSelectorThread(int port, boolean secure) {
        if (secure) {
            SSLSelectorThread sslSelectorThread = new SSLSelectorThread();
            try {
                sslSelectorThread.setSSLImplementation((SSLImplementation)new JSSEImplementation());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            this.grizzlyListener = sslSelectorThread;
        } else {
            this.grizzlyListener = new SelectorThread();
        }
        ((SelectorThread)this.grizzlyListener).setPort(port);
    }

    public SelectorThread getSelectorThread() {
        this.supportHttp();
        return (SelectorThread)this.grizzlyListener;
    }

    public void addAsyncFilter(AsyncFilter asyncFilter) {
        this.asyncFilters.add(asyncFilter);
    }

    public void addGrizzlyAdapter(GrizzlyAdapter grizzlyAdapter) {
        this.adapters.put(grizzlyAdapter, new String[0]);
    }

    public void addGrizzlyAdapter(GrizzlyAdapter grizzlyAdapter, String[] mapping) {
        this.adapters.put(grizzlyAdapter, mapping);
        this.adapterChains.setHandleStaticResources(false);
        if (this.isStarted) {
            grizzlyAdapter.start();
            Adapter ga = this.grizzlyListener.getAdapter();
            if (ga instanceof GrizzlyAdapterChain) {
                ((GrizzlyAdapterChain)ga).addGrizzlyAdapter(grizzlyAdapter, mapping);
            } else {
                this.updateGrizzlyAdapters();
            }
        }
    }

    public boolean removeGrizzlyAdapter(GrizzlyAdapter grizzlyAdapter) {
        boolean removed;
        if (this.adapters.size() > 1) {
            this.adapterChains.removeAdapter(grizzlyAdapter);
        }
        boolean bl = removed = this.adapters.remove(grizzlyAdapter) != null;
        if (this.isStarted) {
            Adapter ga = this.grizzlyListener.getAdapter();
            if (ga instanceof GrizzlyAdapterChain) {
                ((GrizzlyAdapterChain)ga).removeAdapter(grizzlyAdapter);
            } else {
                this.updateGrizzlyAdapters();
            }
        }
        return removed;
    }

    public void setSSLConfig(SSLConfig sslConfig) {
        if (!(this.grizzlyListener instanceof SSLSelectorThread)) {
            throw new IllegalStateException("This instance isn't supporting SSL/HTTPS");
        }
        ((SSLSelectorThread)this.grizzlyListener).setSSLConfig(sslConfig);
    }

    public void useAsynchronousWrite(boolean asyncWrite) {
        if (!(this.grizzlyListener instanceof SelectorThread)) {
            ((SelectorThread)this.grizzlyListener).setAsyncHttpWriteEnabled(asyncWrite);
        }
    }

    public void start() throws IOException {
        SSLSelectorThread sslST;
        if (this.isStarted) {
            return;
        }
        if (this.grizzlyListener instanceof SSLSelectorThread && (sslST = (SSLSelectorThread)this.grizzlyListener).getSSLContext() == null) {
            SSLConfig sslConfig = new SSLConfig(true);
            if (!sslConfig.validateConfiguration(true)) {
                throw new RuntimeException("Failed to create default SSLConfig.");
            }
            sslST.setSSLContext(sslConfig.createSSLContext());
        }
        this.isStarted = true;
        this.updateGrizzlyAdapters();
        if (this.asyncFilters.size() > 0) {
            ((SelectorThread)this.grizzlyListener).setEnableAsyncExecution(true);
            DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
            for (AsyncFilter asyncFilter : this.asyncFilters) {
                asyncHandler.addAsyncFilter(asyncFilter);
            }
            ((SelectorThread)this.grizzlyListener).setAsyncHandler(asyncHandler);
        }
        try {
            this.grizzlyListener.listen();
        }
        catch (InstantiationException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private void updateGrizzlyAdapters() {
        this.adapterChains = new GrizzlyAdapterChain();
        if (this.adapters.size() == 0) {
            this.adapterChains.setRootFolder(this.webResourcesPath);
            this.adapterChains.setHandleStaticResources(true);
            this.grizzlyListener.setAdapter((Adapter)this.adapterChains);
        } else {
            for (Map.Entry<GrizzlyAdapter, String[]> entry : this.adapters.entrySet()) {
                if (entry.getValue() == null || entry.getValue().length == 0) {
                    this.adapterChains.addGrizzlyAdapter(entry.getKey(), new String[]{""});
                    continue;
                }
                this.adapterChains.addGrizzlyAdapter(entry.getKey(), entry.getValue());
            }
            this.grizzlyListener.setAdapter((Adapter)this.adapterChains);
            this.adapterChains.setHandleStaticResources(false);
            this.adapterChains.setRootFolder(this.webResourcesPath);
        }
    }

    public void enableJMX(Management jmxManagement) {
        this.supportHttp();
        if (jmxManagement == null) {
            return;
        }
        ((SelectorThread)this.grizzlyListener).setManagement(jmxManagement);
        try {
            ObjectName sname = new ObjectName(this.mBeanName);
            jmxManagement.registerComponent(this.grizzlyListener, sname, null);
        }
        catch (Exception ex) {
            SelectorThread.logger().log(Level.SEVERE, "Enabling JMX failed", ex);
        }
    }

    private void supportHttp() {
        if (!(this.grizzlyListener instanceof SelectorThread)) {
            throw new IllegalStateException("Not supported with GrizzlyListener: " + this.grizzlyListener);
        }
    }

    public Statistics getStatistics() {
        this.supportHttp();
        if (this.statistics == null) {
            this.statistics = new Statistics((SelectorThread)this.grizzlyListener);
        }
        return this.statistics;
    }

    public void setCoreThreads(int coreThreads) {
        this.supportHttp();
        ((SelectorThread)this.grizzlyListener).setCoreThreads(coreThreads);
    }

    public void setMaxThreads(int maxThreads) {
        this.supportHttp();
        ((SelectorThread)this.grizzlyListener).setMaxThreads(maxThreads);
    }

    public void stop() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        if (this.grizzlyListener instanceof SelectorThread) {
            ((SelectorThread)this.grizzlyListener).stopEndpoint();
        }
        if (this.statistics != null) {
            this.statistics.stopGatheringStatistics();
        }
    }

    public static final GrizzlyWebServer newConfiguredInstance(String path) {
        GrizzlyWebServer ws = new GrizzlyWebServer(8080);
        ws.addGrizzlyAdapter(new GrizzlyAdapter(path){
            {
                this.setHandleStaticResources(true);
            }

            public void service(GrizzlyRequest request, GrizzlyResponse response) {
                try {
                    response.setStatus(404);
                    response.flushBuffer();
                }
                catch (IOException ex) {
                    Logger.getLogger(GrizzlyWebServer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        return ws;
    }

    public void enableProtocol(PROTOCOL p) {
        this.isStarted = false;
        if (p == PROTOCOL.AJP) {
            this.grizzlyListener = (GrizzlyListener)ClassLoaderUtil.load((String)"com.sun.grizzly.http.jk.server.JkCoyoteHandler");
            this.grizzlyListener.setAdapter(this.adapter());
        } else {
            this.createSelectorThread(8080, this.isStarted);
        }
    }

    private Adapter adapter() {
        if (this.adapters.size() == 1) {
            this.adapters.keySet().iterator().next().setRootFolder(this.webResourcesPath);
            return (Adapter)this.adapters.keySet().iterator().next();
        }
        return this.adapterChains;
    }

    public <T extends Deployable, V extends DeploymentConfiguration> DeploymentID deploy(T toDeploy, Deployer<T, V> deployer, V configuration) throws DeployException {
        return deployer.deploy(this, (V)((Object)toDeploy), (T)((Object)configuration));
    }

    public <T extends Deployable, V extends DeploymentConfiguration> DeploymentID deploy(URI fromURI, FromURIDeployer<T, V> deployer, V configuration) throws DeployException {
        return deployer.deploy(this, fromURI, configuration);
    }

    public <T extends Deployable, V extends DeploymentConfiguration> void undeploy(DeploymentID deploymentId, Deployer<T, V> deployer) {
        deployer.undeploy(this, deploymentId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PROTOCOL {
        HTTP,
        AJP;

    }
}

