/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.ssl;

import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.async.AsyncQueueWriteUnit;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.http.SocketChannelOutputBuffer;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.SSLOutputWriter;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;

public class SSLOutputBuffer
extends SocketChannelOutputBuffer {
    private static final AsyncWriteCallbackHandler asyncHttpWriteCallbackHandler = new AsyncWriteCallbackHandlerImpl();
    private SSLEngine sslEngine;

    public SSLOutputBuffer(Response response, int headerBufferSize, boolean useSocketBuffer) {
        super(response, headerBufferSize, useSocketBuffer);
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public void setSslEngine(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    public void flushChannel(ByteBuffer bb) throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("SSLOutputBuffer.flushChannel isAsyncHttpWriteEnabled=" + this.isAsyncHttpWriteEnabled + " bb=" + bb);
        }
        boolean isBufferAssociated = true;
        ByteBuffer securedBB = null;
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof WorkerThread) {
            securedBB = ((WorkerThread)currentThread).getOutputBB();
        }
        int requiredBBSize = this.sslEngine.getSession().getPacketBufferSize();
        if (securedBB == null || securedBB.capacity() < requiredBBSize) {
            securedBB = (ByteBuffer)bufferPool.poll();
            if (securedBB == null || securedBB.capacity() < requiredBBSize) {
                securedBB = ByteBufferFactory.allocateView((int)(requiredBBSize * 2), (securedBB != null && securedBB.isDirect() ? 1 : 0) != 0);
            }
            securedBB.limit(securedBB.position());
            isBufferAssociated = this.associateWithThread(securedBB);
        }
        if (!this.isAsyncHttpWriteEnabled) {
            SSLOutputWriter.flushChannel((SelectableChannel)((SocketChannel)this.channel), (ByteBuffer)bb, (ByteBuffer)securedBB, (SSLEngine)this.sslEngine);
            if (!isBufferAssociated) {
                bufferPool.offer(securedBB);
            } else {
                securedBB.limit(securedBB.position());
            }
        } else if (this.asyncQueueWriter != null) {
            this.checkMaxBufferSize(this.sslEngine);
            Future future = this.asyncQueueWriter.write(this.selectionKey, bb, asyncHttpWriteCallbackHandler, (AsyncQueueDataProcessor)new SSLWritePreProcessor(this.sslEngine, securedBB), this.asyncHttpByteBufferCloner);
            if (!future.isDone()) {
                ByteBuffer buffer = (ByteBuffer)bufferPool.poll();
                requiredBBSize = this.sslEngine.getSession().getPacketBufferSize();
                if (buffer != null && buffer.capacity() >= requiredBBSize) {
                    buffer.limit(buffer.position());
                    this.associateWithThread(buffer);
                } else {
                    if (buffer != null) {
                        bufferPool.offer(buffer);
                    }
                    ByteBuffer newBB = ByteBufferFactory.allocateView((int)(requiredBBSize * 2), (boolean)securedBB.isDirect());
                    newBB.limit(newBB.position());
                    this.associateWithThread(newBB);
                }
            } else {
                securedBB.limit(securedBB.position());
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("SSLOutputBuffer.async flushChannel isDone=" + future.isDone());
            }
            if (!bb.hasRemaining()) {
                bb.clear();
            }
        } else {
            logger.warning("HTTPS async write is enabled, but AsyncWriter is null.");
        }
    }

    private void checkMaxBufferSize(SSLEngine sslEngine) {
        int packetBufferSize = sslEngine.getSession().getPacketBufferSize();
        if (packetBufferSize > maxBufferedBytes && maxBufferedBytes == 262144) {
            maxBufferedBytes = packetBufferSize;
        }
    }

    public boolean isSupportFileSend() {
        return false;
    }

    public void recycle() {
        this.sslEngine = null;
        super.recycle();
    }

    private boolean associateWithThread(ByteBuffer buffer) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof WorkerThread) {
            ((WorkerThread)currentThread).setOutputBB(buffer);
            return true;
        }
        return false;
    }

    protected static class AsyncWriteCallbackHandlerImpl
    extends SocketChannelOutputBuffer.AsyncWriteCallbackHandlerImpl {
        protected AsyncWriteCallbackHandlerImpl() {
        }

        protected boolean releaseAsyncWriteUnit(AsyncQueueWriteUnit unit) {
            if (unit.isCloned()) {
                SSLWritePreProcessor processor = (SSLWritePreProcessor)unit.getWritePreProcessor();
                this.returnBuffer(processor.getInternalByteBuffer());
            }
            return super.releaseAsyncWriteUnit(unit);
        }
    }

    private static class SSLWritePreProcessor
    implements AsyncQueueDataProcessor {
        private final SSLEngine sslEngine;
        private final ByteBuffer securedOutputBuffer;

        public SSLWritePreProcessor(SSLEngine sslEngine, ByteBuffer securedOutputBuffer) {
            this.sslEngine = sslEngine;
            this.securedOutputBuffer = securedOutputBuffer;
        }

        public ByteBuffer getInternalByteBuffer() {
            return this.securedOutputBuffer;
        }

        public void process(ByteBuffer byteBuffer) throws IOException {
            if (!byteBuffer.hasRemaining() || this.securedOutputBuffer.hasRemaining()) {
                return;
            }
            this.securedOutputBuffer.clear();
            try {
                this.sslEngine.wrap(byteBuffer, this.securedOutputBuffer);
                this.securedOutputBuffer.flip();
            }
            catch (Exception e) {
                this.securedOutputBuffer.position(this.securedOutputBuffer.limit());
                throw new IOException(e.getMessage());
            }
        }
    }
}

