/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.catalina.realm.JAASRealm;

public class JAASCallbackHandler
implements CallbackHandler {
    protected String password = null;
    protected JAASRealm realm = null;
    protected String username = null;

    public JAASCallbackHandler(JAASRealm realm, String username, String password) {
        this.realm = realm;
        this.username = username;
        this.password = password;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                if (this.realm.getDebug() >= 3) {
                    this.realm.log("Returning username " + this.username);
                }
                ((NameCallback)callbacks[i]).setName(this.username);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                if (this.realm.getDebug() >= 3) {
                    this.realm.log("Returning password " + this.password);
                }
                char[] passwordcontents = this.password != null ? this.password.toCharArray() : new char[]{};
                ((PasswordCallback)callbacks[i]).setPassword(passwordcontents);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }
}

