/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.AttachedObjectListHolder;
import javax.faces.component.ContextCallback;
import javax.faces.component.NamingContainer;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import javax.faces.component.StateHolderSaver;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UniqueIdVendor;
import javax.faces.component.ValueBindingValueExpressionAdapter;
import javax.faces.component.ValueExpressionValueBindingAdapter;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreRemoveFromViewEvent;
import javax.faces.event.PreRenderComponentEvent;
import javax.faces.event.PreValidateEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.render.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIComponentBase
extends UIComponent {
    private static Logger LOGGER = Logger.getLogger("javax.faces.component", "javax.faces.LogStrings");
    private static final String ADDED = UIComponentBase.class.getName() + ".ADDED";
    private static Map<Class<?>, Map<String, PropertyDescriptor>> descriptors = new WeakHashMap();
    private Map<String, PropertyDescriptor> pdMap = null;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private AttributesMap attributes = null;
    private String clientId = null;
    private String id = null;
    private UIComponent parent = null;
    private List<UIComponent> children = null;
    private Map<String, UIComponent> facets = null;
    private AttachedObjectListHolder<FacesListener> listeners;
    private static final int MY_STATE = 0;
    private static final int CHILD_STATE = 1;
    private Object[] values;
    private boolean transientFlag = false;
    private BehaviorsMap behaviors;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Iterator<UIComponent> EMPTY_ITERATOR = new Iterator<UIComponent>(){

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UIComponent next() {
            throw new NoSuchElementException("Empty Iterator");
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    };

    public UIComponentBase() {
        this.populateDescriptorsMapIfNecessary();
    }

    private void populateDescriptorsMapIfNecessary() {
        Class<?> clazz = this.getClass();
        this.pdMap = descriptors.get(clazz);
        if (null != this.pdMap) {
            return;
        }
        PropertyDescriptor[] pd = this.getPropertyDescriptors();
        if (pd != null) {
            Map<String, PropertyDescriptor> reCheckMap;
            this.pdMap = new HashMap<String, PropertyDescriptor>(pd.length, 1.0f);
            for (PropertyDescriptor aPd : pd) {
                this.pdMap.put(aPd.getName(), aPd);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "fine.component.populating_descriptor_map", new Object[]{clazz, Thread.currentThread().getName()});
            }
            if (null != (reCheckMap = descriptors.get(clazz))) {
                return;
            }
            descriptors.put(clazz, this.pdMap);
        }
    }

    private PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] pd;
        try {
            pd = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new FacesException(e);
        }
        return pd;
    }

    @Override
    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributesMap(this);
        }
        return this.attributes;
    }

    @Override
    public ValueBinding getValueBinding(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        ValueBinding result = null;
        ValueExpression ve = this.getValueExpression(name);
        if (null != ve) {
            result = ve.getClass().equals(ValueExpressionValueBindingAdapter.class) ? ((ValueExpressionValueBindingAdapter)ve).getWrapped() : new ValueBindingValueExpressionAdapter(ve);
        }
        return result;
    }

    @Override
    public void setValueBinding(String name, ValueBinding binding) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (binding != null) {
            ValueExpressionValueBindingAdapter adapter = new ValueExpressionValueBindingAdapter(binding);
            this.setValueExpression(name, adapter);
        } else {
            this.setValueExpression(name, null);
        }
    }

    @Override
    public String getClientId(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.clientId == null) {
            Renderer renderer;
            UIComponent namingContainerAncestor;
            UIComponent parent = namingContainerAncestor = this.getNamingContainerAncestor();
            String parentId = null;
            if (parent != null) {
                parentId = parent.getContainerClientId(context);
            }
            this.clientId = this.getId();
            if (this.clientId == null) {
                String generatedId = null != namingContainerAncestor && namingContainerAncestor instanceof UniqueIdVendor ? ((UniqueIdVendor)((Object)namingContainerAncestor)).createUniqueId(context, null) : context.getViewRoot().createUniqueId();
                this.setId(generatedId);
                this.clientId = this.getId();
            }
            if (parentId != null) {
                StringBuilder idBuilder = new StringBuilder(parentId.length() + 1 + this.clientId.length());
                this.clientId = idBuilder.append(parentId).append(UINamingContainer.getSeparatorChar(context)).append(this.clientId).toString();
            }
            if ((renderer = this.getRenderer(context)) != null) {
                this.clientId = renderer.convertClientId(context, this.clientId);
            }
        }
        return this.clientId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    private UIComponent getNamingContainerAncestor() {
        for (UIComponent namingContainer = this.getParent(); namingContainer != null; namingContainer = namingContainer.getParent()) {
            if (!(namingContainer instanceof NamingContainer)) continue;
            return namingContainer;
        }
        return null;
    }

    @Override
    public void setId(String id) {
        if (this.id == null || !this.id.equals(id)) {
            UIComponentBase.validateId(id);
            this.id = id;
        }
        this.clientId = null;
    }

    @Override
    public UIComponent getParent() {
        return this.parent;
    }

    @Override
    public void setParent(UIComponent parent) {
        if (parent == null) {
            if (this.parent != null) {
                this.doPreRemoveProcessing(FacesContext.getCurrentInstance(), this);
                this.parent = parent;
            }
            this.compositeParent = null;
        } else {
            this.parent = parent;
            if (this.getAttributes().get(ADDED) == null) {
                this.getAttributes().put(ADDED, Boolean.TRUE);
                this.doPostAddProcessing(FacesContext.getCurrentInstance(), this);
                this.getAttributes().remove(ADDED);
            }
        }
    }

    @Override
    public boolean isRendered() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)UIComponent.PropertyKeys.rendered), Boolean.TRUE).toString());
    }

    @Override
    public void setRendered(boolean rendered) {
        this.getStateHelper().put((Serializable)((Object)UIComponent.PropertyKeys.rendered), rendered);
    }

    @Override
    public String getRendererType() {
        return (String)this.getStateHelper().eval((Serializable)((Object)UIComponent.PropertyKeys.rendererType));
    }

    @Override
    public void setRendererType(String rendererType) {
        this.getStateHelper().put((Serializable)((Object)UIComponent.PropertyKeys.rendererType), rendererType);
    }

    @Override
    public boolean getRendersChildren() {
        Renderer renderer;
        boolean result = false;
        if (this.getRendererType() != null && null != (renderer = this.getRenderer(this.getFacesContext()))) {
            result = renderer.getRendersChildren();
        }
        return result;
    }

    @Override
    public List<UIComponent> getChildren() {
        if (this.children == null) {
            this.children = new ChildrenList(this);
        }
        return this.children;
    }

    @Override
    public int getChildCount() {
        if (this.children != null) {
            return this.children.size();
        }
        return 0;
    }

    private static void eraseParent(UIComponent component) {
        List<UIComponent> children;
        int index;
        UIComponent parent = component.getParent();
        if (parent == null) {
            return;
        }
        if (parent.getChildCount() > 0 && (index = (children = parent.getChildren()).indexOf(component)) >= 0) {
            children.remove(index);
            return;
        }
        if (parent.getFacetCount() > 0) {
            Map<String, UIComponent> facets = parent.getFacets();
            Iterator<Map.Entry<String, UIComponent>> entries = facets.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<String, UIComponent> entry = entries.next();
                if (entry.getValue() != component) continue;
                entries.remove();
                return;
            }
        }
        throw new IllegalStateException("Parent was not null, but this component not related");
    }

    private static void validateId(String id) {
        if (id == null) {
            return;
        }
        int n = id.length();
        if (n < 1) {
            throw new IllegalArgumentException("Empty id attribute is not allowed");
        }
        for (int i = 0; i < n; ++i) {
            char c = id.charAt(i);
            if (!(i == 0 ? !Character.isLetter(c) && c != '_' : !Character.isLetter(c) && !Character.isDigit(c) && c != '-' && c != '_')) continue;
            throw new IllegalArgumentException(id);
        }
    }

    @Override
    public UIComponent findComponent(String expr) {
        if (expr == null) {
            throw new NullPointerException();
        }
        FacesContext ctx = FacesContext.getCurrentInstance();
        char sepChar = UINamingContainer.getSeparatorChar(ctx);
        String SEPARATOR_STRING = String.valueOf(sepChar);
        if (expr.length() == 0) {
            throw new IllegalArgumentException("\"\"");
        }
        UIComponent base = this;
        if (expr.charAt(0) == sepChar) {
            while (base.getParent() != null) {
                base = base.getParent();
            }
            expr = expr.substring(1);
        } else if (!(base instanceof NamingContainer)) {
            while (base.getParent() != null && !(base instanceof NamingContainer)) {
                base = base.getParent();
            }
        }
        UIComponent result = null;
        String[] segments = expr.split(SEPARATOR_STRING);
        int i = 0;
        int length = segments.length - 1;
        while (i < segments.length) {
            result = UIComponentBase.findComponent(base, segments[i], i == 0);
            if (i == 0 && result == null && segments[i].equals(base.getId())) {
                result = base;
            }
            if (result != null && !(result instanceof NamingContainer) && length > 0) {
                throw new IllegalArgumentException(segments[i]);
            }
            if (result == null) break;
            base = result;
            ++i;
            --length;
        }
        return result;
    }

    private static UIComponent findComponent(UIComponent base, String id, boolean checkId) {
        if (checkId && id.equals(base.getId())) {
            return base;
        }
        UIComponent result = null;
        Iterator<UIComponent> i = base.getFacetsAndChildren();
        while (i.hasNext()) {
            UIComponent kid = i.next();
            if (!(kid instanceof NamingContainer)) {
                if (checkId && id.equals(kid.getId())) {
                    result = kid;
                    break;
                }
                result = UIComponentBase.findComponent(kid, id, true);
                if (result == null) continue;
                break;
            }
            if (!id.equals(kid.getId())) continue;
            result = kid;
            break;
        }
        return result;
    }

    @Override
    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        return super.invokeOnComponent(context, clientId, callback);
    }

    @Override
    public Map<String, UIComponent> getFacets() {
        if (this.facets == null) {
            this.facets = new FacetsMap(this);
        }
        return this.facets;
    }

    @Override
    public int getFacetCount() {
        if (this.facets != null) {
            return this.facets.size();
        }
        return 0;
    }

    @Override
    public UIComponent getFacet(String name) {
        if (this.facets != null) {
            return this.facets.get(name);
        }
        return null;
    }

    @Override
    public Iterator<UIComponent> getFacetsAndChildren() {
        Iterator<UIComponent> result;
        int childCount = this.getChildCount();
        int facetCount = this.getFacetCount();
        if (0 == childCount && 0 == facetCount) {
            result = EMPTY_ITERATOR;
        } else if (0 == childCount) {
            Collection<UIComponent> unmodifiable = Collections.unmodifiableCollection(this.getFacets().values());
            result = unmodifiable.iterator();
        } else if (0 == facetCount) {
            List<UIComponent> unmodifiable = Collections.unmodifiableList(this.getChildren());
            result = unmodifiable.iterator();
        } else {
            result = new FacetsAndChildrenIterator(this);
        }
        return result;
    }

    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event == null) {
            throw new NullPointerException();
        }
        if (event instanceof BehaviorEvent) {
            BehaviorEvent behaviorEvent = (BehaviorEvent)event;
            Behavior behavior = behaviorEvent.getBehavior();
            behavior.broadcast(behaviorEvent);
        }
        if (this.listeners == null) {
            return;
        }
        for (FacesListener listener : this.listeners.asArray(FacesListener.class)) {
            if (!event.isAppropriateListener(listener)) continue;
            event.processListener(listener);
        }
    }

    @Override
    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            Renderer renderer = this.getRenderer(context);
            if (renderer != null) {
                renderer.decode(context, this);
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Can't get Renderer for type " + rendererType);
            }
        }
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        this.pushComponentToEL(context, null);
        if (!this.isRendered()) {
            return;
        }
        context.getApplication().publishEvent(context, PreRenderComponentEvent.class, this);
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            Renderer renderer = this.getRenderer(context);
            if (renderer != null) {
                renderer.encodeBegin(context, this);
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Can't get Renderer for type " + rendererType);
            }
        }
    }

    @Override
    public void encodeChildren(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            Renderer renderer = this.getRenderer(context);
            if (renderer != null) {
                renderer.encodeChildren(context, this);
            }
        } else if (this.getChildCount() > 0) {
            for (UIComponent child : this.getChildren()) {
                child.encodeAll(context);
            }
        }
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        Renderer renderer;
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            this.popComponentFromEL(context);
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null && (renderer = this.getRenderer(context)) != null) {
            renderer.encodeEnd(context, this);
        }
        this.popComponentFromEL(context);
    }

    @Override
    protected void addFacesListener(FacesListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            this.listeners = new AttachedObjectListHolder();
        }
        this.listeners.add(listener);
    }

    @Override
    protected FacesListener[] getFacesListeners(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (!FacesListener.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        if (this.listeners == null) {
            return (FacesListener[])Array.newInstance(clazz, 0);
        }
        FacesListener[] listeners = this.listeners.asArray(FacesListener.class);
        if (listeners.length == 0) {
            return (FacesListener[])Array.newInstance(clazz, 0);
        }
        ArrayList<FacesListener> results = new ArrayList<FacesListener>(listeners.length);
        for (FacesListener listener : listeners) {
            if (!clazz.isAssignableFrom(listener.getClass())) continue;
            results.add(listener);
        }
        return results.toArray((FacesListener[])Array.newInstance(clazz, results.size()));
    }

    @Override
    protected void removeFacesListener(FacesListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        UIComponent parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException();
        }
        parent.queueEvent(event);
    }

    @Override
    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        Iterator<UIComponent> kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = kids.next();
            kid.processDecodes(context);
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        finally {
            this.popComponentFromEL(context);
        }
    }

    @Override
    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        Application app = context.getApplication();
        app.publishEvent(context, PreValidateEvent.class, this);
        Iterator<UIComponent> kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = kids.next();
            kid.processValidators(context);
        }
        app.publishEvent(context, PostValidateEvent.class, this);
        this.popComponentFromEL(context);
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        Iterator<UIComponent> kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = kids.next();
            kid.processUpdates(context);
        }
        this.popComponentFromEL(context);
    }

    @Override
    public Object processSaveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.isTransient()) {
            return null;
        }
        Object[] stateStruct = new Object[2];
        Object[] childState = EMPTY_ARRAY;
        this.pushComponentToEL(context, null);
        stateStruct[0] = this.saveState(context);
        int count = this.getChildCount() + this.getFacetCount();
        if (count > 0) {
            ArrayList<Object> stateList = new ArrayList<Object>(count);
            if (this.getChildCount() > 0) {
                for (UIComponent kid : this.getChildren()) {
                    if (kid.isTransient()) continue;
                    stateList.add(kid.processSaveState(context));
                    this.popComponentFromEL(context);
                }
            }
            this.pushComponentToEL(context, null);
            if (this.getFacetCount() > 0) {
                for (Map.Entry<String, UIComponent> entry : this.getFacets().entrySet()) {
                    UIComponent facet = entry.getValue();
                    if (facet.isTransient()) continue;
                    Object facetState = facet.processSaveState(context);
                    this.popComponentFromEL(context);
                    Object[] facetSaveState = new Object[]{entry.getKey(), facetState};
                    stateList.add(facetSaveState);
                }
            }
            childState = stateList.toArray();
        }
        stateStruct[1] = childState;
        return stateStruct;
    }

    @Override
    public void processRestoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object[] stateStruct = (Object[])state;
        Object[] childState = (Object[])stateStruct[1];
        this.restoreState(context, stateStruct[0]);
        int i = 0;
        if (this.getChildCount() > 0) {
            for (UIComponent kid : this.getChildren()) {
                Object currentState;
                if (kid.isTransient() || (currentState = childState[i++]) == null) continue;
                this.pushComponentToEL(context, null);
                kid.processRestoreState(context, currentState);
                this.popComponentFromEL(context);
            }
        }
        if (this.getFacetCount() > 0) {
            int facetsSize = this.getFacets().size();
            for (int j = 0; j < facetsSize; ++j) {
                Object[] facetSaveState;
                if (null == (facetSaveState = (Object[])childState[i++])) continue;
                String facetName = (String)facetSaveState[0];
                Object facetState = facetSaveState[1];
                UIComponent facet = this.getFacets().get(facetName);
                this.pushComponentToEL(context, null);
                facet.processRestoreState(context, facetState);
                this.popComponentFromEL(context);
            }
        }
    }

    @Override
    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    @Override
    protected Renderer getRenderer(FacesContext context) {
        String rendererType = this.getRendererType();
        Renderer result = null;
        if (rendererType != null) {
            result = context.getRenderKit().getRenderer(this.getFamily(), rendererType);
            if (null == result && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Can't get Renderer for type " + rendererType);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            String id = this.getId();
            id = null != id ? id : this.getClass().getName();
            LOGGER.fine("No renderer-type for component " + id);
        }
        return result;
    }

    @Override
    public void markInitialState() {
        super.markInitialState();
        if (this.listeners != null) {
            this.listeners.markInitialState();
        }
        if (this.listenersByEventClass != null) {
            for (List list : this.listenersByEventClass.values()) {
                if (!(list instanceof PartialStateHolder)) continue;
                ((PartialStateHolder)((Object)list)).markInitialState();
            }
        }
        if (this.behaviors != null) {
            for (Map.Entry entry : this.behaviors.entrySet()) {
                for (ClientBehavior behavior : (List)entry.getValue()) {
                    if (!(behavior instanceof PartialStateHolder)) continue;
                    ((PartialStateHolder)((Object)behavior)).markInitialState();
                }
            }
        }
    }

    @Override
    public void clearInitialState() {
        super.clearInitialState();
        if (this.listeners != null) {
            this.listeners.clearInitialState();
        }
        if (this.listenersByEventClass != null) {
            for (List list : this.listenersByEventClass.values()) {
                if (!(list instanceof PartialStateHolder)) continue;
                ((PartialStateHolder)((Object)list)).clearInitialState();
            }
        }
        if (this.behaviors != null) {
            for (Map.Entry entry : this.behaviors.entrySet()) {
                for (ClientBehavior behavior : (List)entry.getValue()) {
                    if (!(behavior instanceof PartialStateHolder)) continue;
                    ((PartialStateHolder)((Object)behavior)).clearInitialState();
                }
            }
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        assert (!this.transientFlag);
        if (this.initialStateMarked()) {
            Object savedFacesListeners = this.listeners != null ? this.listeners.saveState(context) : null;
            Object savedSysEventListeners = this.saveSystemEventListeners(context);
            Object savedBehaviors = this.saveBehaviorsState(context);
            Object savedBindings = null;
            if (this.bindings != null) {
                savedBindings = this.saveBindingsState(context);
            }
            Object savedHelper = null;
            if (this.stateHelper != null) {
                savedHelper = this.stateHelper.saveState(this.getFacesContext());
            }
            if (savedFacesListeners == null && savedSysEventListeners == null && savedBehaviors == null && savedBindings == null && savedHelper == null) {
                return null;
            }
            if (this.values == null || this.values.length != 5) {
                this.values = new Object[5];
            }
            this.values[0] = savedFacesListeners;
            this.values[1] = savedSysEventListeners;
            this.values[2] = savedBehaviors;
            this.values[3] = savedBindings;
            this.values[4] = savedHelper;
            return this.values;
        }
        if (this.values == null || this.values.length != 6) {
            this.values = new Object[6];
        }
        this.values[0] = this.listeners != null ? this.listeners.saveState(context) : null;
        this.values[1] = this.saveSystemEventListeners(context);
        this.values[2] = this.saveBehaviorsState(context);
        if (this.bindings != null) {
            this.values[3] = this.saveBindingsState(context);
        }
        if (this.stateHelper != null) {
            this.values[4] = this.stateHelper.saveState(this.getFacesContext());
        }
        this.values[5] = this.id;
        return this.values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            return;
        }
        this.values = (Object[])state;
        if (this.values[0] != null) {
            if (this.listeners == null) {
                this.listeners = new AttachedObjectListHolder();
            }
            this.listeners.restoreState(context, this.values[0]);
        }
        if (this.values[1] != null) {
            Map<Class<? extends SystemEvent>, List<SystemEventListener>> m = this.restoreSystemEventListeners(context, this.values[1]);
            if (this.listenersByEventClass != null) {
                this.listenersByEventClass.putAll(m);
            } else {
                this.listenersByEventClass = m;
            }
        }
        if (this.values[2] != null) {
            this.behaviors = this.restoreBehaviorsState(context, this.values[2]);
        }
        if (this.values[3] != null) {
            this.bindings = UIComponentBase.restoreBindingsState(context, this.values[3]);
        }
        if (this.values[4] != null) {
            this.getStateHelper().restoreState(this.getFacesContext(), this.values[4]);
        }
        if (this.values.length == 6 && this.values[5] != null) {
            this.id = (String)this.values[5];
        }
    }

    @Override
    public boolean isTransient() {
        return this.transientFlag;
    }

    @Override
    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    public static Object saveAttachedState(FacesContext context, Object attachedObject) {
        StateHolderSaver result;
        if (null == context) {
            throw new NullPointerException();
        }
        if (null == attachedObject) {
            return null;
        }
        if (attachedObject instanceof Collection) {
            Collection attachedCollection = (Collection)attachedObject;
            ArrayList<StateHolderSaver> resultList = null;
            for (Object item : attachedCollection) {
                if (item == null || item instanceof StateHolder && ((StateHolder)item).isTransient()) continue;
                if (resultList == null) {
                    resultList = new ArrayList<StateHolderSaver>(attachedCollection.size() + 1);
                    resultList.add(new StateHolderSaver(context, attachedCollection.getClass()));
                }
                resultList.add(new StateHolderSaver(context, item));
            }
            result = resultList;
        } else {
            result = new StateHolderSaver(context, attachedObject);
        }
        return result;
    }

    public static Object restoreAttachedState(FacesContext context, Object stateObj) throws IllegalStateException {
        Object result;
        if (null == context) {
            throw new NullPointerException();
        }
        if (null == stateObj) {
            return null;
        }
        if (stateObj instanceof List) {
            List stateList = (List)stateObj;
            Collection retCollection = null;
            StateHolderSaver collectionSaver = (StateHolderSaver)stateList.get(0);
            Class collectionClass = (Class)collectionSaver.restore(context);
            try {
                retCollection = (Collection)collectionClass.newInstance();
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
                throw new IllegalStateException("Unknown object type");
            }
            int len = stateList.size();
            for (int i = 1; i < len; ++i) {
                try {
                    retCollection.add(((StateHolderSaver)stateList.get(i)).restore(context));
                    continue;
                }
                catch (ClassCastException cce) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, cce.toString(), cce);
                    }
                    throw new IllegalStateException("Unknown object type");
                }
            }
            result = retCollection;
        } else if (stateObj instanceof StateHolderSaver) {
            StateHolderSaver saver = (StateHolderSaver)stateObj;
            result = saver.restore(context);
        } else {
            throw new IllegalStateException("Unknown object type");
        }
        return result;
    }

    private static Map<String, ValueExpression> restoreBindingsState(FacesContext context, Object state) {
        if (state == null) {
            return null;
        }
        Object[] values = (Object[])state;
        String[] names = (String[])values[0];
        Object[] states = (Object[])values[1];
        HashMap<String, ValueExpression> bindings = new HashMap<String, ValueExpression>(names.length);
        for (int i = 0; i < names.length; ++i) {
            bindings.put(names[i], (ValueExpression)UIComponentBase.restoreAttachedState(context, states[i]));
        }
        return bindings;
    }

    private Object saveBindingsState(FacesContext context) {
        if (this.bindings == null) {
            return null;
        }
        Object[] values = new Object[2];
        values[0] = this.bindings.keySet().toArray(new String[this.bindings.size()]);
        Object[] bindingValues = this.bindings.values().toArray();
        for (int i = 0; i < bindingValues.length; ++i) {
            bindingValues[i] = UIComponentBase.saveAttachedState(context, bindingValues[i]);
        }
        values[1] = bindingValues;
        return values;
    }

    private Object saveSystemEventListeners(FacesContext ctx) {
        if (this.listenersByEventClass == null) {
            return null;
        }
        int size = this.listenersByEventClass.size();
        Object[][] listeners = new Object[size][2];
        int idx = 0;
        boolean savedState = false;
        for (Map.Entry e : this.listenersByEventClass.entrySet()) {
            Object[] target = listeners[idx++];
            target[0] = e.getKey();
            target[1] = UIComponentBase.saveAttachedState(ctx, e.getValue());
            if (target[1] == null) {
                target[0] = null;
                continue;
            }
            savedState = true;
        }
        return savedState ? listeners : (Object[][])null;
    }

    private Map<Class<? extends SystemEvent>, List<SystemEventListener>> restoreSystemEventListeners(FacesContext ctx, Object state) {
        if (state == null) {
            return null;
        }
        Object[][] listeners = (Object[][])state;
        HashMap<Class<? extends SystemEvent>, List<SystemEventListener>> m = new HashMap<Class<? extends SystemEvent>, List<SystemEventListener>>(listeners.length, 1.0f);
        for (Object[] source : listeners) {
            m.put((Class)source[0], (List)UIComponentBase.restoreAttachedState(ctx, source[1]));
        }
        return m;
    }

    Map<String, PropertyDescriptor> getDescriptorMap() {
        return this.pdMap;
    }

    private void doPostAddProcessing(FacesContext context, UIComponent added) {
        if (this.parent.isInView()) {
            UIComponentBase.publishAfterViewEvents(context, context.getApplication(), added);
        }
    }

    private void doPreRemoveProcessing(FacesContext context, UIComponent toRemove) {
        if (this.parent.isInView()) {
            UIComponentBase.disconnectFromView(context, context.getApplication(), toRemove);
        }
    }

    public void addClientBehavior(String eventName, ClientBehavior behavior) {
        this.assertClientBehaviorHolder();
        Collection<String> eventNames = this.getEventNames();
        if (eventNames == null) {
            throw new IllegalStateException("Attempting to add a Behavior to a component that does not support any event types. getEventTypes() must return a non-null Set.");
        }
        if (eventNames.contains(eventName)) {
            ArrayList<ClientBehavior> eventBehaviours;
            if (this.initialStateMarked() && this.behaviors != null) {
                for (Map.Entry<String, List<ClientBehavior>> entry : this.behaviors.entrySet()) {
                    for (ClientBehavior b : entry.getValue()) {
                        if (!(b instanceof PartialStateHolder)) continue;
                        ((PartialStateHolder)((Object)behavior)).clearInitialState();
                    }
                }
            }
            if (null == this.behaviors) {
                HashMap modifiableMap = new HashMap(5, 1.0f);
                this.behaviors = new BehaviorsMap(modifiableMap);
            }
            if (null == (eventBehaviours = (ArrayList<ClientBehavior>)this.behaviors.get(eventName))) {
                eventBehaviours = new ArrayList<ClientBehavior>(3);
                this.behaviors.getModifiableMap().put(eventName, eventBehaviours);
            }
            eventBehaviours.add(behavior);
        }
    }

    public Collection<String> getEventNames() {
        this.assertClientBehaviorHolder();
        return null;
    }

    public Map<String, List<ClientBehavior>> getClientBehaviors() {
        if (null == this.behaviors) {
            return Collections.emptyMap();
        }
        return this.behaviors;
    }

    public String getDefaultEventName() {
        this.assertClientBehaviorHolder();
        return null;
    }

    private void assertClientBehaviorHolder() {
        if (!this.isClientBehaviorHolder()) {
            throw new IllegalStateException("Attempting to use a Behavior feature with a component that does not support any event types. Component must implement BehaviourHolder interface.");
        }
    }

    private boolean isClientBehaviorHolder() {
        return ClientBehaviorHolder.class.isInstance(this);
    }

    private Object saveBehaviorsState(FacesContext context) {
        Object[] state = null;
        if (null != this.behaviors && this.behaviors.size() > 0) {
            boolean stateWritten = false;
            Object[] attachedBehaviors = new Object[this.behaviors.size()];
            int i = 0;
            for (List eventBehaviors : this.behaviors.values()) {
                Object[] attachedEventBehaviors = new Object[eventBehaviors.size()];
                for (int j = 0; j < attachedEventBehaviors.length; ++j) {
                    Object object = attachedEventBehaviors[j] = this.initialStateMarked() ? this.saveBehavior(context, (ClientBehavior)eventBehaviors.get(j)) : UIComponentBase.saveAttachedState(context, eventBehaviors.get(j));
                    if (stateWritten) continue;
                    stateWritten = attachedEventBehaviors[j] != null;
                }
                attachedBehaviors[i++] = attachedEventBehaviors;
            }
            if (stateWritten) {
                state = new Object[]{this.behaviors.keySet().toArray(new String[this.behaviors.size()]), attachedBehaviors};
            }
        }
        return state;
    }

    private BehaviorsMap restoreBehaviorsState(FacesContext context, Object state) {
        if (null != state) {
            Object[] values = (Object[])state;
            String[] names = (String[])values[0];
            Object[] attachedBehaviors = (Object[])values[1];
            if (!this.initialStateMarked()) {
                HashMap modifiableMap = new HashMap(names.length, 1.0f);
                for (int i = 0; i < attachedBehaviors.length; ++i) {
                    Object[] attachedEventBehaviors = (Object[])attachedBehaviors[i];
                    ArrayList<ClientBehavior> eventBehaviors = new ArrayList<ClientBehavior>(attachedBehaviors.length);
                    for (int j = 0; j < attachedEventBehaviors.length; ++j) {
                        eventBehaviors.add((ClientBehavior)UIComponentBase.restoreAttachedState(context, attachedEventBehaviors[j]));
                    }
                    modifiableMap.put(names[i], eventBehaviors);
                }
                return new BehaviorsMap(modifiableMap);
            }
            int len = names.length;
            for (int i = 0; i < len; ++i) {
                List existingBehaviors = (List)this.behaviors.get(names[i]);
                this.restoreBehaviors(context, existingBehaviors, (Object[])attachedBehaviors[i]);
            }
            return this.behaviors;
        }
        return null;
    }

    private Object saveBehavior(FacesContext ctx, ClientBehavior behavior) {
        return behavior instanceof StateHolder ? ((StateHolder)((Object)behavior)).saveState(ctx) : null;
    }

    private void restoreBehaviors(FacesContext ctx, List<ClientBehavior> existingBehaviors, Object[] state) {
        int len = state.length;
        for (int i = 0; i < len; ++i) {
            ClientBehavior behavior = existingBehaviors.get(i);
            if (state[i] == null || !(behavior instanceof StateHolder)) continue;
            ((StateHolder)((Object)behavior)).restoreState(ctx, state[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void publishAfterViewEvents(FacesContext context, Application application, UIComponent component) {
        component.setInView(true);
        try {
            ArrayList<UIComponent> clist;
            component.pushComponentToEL(context, component);
            application.publishEvent(context, PostAddToViewEvent.class, component);
            if (component.getChildCount() > 0) {
                clist = new ArrayList<UIComponent>(component.getChildren());
                for (UIComponent c : clist) {
                    UIComponentBase.publishAfterViewEvents(context, application, c);
                }
            }
            if (component.getFacetCount() > 0) {
                clist = new ArrayList<UIComponent>(component.getFacets().values());
                for (UIComponent c : clist) {
                    UIComponentBase.publishAfterViewEvents(context, application, c);
                }
            }
        }
        finally {
            component.popComponentFromEL(context);
        }
    }

    private static void disconnectFromView(FacesContext context, Application application, UIComponent component) {
        application.publishEvent(context, PreRemoveFromViewEvent.class, component);
        component.setInView(false);
        component.compositeParent = null;
        if (component.getChildCount() > 0) {
            List<UIComponent> children = component.getChildren();
            for (UIComponent c : children) {
                UIComponentBase.disconnectFromView(context, application, c);
            }
        }
        if (component.getFacetCount() > 0) {
            Map<String, UIComponent> facets = component.getFacets();
            for (UIComponent c : facets.values()) {
                UIComponentBase.disconnectFromView(context, application, c);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributesMap
    implements Map<String, Object>,
    Serializable {
        private static final String ATTRIBUTES_THAT_ARE_SET_KEY = UIComponentBase.class.getName() + ".attributesThatAreSet";
        private transient Map<String, PropertyDescriptor> pdMap;
        private transient UIComponent component;
        private static final long serialVersionUID = -6773035086539772945L;

        private AttributesMap(UIComponent component) {
            this.component = component;
            this.pdMap = ((UIComponentBase)component).getDescriptorMap();
        }

        @Override
        public boolean containsKey(Object keyObj) {
            if (ATTRIBUTES_THAT_ARE_SET_KEY.equals(keyObj)) {
                return true;
            }
            String key = (String)keyObj;
            PropertyDescriptor pd = this.getPropertyDescriptor(key);
            if (pd == null) {
                Map attributes = (Map)this.component.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeys.attributes));
                if (attributes != null) {
                    return attributes.containsKey(key);
                }
                return false;
            }
            return false;
        }

        @Override
        public Object get(Object keyObj) {
            ValueExpression ve;
            String key = (String)keyObj;
            Object result = null;
            if (key == null) {
                throw new NullPointerException();
            }
            if (ATTRIBUTES_THAT_ARE_SET_KEY.equals(key)) {
                result = this.component.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet));
            }
            Map attributes = (Map)this.component.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeys.attributes));
            if (null == result) {
                PropertyDescriptor pd = this.getPropertyDescriptor(key);
                if (pd != null) {
                    try {
                        Method readMethod = pd.getReadMethod();
                        if (readMethod == null) {
                            throw new IllegalArgumentException(key);
                        }
                        result = readMethod.invoke((Object)this.component, EMPTY_OBJECT_ARRAY);
                    }
                    catch (IllegalAccessException e) {
                        throw new FacesException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new FacesException(e.getTargetException());
                    }
                } else if (attributes != null && attributes.containsKey(key)) {
                    result = attributes.get(key);
                }
            }
            if (null == result && (ve = this.component.getValueExpression(key)) != null) {
                try {
                    result = ve.getValue(this.component.getFacesContext().getELContext());
                }
                catch (ELException e) {
                    throw new FacesException(e);
                }
            }
            return result;
        }

        @Override
        public Object put(String keyValue, Object value) {
            if (keyValue == null) {
                throw new NullPointerException();
            }
            if (ATTRIBUTES_THAT_ARE_SET_KEY.equals(keyValue)) {
                if (this.component.attributesThatAreSet == null && value instanceof List) {
                    this.component.getStateHelper().put((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet), value);
                }
                return null;
            }
            PropertyDescriptor pd = this.getPropertyDescriptor(keyValue);
            if (pd != null) {
                try {
                    Method writeMethod;
                    Object result = null;
                    Method readMethod = pd.getReadMethod();
                    if (readMethod != null) {
                        result = readMethod.invoke((Object)this.component, EMPTY_OBJECT_ARRAY);
                    }
                    if ((writeMethod = pd.getWriteMethod()) == null) {
                        throw new IllegalArgumentException("Setter not found for property " + keyValue);
                    }
                    writeMethod.invoke((Object)this.component, value);
                    return result;
                }
                catch (IllegalAccessException e) {
                    throw new FacesException(e);
                }
                catch (InvocationTargetException e) {
                    throw new FacesException(e.getTargetException());
                }
            }
            if (value == null) {
                throw new NullPointerException();
            }
            List sProperties = (List)this.component.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet));
            if (sProperties == null) {
                this.component.getStateHelper().add((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet), keyValue);
            } else if (!sProperties.contains(keyValue)) {
                this.component.getStateHelper().add((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet), keyValue);
            }
            return this.putAttribute(keyValue, value);
        }

        @Override
        public void putAll(Map<? extends String, ?> map) {
            if (map == null) {
                throw new NullPointerException();
            }
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object remove(Object keyObj) {
            String key = (String)keyObj;
            if (key == null) {
                throw new NullPointerException();
            }
            if (ATTRIBUTES_THAT_ARE_SET_KEY.equals(key)) {
                return null;
            }
            PropertyDescriptor pd = this.getPropertyDescriptor(key);
            if (pd != null) {
                throw new IllegalArgumentException(key);
            }
            Map<String, Object> attributes = this.getAttributes();
            if (attributes != null) {
                this.component.getStateHelper().remove((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet), key);
                return this.component.getStateHelper().remove((Serializable)((Object)UIComponent.PropertyKeys.attributes), key);
            }
            return null;
        }

        @Override
        public int size() {
            Map<String, Object> attributes = this.getAttributes();
            return attributes != null ? attributes.size() : 0;
        }

        @Override
        public boolean isEmpty() {
            Map<String, Object> attributes = this.getAttributes();
            return attributes == null || attributes.isEmpty();
        }

        @Override
        public boolean containsValue(Object value) {
            Map<String, Object> attributes = this.getAttributes();
            return attributes != null && attributes.containsValue(value);
        }

        @Override
        public void clear() {
            this.component.getStateHelper().remove((Serializable)((Object)UIComponent.PropertyKeys.attributes));
            this.component.getStateHelper().remove((Serializable)((Object)UIComponent.PropertyKeysPrivate.attributesThatAreSet));
        }

        @Override
        public Set<String> keySet() {
            Map<String, Object> attributes = this.getAttributes();
            if (attributes != null) {
                return Collections.unmodifiableSet(attributes.keySet());
            }
            return Collections.emptySet();
        }

        @Override
        public Collection<Object> values() {
            Map<String, Object> attributes = this.getAttributes();
            if (attributes != null) {
                return Collections.unmodifiableCollection(attributes.values());
            }
            return Collections.emptyList();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            Map<String, Object> attributes = this.getAttributes();
            if (attributes != null) {
                return Collections.unmodifiableSet(attributes.entrySet());
            }
            return Collections.emptySet();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map)) {
                return false;
            }
            Map t = (Map)o;
            if (t.size() != this.size()) {
                return false;
            }
            try {
                Iterator<Map.Entry<String, Object>> i$ = this.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry<String, Object> e;
                    Map.Entry<String, Object> entry = e = i$.next();
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (!(value == null ? t.get(key) != null || !t.containsKey(key) : !value.equals(t.get(key)))) continue;
                    return false;
                }
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry<String, Object> o : this.entrySet()) {
                h += ((Object)o).hashCode();
            }
            return h;
        }

        private Map<String, Object> getAttributes() {
            return (Map)this.component.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeys.attributes));
        }

        private Object putAttribute(String key, Object value) {
            return this.component.getStateHelper().put((Serializable)((Object)UIComponent.PropertyKeys.attributes), key, value);
        }

        PropertyDescriptor getPropertyDescriptor(String name) {
            if (this.pdMap != null) {
                return this.pdMap.get(name);
            }
            return null;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.component.getClass());
            out.writeObject(this.component.saveState(FacesContext.getCurrentInstance()));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            Class clazz = (Class)in.readObject();
            try {
                this.component = (UIComponent)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.component.restoreState(FacesContext.getCurrentInstance(), in.readObject());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BehaviorsMap
    extends AbstractMap<String, List<ClientBehavior>> {
        private Map<String, List<ClientBehavior>> unmodifiableMap;
        private Map<String, List<ClientBehavior>> modifiableMap;

        private BehaviorsMap(Map<String, List<ClientBehavior>> modifiableMap) {
            this.modifiableMap = modifiableMap;
            this.unmodifiableMap = Collections.unmodifiableMap(modifiableMap);
        }

        @Override
        public Set<Map.Entry<String, List<ClientBehavior>>> entrySet() {
            return this.unmodifiableMap.entrySet();
        }

        private Map<String, List<ClientBehavior>> getModifiableMap() {
            return this.modifiableMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildrenList
    extends ArrayList<UIComponent> {
        private UIComponent component;

        public ChildrenList(UIComponent component) {
            super(6);
            this.component = component;
        }

        @Override
        public void add(int index, UIComponent element) {
            if (element == null) {
                throw new NullPointerException();
            }
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            UIComponentBase.eraseParent(element);
            super.add(index, element);
            element.setParent(this.component);
        }

        @Override
        public boolean add(UIComponent element) {
            if (element == null) {
                throw new NullPointerException();
            }
            UIComponentBase.eraseParent(element);
            boolean result = super.add(element);
            element.setParent(this.component);
            return result;
        }

        @Override
        public boolean addAll(Collection<? extends UIComponent> collection) {
            Iterator<? extends UIComponent> elements = new ArrayList<UIComponent>(collection).iterator();
            boolean changed = false;
            while (elements.hasNext()) {
                UIComponent element = elements.next();
                if (element == null) {
                    throw new NullPointerException();
                }
                this.add(element);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean addAll(int index, Collection<? extends UIComponent> collection) {
            Iterator<? extends UIComponent> elements = new ArrayList<UIComponent>(collection).iterator();
            boolean changed = false;
            while (elements.hasNext()) {
                UIComponent element = elements.next();
                if (element == null) {
                    throw new NullPointerException();
                }
                this.add(index++, element);
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            int n = this.size();
            if (n < 1) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                UIComponent child = (UIComponent)this.get(i);
                child.setParent(null);
            }
            super.clear();
        }

        @Override
        public Iterator<UIComponent> iterator() {
            return new ChildrenListIterator(this);
        }

        @Override
        public ListIterator<UIComponent> listIterator() {
            return new ChildrenListIterator(this);
        }

        @Override
        public ListIterator<UIComponent> listIterator(int index) {
            return new ChildrenListIterator(this, index);
        }

        @Override
        public UIComponent remove(int index) {
            UIComponent child = (UIComponent)this.get(index);
            super.remove(index);
            child.setParent(null);
            return child;
        }

        @Override
        public boolean remove(Object elementObj) {
            UIComponent element = (UIComponent)elementObj;
            if (element == null) {
                throw new NullPointerException();
            }
            if (super.remove(element)) {
                element.setParent(null);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean result = false;
            for (Object elements : collection) {
                if (!this.remove(elements)) continue;
                result = true;
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            Iterator<UIComponent> items = this.iterator();
            while (items.hasNext()) {
                if (collection.contains(items.next())) continue;
                items.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public UIComponent set(int index, UIComponent element) {
            if (element == null) {
                throw new NullPointerException();
            }
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            UIComponentBase.eraseParent(element);
            UIComponent previous = (UIComponent)this.get(index);
            super.set(index, element);
            previous.setParent(null);
            element.setParent(this.component);
            return previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildrenListIterator
    implements ListIterator<UIComponent> {
        private ChildrenList list;
        private int index;
        private int last = -1;

        public ChildrenListIterator(ChildrenList list) {
            this.list = list;
            this.index = 0;
        }

        public ChildrenListIterator(ChildrenList list, int index) {
            this.list = list;
            if (index < 0 || index > list.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.size();
        }

        @Override
        public UIComponent next() {
            try {
                UIComponent o = (UIComponent)this.list.get(this.index);
                this.last = this.index++;
                return o;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            this.list.remove(this.last);
            if (this.last < this.index) {
                --this.index;
            }
            this.last = -1;
        }

        @Override
        public void add(UIComponent o) {
            this.last = -1;
            this.list.add(this.index++, o);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 1;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public UIComponent previous() {
            try {
                int current = this.index - 1;
                UIComponent o = (UIComponent)this.list.get(current);
                this.last = current;
                this.index = current;
                return o;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void set(UIComponent o) {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            this.list.set(this.last, o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FacetsAndChildrenIterator
    implements Iterator<UIComponent> {
        private Iterator<UIComponent> iterator;
        private boolean childMode;
        private UIComponent c;

        public FacetsAndChildrenIterator(UIComponent c) {
            this.c = c;
            this.childMode = false;
        }

        private void update() {
            if (this.iterator == null) {
                if (this.c.getFacetCount() != 0) {
                    this.iterator = this.c.getFacets().values().iterator();
                    this.childMode = false;
                } else if (this.c.getChildCount() != 0) {
                    this.iterator = this.c.getChildren().iterator();
                    this.childMode = true;
                } else {
                    this.iterator = EMPTY_ITERATOR;
                    this.childMode = true;
                }
            } else if (!this.childMode && !this.iterator.hasNext() && this.c.getChildCount() != 0) {
                this.iterator = this.c.getChildren().iterator();
                this.childMode = true;
            }
        }

        @Override
        public boolean hasNext() {
            this.update();
            return this.iterator.hasNext();
        }

        @Override
        public UIComponent next() {
            this.update();
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMap
    extends HashMap<String, UIComponent> {
        private UIComponent component;

        public FacetsMap(UIComponent component) {
            super(3, 1.0f);
            this.component = component;
        }

        @Override
        public void clear() {
            Iterator<String> keys = this.keySet().iterator();
            while (keys.hasNext()) {
                keys.next();
                keys.remove();
            }
            super.clear();
        }

        @Override
        public Set<Map.Entry<String, UIComponent>> entrySet() {
            return new FacetsMapEntrySet(this);
        }

        @Override
        public Set<String> keySet() {
            return new FacetsMapKeySet(this);
        }

        @Override
        public UIComponent put(String key, UIComponent value) {
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            if (!(key instanceof String) || !(value instanceof UIComponent)) {
                throw new ClassCastException();
            }
            UIComponent previous = (UIComponent)super.get(key);
            if (previous != null) {
                previous.setParent(null);
            }
            UIComponentBase.eraseParent(value);
            UIComponent result = super.put(key, value);
            value.setParent(this.component);
            return result;
        }

        @Override
        public void putAll(Map<? extends String, ? extends UIComponent> map) {
            if (map == null) {
                throw new NullPointerException();
            }
            for (Map.Entry<? extends String, ? extends UIComponent> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public UIComponent remove(Object key) {
            UIComponent previous = (UIComponent)this.get(key);
            if (previous != null) {
                previous.setParent(null);
            }
            super.remove(key);
            return previous;
        }

        @Override
        public Collection<UIComponent> values() {
            return new FacetsMapValues(this);
        }

        Iterator<String> keySetIterator() {
            return new ArrayList(super.keySet()).iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapEntrySet
    extends AbstractSet<Map.Entry<String, UIComponent>> {
        private FacetsMap map = null;

        public FacetsMapEntrySet(FacetsMap map) {
            this.map = map;
        }

        @Override
        public boolean add(Map.Entry<String, UIComponent> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, UIComponent>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            if (!this.map.containsKey(k)) {
                return false;
            }
            if (v == null) {
                return this.map.get(k) == null;
            }
            return v.equals(this.map.get(k));
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<String, UIComponent>> iterator() {
            return new FacetsMapEntrySetIterator(this.map);
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object k = ((Map.Entry)o).getKey();
            if (this.map.containsKey(k)) {
                this.map.remove(k);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection c) {
            boolean result = false;
            for (Object element : c) {
                if (!this.remove(element)) continue;
                result = true;
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection c) {
            boolean result = false;
            Iterator<Map.Entry<String, UIComponent>> v = this.iterator();
            while (v.hasNext()) {
                if (c.contains(v.next())) continue;
                v.remove();
                result = true;
            }
            return result;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapEntrySetEntry
    implements Map.Entry<String, UIComponent> {
        private FacetsMap map;
        private String key;

        public FacetsMapEntrySetEntry(FacetsMap map, String key) {
            this.map = map;
            this.key = key;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (this.key == null ? e.getKey() != null : !this.key.equals(e.getKey())) {
                return false;
            }
            UIComponent v = (UIComponent)this.map.get(this.key);
            return !(v == null ? e.getValue() != null : !v.equals(e.getValue()));
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public UIComponent getValue() {
            return (UIComponent)this.map.get(this.key);
        }

        @Override
        public int hashCode() {
            Object value = this.map.get(this.key);
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        @Override
        public UIComponent setValue(UIComponent value) {
            UIComponent previous = (UIComponent)this.map.get(this.key);
            this.map.put(this.key, value);
            return previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapEntrySetIterator
    implements Iterator<Map.Entry<String, UIComponent>> {
        private FacetsMap map = null;
        private Iterator<String> iterator = null;
        private Map.Entry<String, UIComponent> last = null;

        public FacetsMapEntrySetIterator(FacetsMap map) {
            this.map = map;
            this.iterator = map.keySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<String, UIComponent> next() {
            this.last = new FacetsMapEntrySetEntry(this.map, this.iterator.next());
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last.getKey());
            this.last = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapKeySet
    extends AbstractSet<String> {
        private FacetsMap map = null;

        public FacetsMapKeySet(FacetsMap map) {
            this.map = map;
        }

        @Override
        public boolean add(String o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            for (Object item : c) {
                if (this.map.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<String> iterator() {
            return new FacetsMapKeySetIterator(this.map);
        }

        @Override
        public boolean remove(Object o) {
            if (this.map.containsKey(o)) {
                this.map.remove(o);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection c) {
            boolean result = false;
            for (Object item : c) {
                if (!this.map.containsKey(item)) continue;
                this.map.remove(item);
                result = true;
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection c) {
            boolean result = false;
            Iterator<String> v = this.iterator();
            while (v.hasNext()) {
                if (c.contains(v.next())) continue;
                v.remove();
                result = true;
            }
            return result;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapKeySetIterator
    implements Iterator<String> {
        private FacetsMap map = null;
        private Iterator<String> iterator = null;
        private String last = null;

        public FacetsMapKeySetIterator(FacetsMap map) {
            this.map = map;
            this.iterator = map.keySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            this.last = this.iterator.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last);
            this.last = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapValues
    extends AbstractCollection<UIComponent> {
        private FacetsMap map;

        public FacetsMapValues(FacetsMap map) {
            this.map = map;
        }

        @Override
        public boolean add(UIComponent o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<UIComponent> iterator() {
            return new FacetsMapValuesIterator(this.map);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapValuesIterator
    implements Iterator<UIComponent> {
        private FacetsMap map = null;
        private Iterator<String> iterator = null;
        private Object last = null;

        public FacetsMapValuesIterator(FacetsMap map) {
            this.map = map;
            this.iterator = map.keySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public UIComponent next() {
            this.last = this.iterator.next();
            return (UIComponent)this.map.get(this.last);
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last);
            this.last = null;
        }
    }
}

