/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.util.Map;
import java.util.Set;
import org.glassfish.api.admin.CommandException;

public abstract class LocalServerCommand
extends CLICommand {
    private ServerDirs serverDirs;
    private static final LocalStringsImpl strings = new LocalStringsImpl(LocalDomainCommand.class);

    protected boolean checkForSpecialFiles() {
        return true;
    }

    protected final int getAdminPort() throws CommandException {
        return this.getAdminPort("server");
    }

    protected final int getAdminPort(String serverName) throws CommandException {
        try {
            MiniXmlParser parser = new MiniXmlParser(this.getDomainXml(), serverName);
            Set portsSet = parser.getAdminPorts();
            if (portsSet.size() > 0) {
                return (Integer)portsSet.iterator().next();
            }
            throw new CommandException("admin port not found");
        }
        catch (MiniXmlParserException ex) {
            throw new CommandException("admin port not found", (Throwable)ex);
        }
    }

    protected final void setServerDirs(ServerDirs sd) {
        this.serverDirs = sd;
    }

    protected final void resetServerDirs() throws IOException {
        this.serverDirs = this.serverDirs.refresh();
    }

    protected final ServerDirs getServerDirs() {
        return this.serverDirs;
    }

    protected final File getDomainXml() {
        return this.serverDirs.getDomainXml();
    }

    protected final String readFromMasterPasswordFile() {
        File mpf = this.getMasterPasswordFile();
        if (mpf == null) {
            return null;
        }
        try {
            PasswordAdapter pw = new PasswordAdapter(mpf.getAbsolutePath(), "master-password".toCharArray());
            return pw.getPasswordForAlias("master-password");
        }
        catch (Exception e) {
            logger.printDebugMessage("master password file reading error: " + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean verifyMasterPassword(String mpv) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.getJKS());
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(fis, mpv.toCharArray());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.printDebugMessage(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    protected final String getMasterPassword() throws CommandException {
        int RETRIES = 3;
        long t0 = System.currentTimeMillis();
        String mpv = (String)this.passwords.get("AS_ADMIN_MASTERPASSWORD");
        if (mpv == null) {
            mpv = "changeit";
            if (!this.verifyMasterPassword(mpv) && !this.verifyMasterPassword(mpv = this.readFromMasterPasswordFile())) {
                mpv = this.retry(3);
            }
        } else if (!this.verifyMasterPassword(mpv)) {
            mpv = this.retry(3);
        }
        long t1 = System.currentTimeMillis();
        logger.printDebugMessage("Time spent in master password extraction: " + (t1 - t0) + " msec");
        return mpv;
    }

    protected final boolean isThisServer(File ourDir, String directoryKey) {
        if (!LocalServerCommand.ok(directoryKey)) {
            throw new NullPointerException();
        }
        ourDir = this.getUniquePath(ourDir);
        logger.printDebugMessage("Check if server is at location " + ourDir);
        try {
            RemoteCommand cmd = new RemoteCommand("__locations", this.programOpts, this.env);
            Map<String, String> attrs = cmd.executeAndReturnAttributes("__locations");
            String theirDirPath = attrs.get(directoryKey);
            logger.printDebugMessage("Remote server has root directory " + theirDirPath);
            if (LocalServerCommand.ok(theirDirPath)) {
                File theirDir = this.getUniquePath(new File(theirDirPath));
                return theirDir.equals(ourDir);
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isRunning(String host, int port) {
        Socket server = null;
        try {
            server = new Socket(host, port);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.printDebugMessage("\nisRunning got exception: " + ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    protected final boolean isRunning(int port) {
        return this.isRunning(null, port);
    }

    protected final boolean isRunning() {
        File pf = this.getServerDirs().getPidFile();
        if (pf != null) {
            return pf.exists();
        }
        return this.isRunning(this.programOpts.getHost(), this.programOpts.getPort());
    }

    private final File getJKS() {
        if (this.serverDirs == null) {
            return null;
        }
        File mp = new File(new File(this.serverDirs.getServerDir(), "config"), "keystore.jks");
        if (!mp.canRead()) {
            return null;
        }
        return mp;
    }

    private File getMasterPasswordFile() {
        if (this.serverDirs == null) {
            return null;
        }
        File mp = new File(this.serverDirs.getServerDir(), "master-password");
        if (!mp.canRead()) {
            return null;
        }
        return mp;
    }

    private String retry(int times) throws CommandException {
        for (int i = 0; i < times; ++i) {
            String prompt = strings.get("mp.prompt", new Object[]{times - i});
            String mpv = super.readPassword(prompt);
            if (mpv == null) {
                throw new CommandException(strings.get("no.console"));
            }
            if (this.verifyMasterPassword(mpv)) {
                return mpv;
            }
            if (i >= times - 1) continue;
            logger.printMessage(strings.get("retry.mp"));
        }
        throw new CommandException(strings.get("mp.giveup", new Object[]{times}));
    }

    private File getUniquePath(File f) {
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException ioex) {
            f = SmartFile.sanitize((File)f);
        }
        return f;
    }
}

