/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.enterprise.admin.cli.CLILogger;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.ExceptionAnalyzer;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import java.io.IOException;
import java.net.ConnectException;
import org.glassfish.api.admin.AuthenticationException;
import org.glassfish.api.admin.CommandException;

public class DASUtils {
    private DASUtils() {
    }

    public static boolean pingDASQuietly(ProgramOptions programOpts, Environment env) {
        try {
            RemoteCommand cmd = new RemoteCommand("version", programOpts, env);
            cmd.executeAndReturnOutput("version");
            return true;
        }
        catch (AuthenticationException aex) {
            return true;
        }
        catch (Exception ex) {
            ExceptionAnalyzer ea = new ExceptionAnalyzer(ex);
            if (ea.getFirstInstanceOf(ConnectException.class) != null) {
                CLILogger.getInstance().printDebugMessage("Got java.net.ConnectException");
                return false;
            }
            if (ea.getFirstInstanceOf(IOException.class) != null) {
                CLILogger.getInstance().printDebugMessage("It appears that server has started, but for some reason the exception is thrown: " + ex.getMessage());
                return true;
            }
            return false;
        }
    }

    public static Error pingDASWithAuth(ProgramOptions programOpts, Environment env) throws CommandException {
        try {
            RemoteCommand cmd = new RemoteCommand("version", programOpts, env);
            cmd.executeAndReturnOutput("version");
        }
        catch (AuthenticationException aex) {
            return Error.AUTHENTICATION;
        }
        catch (Exception ex) {
            ExceptionAnalyzer ea = new ExceptionAnalyzer(ex);
            if (ea.getFirstInstanceOf(ConnectException.class) != null) {
                CLILogger.getInstance().printDebugMessage("Got java.net.ConnectException");
                return Error.CONNECTION;
            }
            if (ea.getFirstInstanceOf(IOException.class) != null) {
                CLILogger.getInstance().printDebugMessage("It appears that server has started, but for some reason the exception is thrown: " + ex.getMessage());
                return Error.IO;
            }
            return Error.UNKNOWN;
        }
        return Error.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Error {
        NONE,
        AUTHENTICATION,
        CONNECTION,
        IO,
        UNKNOWN;

    }
}

