/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jacc.provider;

import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.security.jacc.provider.JACCRoleMapper;
import java.security.Principal;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.internal.api.Globals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassfishRoleMapper
implements JACCRoleMapper {
    private static final Logger defaultLogger = Logger.getLogger(GlassfishRoleMapper.class.getName());
    private final Logger logger;

    public GlassfishRoleMapper(Logger logger) {
        this.logger = logger == null ? defaultLogger : logger;
    }

    private SecurityRoleMapper getInternalMapper(String pcid) {
        SecurityRoleMapperFactory factory = (SecurityRoleMapperFactory)Globals.get(SecurityRoleMapperFactory.class);
        if (factory == null) {
            String msg = "RoleMapper.factory.lookup.failed";
            this.logger.log(Level.SEVERE, msg);
            throw new SecurityException(msg);
        }
        SecurityRoleMapper srm = factory.getRoleMapper(pcid);
        if (srm == null) {
            String msg = "RoleMapper.mapper.lookup.failed";
            this.logger.log(Level.SEVERE, msg);
            throw new SecurityException(msg);
        }
        return srm;
    }

    private Set<String> getDeclaredRoles(SecurityRoleMapper srm) {
        String msg = "RoleMapper.unable.to.get.roles";
        this.logger.log(Level.SEVERE, msg);
        throw new UnsupportedOperationException(msg);
    }

    private Set<Principal> getPrincipalsInRole(SecurityRoleMapper srm, String roleName) throws SecurityException, UnsupportedOperationException {
        Map roleMap = srm.getRoleToSubjectMapping();
        if (roleMap == null) {
            return null;
        }
        Subject s = (Subject)roleMap.get(roleName);
        if (s == null) {
            return null;
        }
        return s.getPrincipals();
    }

    public boolean arePrincipalsInRole(SecurityRoleMapper srm, Principal[] principals, String roleName) throws SecurityException {
        if (principals == null || principals.length == 0) {
            return false;
        }
        Set<Principal> rolePrincipals = this.getPrincipalsInRole(srm, roleName);
        if (rolePrincipals == null || rolePrincipals.isEmpty()) {
            return false;
        }
        for (Principal p : principals) {
            if (!rolePrincipals.contains(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getDeclaredRoles(String pcid) {
        return this.getDeclaredRoles(this.getInternalMapper(pcid));
    }

    @Override
    public boolean isSubjectInRole(String pcid, Subject s, String roleName) throws SecurityException {
        return this.arePrincipalsInRole(pcid, this.toArray(s.getPrincipals()), roleName);
    }

    @Override
    public boolean arePrincipalsInRole(String pcid, Principal[] principals, String roleName) throws SecurityException {
        return this.arePrincipalsInRole(this.getInternalMapper(pcid), principals, roleName);
    }

    @Override
    public Set<String> getRolesOfSubject(String pcid, Subject s) throws SecurityException, UnsupportedOperationException {
        return this.getRolesOfPrincipals(pcid, this.toArray(s.getPrincipals()));
    }

    @Override
    public Set<String> getRolesOfPrincipals(String pcid, Principal[] principals) throws SecurityException, UnsupportedOperationException {
        if (principals == null || principals.length == 0) {
            return null;
        }
        SecurityRoleMapper srm = this.getInternalMapper(pcid);
        Set<String> roleNames = this.getDeclaredRoles(srm);
        if (roleNames == null) {
            return null;
        }
        HashSet<String> roles = new HashSet<String>();
        block0: for (String roleName : roleNames) {
            Set<Principal> pSet = this.getPrincipalsInRole(srm, roleName);
            if (pSet == null) continue;
            for (Principal p : principals) {
                if (!pSet.contains(p)) continue;
                roles.add(roleName);
                continue block0;
            }
        }
        return roles;
    }

    @Override
    public BitSet getRolesOfSubject(String pcid, String[] roles, Subject s) throws SecurityException, UnsupportedOperationException {
        return this.getRolesOfPrincipals(pcid, roles, this.toArray(s.getPrincipals()));
    }

    private Principal[] toArray(Set principals) {
        Principal[] list = new Principal[principals.size()];
        int i = 0;
        for (Object obj : principals) {
            if (!(obj instanceof Principal)) continue;
            list[i] = (Principal)obj;
        }
        return list;
    }

    @Override
    public BitSet getRolesOfPrincipals(String pcid, String[] roles, Principal[] principals) throws SecurityException, UnsupportedOperationException {
        BitSet roleSet = new BitSet(roles.length);
        if (principals == null || principals.length == 0 || roles == null || roles.length == 0) {
            return null;
        }
        SecurityRoleMapper srm = this.getInternalMapper(pcid);
        for (int i = 0; i < roles.length; ++i) {
            roleSet.set(i, this.arePrincipalsInRole(srm, principals, roles[i]));
        }
        return roleSet;
    }

    @Override
    public Set<Principal> getPrincipalsInRole(String pcid, String roleName) throws SecurityException, UnsupportedOperationException {
        return this.getPrincipalsInRole(this.getInternalMapper(pcid), roleName);
    }
}

