/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQDirectService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;

public class IMQDirectServiceFactory
extends ServiceFactory {
    private static boolean DEBUG = false;
    private static final Logger logger = Globals.getLogger();
    public static final String SERVICE_PREFIX = "imq.";
    private BrokerConfig props = Globals.getConfig();

    public void updateService(Service service) throws BrokerException {
        IMQService iMQService = (IMQService)service;
        String string = service.getName();
        Globals.getPortMapper().addService(string, "none", Globals.getConfig().getProperty(SERVICE_PREFIX + string + ".servicetype"), 0, iMQService.getServiceProperties());
    }

    public void startMonitoringService(Service service) throws BrokerException {
    }

    public void stopMonitoringService(Service service) throws BrokerException {
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
    }

    public boolean update(String string, String string2) {
        return true;
    }

    public Service createService(String string, int n) throws BrokerException {
        try {
            IMQDirectService iMQDirectService = new IMQDirectService(string, n, this.getThreadMin(string), this.getThreadMax(string), this.getAccessControl(string));
            return iMQDirectService;
        }
        catch (Exception exception) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3009", string), exception);
        }
    }

    private int getThreadMin(String string) {
        String string2 = SERVICE_PREFIX + string + ".min_threads";
        return this.props.getIntProperty(string2);
    }

    private int getThreadMax(String string) {
        String string2 = SERVICE_PREFIX + string + ".max_threads";
        return this.props.getIntProperty(string2);
    }

    private boolean getAccessControl(String string) {
        String string2 = SERVICE_PREFIX + string + ".accesscontrol.enabled";
        return this.props.getBooleanProperty(string2, false);
    }
}

