/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.util;

import com.sun.messaging.jmq.io.MetricCounters;
import com.sun.messaging.jmq.io.MetricData;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TimerTask;
import java.util.Vector;

public class MetricManager
implements ConfigListener {
    private Hashtable deadTotalsByService = new Hashtable();
    private MetricTask task = null;
    private long lastSampleTime = 0L;
    private MetricCounters lastSample;
    private static String INTERVAL_PROPERTY = "imq.metrics.interval";
    private static String ENABLED_PROPERTY = "imq.metrics.enabled";
    private BrokerResources rb = Globals.getBrokerResources();
    private MQTimer timer = Globals.getTimer();
    private Logger logger = Globals.getLogger();

    public static boolean isEnabled() {
        return Globals.getConfig().getBooleanProperty(ENABLED_PROPERTY);
    }

    public MetricManager() {
        this.lastSample = new MetricCounters();
    }

    public synchronized void depositTotals(String string, MetricCounters metricCounters) {
        MetricCounters metricCounters2 = (MetricCounters)this.deadTotalsByService.get(string);
        if (metricCounters2 == null) {
            metricCounters2 = new MetricCounters();
            this.deadTotalsByService.put(string, metricCounters2);
        }
        metricCounters2.update(metricCounters);
    }

    public synchronized void reset() {
        this.deadTotalsByService.clear();
        this.lastSample = new MetricCounters();
    }

    public synchronized void setInterval(long l) {
        if (l > 0L && MetricManager.isEnabled()) {
            if (this.task != null) {
                this.task.cancel();
            }
            this.task = new MetricTask();
            this.timer.schedule((TimerTask)this.task, l, l * 1000L);
        } else if (this.task != null) {
            this.task.cancel();
        }
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
        if (!string.equals(INTERVAL_PROPERTY)) {
            throw new PropertyUpdateException(this.rb.getString("B4028", string));
        }
        this.getLongProperty(string, string2);
    }

    public boolean update(String string, String string2) {
        if (string.equals(INTERVAL_PROPERTY)) {
            try {
                this.setInterval(this.getLongProperty(string, string2));
                return true;
            }
            catch (PropertyUpdateException propertyUpdateException) {
                // empty catch block
            }
        }
        return false;
    }

    public long getLongProperty(String string, String string2) throws PropertyUpdateException {
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PropertyUpdateException(this.rb.getString("B4027", string + "=" + string2));
        }
    }

    public void setParameters(Hashtable hashtable) {
        try {
            String string = (String)hashtable.get(INTERVAL_PROPERTY);
            this.validate(INTERVAL_PROPERTY, string);
            this.update(INTERVAL_PROPERTY, string);
        }
        catch (PropertyUpdateException propertyUpdateException) {
            this.logger.logStack(16, "B2063", propertyUpdateException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MetricCounters getMetricCounters(String string) {
        Object object;
        Iterator iterator;
        Object object2;
        Object object3;
        ConnectionManager connectionManager = Globals.getConnectionManager();
        MetricCounters metricCounters = new MetricCounters();
        if (string == null) {
            object3 = this.deadTotalsByService.elements();
            while (object3.hasMoreElements()) {
                metricCounters.update((MetricCounters)object3.nextElement());
            }
        } else {
            object3 = (MetricCounters)this.deadTotalsByService.get(string);
            if (object3 != null) {
                metricCounters.update((MetricCounters)this.deadTotalsByService.get(string));
            }
        }
        int n = 0;
        Object object4 = connectionManager;
        synchronized (object4) {
            object2 = connectionManager.values();
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Connection)iterator.next();
                Service service = ((Connection)object).getService();
                if (string != null && !string.equals(service.getName())) continue;
                if (object instanceof IMQConnection) {
                    metricCounters.update(((IMQConnection)object).getMetricCounters());
                }
                ++n;
            }
        }
        object4 = Globals.getServiceManager();
        object2 = null;
        iterator = null;
        if (string == null) {
            object = ((ServiceManager)object4).getAllActiveServices();
            if (object != null) {
                iterator = object.iterator();
            }
        } else {
            object = new Vector<String>(1);
            ((Vector)object).add(string);
            iterator = ((Vector)object).iterator();
        }
        while (iterator != null && iterator.hasNext()) {
            object2 = ((ServiceManager)object4).getService((String)iterator.next());
            if (!(object2 instanceof IMQService)) continue;
            metricCounters.threadsActive += ((IMQService)object2).getActiveThreadpool();
            metricCounters.threadsHighWater += ((IMQService)object2).getMaxThreadpool();
            metricCounters.threadsLowWater += ((IMQService)object2).getMinThreadpool();
        }
        object = Runtime.getRuntime();
        metricCounters.totalMemory = ((Runtime)object).totalMemory();
        metricCounters.freeMemory = ((Runtime)object).freeMemory();
        metricCounters.nConnections = n;
        metricCounters.timeStamp = System.currentTimeMillis();
        return metricCounters;
    }

    public synchronized MetricData getMetrics() {
        MetricData metricData = new MetricData();
        Runtime runtime = Runtime.getRuntime();
        long l = System.currentTimeMillis();
        float f = (float)(l - this.lastSampleTime) / 1000.0f;
        MetricCounters metricCounters = this.getMetricCounters(null);
        metricData.timestamp = l;
        metricData.totalMemory = runtime.totalMemory();
        metricData.freeMemory = runtime.freeMemory();
        metricData.nConnections = metricCounters.nConnections;
        metricData.setTotals(metricCounters);
        metricData.rates.messagesIn = (long)((float)(metricCounters.messagesIn - this.lastSample.messagesIn) / f);
        metricData.rates.messageBytesIn = (long)((float)(metricCounters.messageBytesIn - this.lastSample.messageBytesIn) / f);
        metricData.rates.packetsIn = (long)((float)(metricCounters.packetsIn - this.lastSample.packetsIn) / f);
        metricData.rates.packetBytesIn = (long)((float)(metricCounters.packetBytesIn - this.lastSample.packetBytesIn) / f);
        metricData.rates.messagesOut = (long)((float)(metricCounters.messagesOut - this.lastSample.messagesOut) / f);
        metricData.rates.messageBytesOut = (long)((float)(metricCounters.messageBytesOut - this.lastSample.messageBytesOut) / f);
        metricData.rates.packetsOut = (long)((float)(metricCounters.packetsOut - this.lastSample.packetsOut) / f);
        metricData.rates.packetBytesOut = (long)((float)(metricCounters.packetBytesOut - this.lastSample.packetBytesOut) / f);
        this.lastSampleTime = l;
        this.lastSample = metricCounters;
        return metricData;
    }

    public class MetricTask
    extends TimerTask {
        public void run() {
            MetricData metricData = MetricManager.this.getMetrics();
            MetricManager.this.logger.log(8, "\n" + metricData.toString());
        }
    }
}

