/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.client;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DFDeploymentStatus
implements Serializable {
    static final long serialVersionUID = -6130876961172599515L;
    private static final String NEWLINE = System.getProperty("line.separator");
    public static final String CONTEXT_ROOT = "ContextRoot";
    public static final String KEY_SEPARATOR = "_";
    public static final String MODULE_ID = "moduleid";
    public static final String MODULE_TYPE = "ModuleType";
    public static final String SUBMODULE_COUNT = "NumberOfSubModules";
    public static final String WSDL_PUBLISH_URL = "ClientPublishURL";
    public static final String WSDL_LOCATION = "WsdlFileLocation";
    public static final String WSDL_DIRECTORY = "WsdlDirectory";
    public static final String WSDL_FILE_ENTRIES = "WsdlFileEntries";
    public static final String COUNT = "NumberOfEntries";
    private String stageDescription;
    private Status stageStatus = Status.NOTINITIALIZED;
    private String stageStatusMessage = "";
    private Throwable stageException;
    private List<DFDeploymentStatus> subStages = new ArrayList<DFDeploymentStatus>();
    private DFDeploymentStatus parent = null;
    private Map additionalStatus = new Properties();
    private Properties props = null;

    public DFDeploymentStatus() {
    }

    public DFDeploymentStatus(DFDeploymentStatus parent) {
        if (parent == null) {
            throw new IllegalArgumentException("parent deployment status cannot be null");
        }
        parent.addSubStage(this);
    }

    public Status getStatus() {
        Status currentStatus = this.stageStatus;
        for (DFDeploymentStatus subStage : this.subStages) {
            Status subStageStatus = subStage.getStatus();
            if (!subStageStatus.isWorseThan(currentStatus)) continue;
            currentStatus = subStageStatus;
        }
        return currentStatus;
    }

    public void addSubStage(DFDeploymentStatus subStage) {
        this.subStages.add(subStage);
        subStage.setParent(this);
    }

    public Iterator getSubStages() {
        return this.subStages.iterator();
    }

    public void setStageStatus(Status status) {
        this.stageStatus = status;
    }

    public Status getStageStatus() {
        return this.stageStatus;
    }

    public Throwable getStageException() {
        return this.stageException;
    }

    public String getStageIdentifier() {
        return this.stageDescription;
    }

    public String getStageDescription() {
        return this.stageDescription;
    }

    public String getStageStatusMessage() {
        return this.stageStatusMessage;
    }

    public void setStageException(Throwable throwable) {
        if (throwable != null) {
            this.stageException = new Throwable(throwable.toString());
            this.stageException.setStackTrace(throwable.getStackTrace());
        } else {
            this.stageException = null;
        }
    }

    public void setStageDescription(String string) {
        this.stageDescription = string;
    }

    public void setStageStatusMessage(String string) {
        this.stageStatusMessage = string;
    }

    public DFDeploymentStatus getStageStatusForLevel(Status level) {
        if (this.stageStatus == level) {
            return this;
        }
        for (DFDeploymentStatus subStage : this.subStages) {
            if (subStage.getStatus() != level) continue;
            return subStage;
        }
        return null;
    }

    public DFDeploymentStatus getParent() {
        return this.parent;
    }

    public void setParent(DFDeploymentStatus parent) {
        this.parent = parent;
    }

    public DFDeploymentStatus getMainStatus() {
        if (this.parent != null) {
            return this.parent.getMainStatus();
        }
        Iterator subIter = this.getSubStages();
        if (subIter.hasNext()) {
            DFDeploymentStatus subStage = (DFDeploymentStatus)subIter.next();
            subStage.setStageStatus(this.getStageStatus());
            return subStage;
        }
        return this;
    }

    public void addProperty(String propertyName, String propertyValue) {
        this.additionalStatus.put(propertyName, propertyValue);
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.put(propertyName, propertyValue);
    }

    public String getProperty(String propertyName) {
        if (this.additionalStatus.get(propertyName) != null) {
            return (String)this.additionalStatus.get(propertyName);
        }
        if (this.props == null) {
            return null;
        }
        return this.props.getProperty(propertyName);
    }

    public Map getAdditionalStatus() {
        return this.additionalStatus;
    }

    public String getAllStageMessages() {
        StringBuilder sb = new StringBuilder();
        DFDeploymentStatus.getAllStageMessages(this, sb);
        return sb.toString();
    }

    public static void getAllStageMessages(DFDeploymentStatus status, StringBuilder sb) {
        sb.append(status.getStageStatusMessage());
        for (DFDeploymentStatus child : status.subStages) {
            sb.append(NEWLINE);
            DFDeploymentStatus.getAllStageMessages(child, sb);
        }
    }

    public void setAdditionalStatus(Map additionalStatus) {
        this.additionalStatus = additionalStatus;
    }

    public String toString() {
        return "Status " + (Object)((Object)this.stageStatus) + " message " + this.stageStatusMessage + " \nException " + this.stageException;
    }

    public static Iterator getAllStageStatusForLevel(DFDeploymentStatus status, Status level) {
        ArrayList<DFDeploymentStatus> stages = new ArrayList<DFDeploymentStatus>();
        if (status.getStageStatus() == level) {
            stages.add(status);
        }
        Iterator itr = status.getSubStages();
        while (itr.hasNext()) {
            DFDeploymentStatus subStage = (DFDeploymentStatus)itr.next();
            if (subStage.getStageStatus() == level) {
                stages.add(subStage);
            }
            Iterator itr2 = subStage.getSubStages();
            while (itr2.hasNext()) {
                DFDeploymentStatus subStage2 = (DFDeploymentStatus)itr2.next();
                if (subStage2.getStageStatus() == level) {
                    stages.add(subStage2);
                }
                Iterator itr3 = subStage2.getSubStages();
                while (itr3.hasNext()) {
                    DFDeploymentStatus subStage3 = (DFDeploymentStatus)itr3.next();
                    if (subStage3.getStageStatus() != level) continue;
                    stages.add(subStage3);
                }
            }
        }
        return stages.iterator();
    }

    public static void parseDeploymentStatus(DFDeploymentStatus status, PrintWriter pw) {
        if (status != null) {
            if (status.getStatus() == Status.FAILURE) {
                Iterator itr = DFDeploymentStatus.getAllStageStatusForLevel(status, Status.FAILURE);
                while (itr.hasNext()) {
                    DFDeploymentStatus stage = (DFDeploymentStatus)itr.next();
                    DFDeploymentStatus.printFailure(pw, stage);
                }
            } else if (status.getStatus() == Status.WARNING) {
                Iterator itr = DFDeploymentStatus.getAllStageStatusForLevel(status, Status.WARNING);
                while (itr.hasNext()) {
                    DFDeploymentStatus stage = (DFDeploymentStatus)itr.next();
                    String msg = stage.getStageStatusMessage();
                    if (msg == null) continue;
                    pw.println(msg);
                }
            }
            pw.flush();
        }
    }

    private static void printFailure(PrintWriter pw, DFDeploymentStatus status) {
        String msg = status.getStageStatusMessage();
        Throwable t = status.getStageException();
        if (msg != null && msg.trim().length() > 0) {
            pw.println(msg);
            if (t != null && t.getMessage() != null && !t.getMessage().equals(msg)) {
                pw.println(t.toString());
            }
        } else if (t != null) {
            pw.println(t.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        FAILURE,
        WARNING,
        SUCCESS,
        NOTINITIALIZED;


        public boolean isWorseThan(Status other) {
            return this.compareTo(other) < 0;
        }
    }
}

