/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.conversation;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.Conversation;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.weld.Container;
import org.jboss.weld.context.BusyConversationException;
import org.jboss.weld.context.ContextLifecycle;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.NonexistentConversationException;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.conversation.ConversationConcurrentAccessTimeout;
import org.jboss.weld.conversation.ConversationEntry;
import org.jboss.weld.conversation.ConversationImpl;
import org.jboss.weld.conversation.ConversationManager;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ConversationMessage;
import org.jboss.weld.resources.spi.ScheduledExecutorServiceFactory;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConversationManager
implements ConversationManager,
Serializable {
    private static final long serialVersionUID = 8375026855239413267L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONVERSATION);
    @Inject
    private Instance<ConversationImpl> currentConversation;
    @ConversationConcurrentAccessTimeout
    private long concurrentAccessTimeout;
    private Map<String, ConversationEntry> longRunningConversations = new ConcurrentHashMap<String, ConversationEntry>();

    @Override
    public void beginOrRestoreConversation(String cid) {
        if (cid == null) {
            log.trace(ConversationMessage.NO_CONVERSATION_TO_RESTORE, new Object[0]);
            return;
        }
        if (!this.longRunningConversations.containsKey(cid)) {
            throw new NonexistentConversationException(ConversationMessage.UNABLE_TO_RESTORE_CONVERSATION, cid, "id not known");
        }
        ConversationEntry resumedConversationEntry = this.longRunningConversations.get(cid);
        try {
            if (!resumedConversationEntry.lock(this.concurrentAccessTimeout)) {
                throw new BusyConversationException(ConversationMessage.CONVERSATION_LOCK_UNAVAILABLE, new Object[0]);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new BusyConversationException(ConversationMessage.CONVERSATION_LOCK_UNAVAILABLE, new Object[0]);
        }
        if (!resumedConversationEntry.cancelTermination()) {
            resumedConversationEntry.unlock();
            throw new BusyConversationException(ConversationMessage.CONVERSATION_LOCK_UNAVAILABLE, new Object[0]);
        }
        String oldConversation = this.currentConversation.toString();
        ((ConversationImpl)this.currentConversation.get()).switchTo(resumedConversationEntry.getConversation());
        log.trace(ConversationMessage.CONVERSATION_SWITCHED, oldConversation, this.currentConversation);
    }

    @Override
    public void cleanupConversation() {
        ConversationEntry longRunningConversation;
        log.trace(ConversationMessage.CLEANING_UP_CONVERSATION, this.currentConversation);
        String cid = ((ConversationImpl)this.currentConversation.get()).getUnderlyingId();
        if (!((ConversationImpl)this.currentConversation.get()).isTransient()) {
            Future<?> terminationHandle = this.scheduleForTermination(cid, ((ConversationImpl)this.currentConversation.get()).getTimeout());
            longRunningConversation = this.longRunningConversations.get(cid);
            if (longRunningConversation != null) {
                longRunningConversation.unlock();
                longRunningConversation.reScheduleTermination(terminationHandle);
            } else {
                ConversationEntry conversationEntry = ConversationEntry.of(this.getBeanStore(cid), (ConversationImpl)this.currentConversation.get(), terminationHandle);
                this.longRunningConversations.put(cid, conversationEntry);
            }
            log.trace(ConversationMessage.CONVERSATION_TERMINATION_SCHEDULED, this.currentConversation);
            log.trace(ConversationMessage.LRC_COUNT, this.longRunningConversations.size());
        } else {
            log.trace(ConversationMessage.DESTROY_TRANSIENT_COVERSATION, this.currentConversation);
            ConversationEntry longRunningConversation2 = this.longRunningConversations.remove(cid);
            if (longRunningConversation2 != null) {
                longRunningConversation2.cancelTermination();
                longRunningConversation2.unlock();
            }
            ConversationContext conversationContext = Container.instance().services().get(ContextLifecycle.class).getConversationContext();
            conversationContext.destroy();
        }
        String originalCid = ((ConversationImpl)this.currentConversation.get()).getOriginalId();
        ConversationEntry conversationEntry = longRunningConversation = originalCid == null ? null : this.longRunningConversations.get(originalCid);
        if (longRunningConversation != null) {
            longRunningConversation.unlock();
            longRunningConversation.reScheduleTermination(this.scheduleForTermination(originalCid, ((ConversationImpl)this.currentConversation.get()).getTimeout()));
        }
    }

    private Future<?> scheduleForTermination(String cid, long timeout) {
        TerminationTask terminationTask = new TerminationTask(cid);
        return Container.instance().services().get(ScheduledExecutorServiceFactory.class).get().schedule(terminationTask, timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void destroyAllConversations() {
        log.debug(ConversationMessage.DESTROY_ALL_LRC, "session ended");
        log.trace(ConversationMessage.LRC_COUNT, this.longRunningConversations.size());
        for (ConversationEntry conversationEntry : this.longRunningConversations.values()) {
            log.debug(ConversationMessage.DESTROY_LRC, conversationEntry, "session ended");
            conversationEntry.destroy();
        }
        this.longRunningConversations.clear();
    }

    @Override
    public Set<Conversation> getLongRunningConversations() {
        HashSet<ConversationImpl> conversations = new HashSet<ConversationImpl>();
        for (ConversationEntry conversationEntry : this.longRunningConversations.values()) {
            conversations.add(conversationEntry.getConversation());
        }
        return Collections.unmodifiableSet(conversations);
    }

    public abstract BeanStore getBeanStore(String var1);

    private class TerminationTask
    implements Runnable {
        private String cid;

        public TerminationTask(String cid) {
            this.cid = cid;
        }

        public void run() {
            log.debug(ConversationMessage.DESTROY_LRC, this.cid, "conversation timed out");
            ((ConversationEntry)AbstractConversationManager.this.longRunningConversations.remove(this.cid)).destroy();
            log.trace(ConversationMessage.LRC_COUNT, AbstractConversationManager.this.longRunningConversations.size());
        }
    }
}

