/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.context.ContextLifecycle;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.weld.conversation.ServletConversationManager;
import org.jboss.weld.exceptions.ForbiddenStateException;
import org.jboss.weld.logging.messages.ServletMessage;
import org.jboss.weld.servlet.BeanProvider;
import org.jboss.weld.servlet.HttpPassThruOnDemandSessionBeanStore;
import org.jboss.weld.servlet.HttpPassThruSessionBeanStore;

public class ServletLifecycle {
    private final ContextLifecycle lifecycle;
    public static final String REQUEST_ATTRIBUTE_NAME = ServletLifecycle.class.getName() + ".requestBeanStore";

    public ServletLifecycle(ContextLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void beginSession(HttpSession session) {
        HttpPassThruSessionBeanStore beanStore = (HttpPassThruSessionBeanStore)this.lifecycle.getSessionContext().getBeanStore();
        if (beanStore == null) {
            this.restoreSessionContext(session);
        } else {
            beanStore.attachToSession(session);
        }
    }

    public void endSession(HttpSession session) {
        ServletConversationManager conversationManager = (ServletConversationManager)BeanProvider.conversationManager(session.getServletContext());
        if (this.lifecycle.getSessionContext().isActive()) {
            HttpPassThruSessionBeanStore beanStore = (HttpPassThruSessionBeanStore)this.lifecycle.getSessionContext().getBeanStore();
            if (this.lifecycle.getRequestContext().isActive()) {
                beanStore.invalidate();
                conversationManager.invalidateSession();
                conversationManager.destroyAllConversations();
            } else {
                conversationManager.destroyAllConversations();
                this.lifecycle.endSession(session.getId(), beanStore);
            }
        } else if (this.lifecycle.getRequestContext().isActive()) {
            BeanStore store = this.restoreSessionContext(session);
            conversationManager.destroyAllConversations();
            this.lifecycle.endSession(session.getId(), store);
        } else {
            ConcurrentHashMapBeanStore mockRequest = new ConcurrentHashMapBeanStore();
            this.lifecycle.beginRequest("endSession-" + session.getId(), mockRequest);
            BeanStore sessionBeanStore = this.restoreSessionContext(session);
            conversationManager.destroyAllConversations();
            this.lifecycle.endSession(session.getId(), sessionBeanStore);
            this.lifecycle.endRequest("endSession-" + session.getId(), mockRequest);
        }
    }

    protected BeanStore restoreSessionContext(HttpServletRequest request) {
        HttpPassThruOnDemandSessionBeanStore sessionBeanStore = new HttpPassThruOnDemandSessionBeanStore(request);
        HttpSession session = request.getSession(false);
        this.lifecycle.restoreSession(session == null ? "Inactive session" : session.getId(), sessionBeanStore);
        if (session != null) {
            sessionBeanStore.attachToSession(session);
            BeanProvider.httpSessionManager(session.getServletContext()).setSession(session);
        }
        return sessionBeanStore;
    }

    protected BeanStore restoreSessionContext(HttpSession session) {
        HttpPassThruSessionBeanStore beanStore = new HttpPassThruSessionBeanStore();
        beanStore.attachToSession(session);
        this.lifecycle.restoreSession(session.getId(), beanStore);
        BeanProvider.httpSessionManager(session.getServletContext()).setSession(session);
        return beanStore;
    }

    public void beginRequest(HttpServletRequest request) {
        if (request.getAttribute(REQUEST_ATTRIBUTE_NAME) == null) {
            ConcurrentHashMapBeanStore beanStore = new ConcurrentHashMapBeanStore();
            request.setAttribute(REQUEST_ATTRIBUTE_NAME, (Object)beanStore);
            this.lifecycle.beginRequest(request.getRequestURI(), beanStore);
            this.restoreSessionContext(request);
        }
    }

    public void endRequest(HttpServletRequest request) {
        if (request.getAttribute(REQUEST_ATTRIBUTE_NAME) != null) {
            BeanStore beanStore = (BeanStore)request.getAttribute(REQUEST_ATTRIBUTE_NAME);
            if (beanStore == null) {
                throw new ForbiddenStateException(ServletMessage.REQUEST_SCOPE_BEAN_STORE_MISSING, new Object[0]);
            }
            this.lifecycle.endRequest(request.getRequestURI(), beanStore);
            request.removeAttribute(REQUEST_ATTRIBUTE_NAME);
            HttpPassThruSessionBeanStore sessionBeanStore = (HttpPassThruSessionBeanStore)this.lifecycle.getSessionContext().getBeanStore();
            if (sessionBeanStore != null && sessionBeanStore.isInvalidated()) {
                this.lifecycle.endSession(request.getRequestedSessionId(), sessionBeanStore);
            }
            this.lifecycle.getSessionContext().setActive(false);
            this.lifecycle.getSessionContext().setBeanStore(null);
        }
    }
}

