/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Names {
    private static Pattern CAPITAL_LETTERS = Pattern.compile("\\p{Upper}{1}\\p{Lower}*");

    public static String scopeTypeToString(Class<? extends Annotation> scopeType) {
        StringBuilder result = new StringBuilder();
        if (scopeType != null) {
            String scopeName = scopeType.getSimpleName();
            Matcher matcher = CAPITAL_LETTERS.matcher(scopeName);
            int i = 0;
            while (matcher.find()) {
                String name = matcher.group();
                if (i > 0) {
                    name = name.toLowerCase();
                }
                result.append(name).append(" ");
                ++i;
            }
        }
        return result.toString();
    }

    public static String toString(Class<?> rawType, Set<Annotation> annotations, Type[] actualTypeArguments) {
        if (actualTypeArguments.length > 0) {
            return Names.annotationsToString(annotations) + " " + rawType.getName() + "<" + Arrays.asList(actualTypeArguments) + ">";
        }
        return Names.annotationsToString(annotations) + " " + rawType.getName();
    }

    public static int count(Iterable<?> iterable) {
        int count = 0;
        Iterator<?> i = iterable.iterator();
        while (i.hasNext()) {
            ++count;
        }
        return count;
    }

    private static List<String> parseModifiers(int modifier) {
        ArrayList<String> modifiers = new ArrayList<String>();
        if (Modifier.isPrivate(modifier)) {
            modifiers.add("private");
        }
        if (Modifier.isProtected(modifier)) {
            modifiers.add("protected");
        }
        if (Modifier.isPublic(modifier)) {
            modifiers.add("public");
        }
        if (Modifier.isAbstract(modifier)) {
            modifiers.add("abstract");
        }
        if (Modifier.isFinal(modifier)) {
            modifiers.add("final");
        }
        if (Modifier.isNative(modifier)) {
            modifiers.add("native");
        }
        if (Modifier.isStatic(modifier)) {
            modifiers.add("static");
        }
        if (Modifier.isStrict(modifier)) {
            modifiers.add("strict");
        }
        if (Modifier.isSynchronized(modifier)) {
            modifiers.add("synchronized");
        }
        if (Modifier.isTransient(modifier)) {
            modifiers.add("transient");
        }
        if (Modifier.isVolatile(modifier)) {
            modifiers.add("volatile");
        }
        if (Modifier.isInterface(modifier)) {
            modifiers.add("interface");
        }
        return modifiers;
    }

    public static String typesToString(Set<? extends Type> types) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        buffer.append("[");
        for (Type type : types) {
            if (i > 0) {
                buffer.append(", ");
            }
            if (type instanceof Class) {
                buffer.append(((Class)type).getSimpleName());
            } else {
                buffer.append(type.toString());
            }
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String annotationsToString(Iterable<Annotation> annotations) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Annotation annotation : annotations) {
            if (i > 0) {
                builder.append(" ");
            }
            builder.append("@").append(annotation.annotationType().getSimpleName());
            ++i;
        }
        return builder.toString();
    }

    public static String annotationsToString(Annotation[] annotations) {
        return Names.annotationsToString(Arrays.asList(annotations));
    }

    public static String version(Package pkg) {
        if (pkg == null) {
            throw new IllegalArgumentException("Package can not be null");
        }
        return Names.version(pkg.getImplementationVersion());
    }

    public static String version(String version) {
        if (version != null) {
            StringBuilder builder = new StringBuilder();
            if (version.indexOf(".") > 0) {
                builder.append(version.substring(0, version.indexOf("."))).append(".");
                version = version.substring(version.indexOf(".") + 1);
            }
            if (version.indexOf(".") > 0) {
                builder.append(version.substring(0, version.indexOf("."))).append(".");
                version = version.substring(version.indexOf(".") + 1);
            }
            if (version.indexOf("-") > 0) {
                builder.append(version.substring(0, version.indexOf("-"))).append(" (");
                builder.append(version.substring(version.indexOf("-") + 1)).append(")");
            } else if (version.indexOf(".") > 0) {
                builder.append(version.substring(0, version.indexOf("."))).append(" (");
                builder.append(version.substring(version.indexOf(".") + 1)).append(")");
            } else {
                builder.append(version);
            }
            return builder.toString();
        }
        return "SNAPSHOT";
    }
}

