/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.util.DataStructures;
import java.util.Queue;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ConnectorInstanceHandler<E extends ConnectorHandler> {
    public E acquire();

    public void release(E var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ConcurrentQueueConnectorInstanceHandler<E extends ConnectorHandler>
    implements ConnectorInstanceHandler<E> {
        private final Queue<E> pool = DataStructures.getCLQinstance();

        @Override
        public E acquire() {
            ConnectorHandler connectorHandler = (ConnectorHandler)this.pool.poll();
            if (connectorHandler == null) {
                connectorHandler = this.newInstance();
            }
            return (E)connectorHandler;
        }

        @Override
        public void release(E connectorHandler) {
            this.pool.offer(connectorHandler);
        }

        public abstract E newInstance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConcurrentQueueDelegateCIH<E extends ConnectorHandler>
    extends ConcurrentQueueConnectorInstanceHandler<E> {
        private final Callable<E> delegate;

        public ConcurrentQueueDelegateCIH(Callable<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public E newInstance() {
            try {
                return (E)((ConnectorHandler)this.delegate.call());
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected exception", e);
            }
        }
    }
}

