/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.CallbackHandlerContextTask;
import com.sun.grizzly.CallbackHandlerDescriptor;
import com.sun.grizzly.CallbackHandlerSelectionKeyAttachment;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorInstanceHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.DefaultSelectionKeyHandler;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.LinuxSpinningWorkaround;
import com.sun.grizzly.NIOContext;
import com.sun.grizzly.PortRange;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.Role;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.SelectorHandlerRunner;
import com.sun.grizzly.SelectorHandlerTask;
import com.sun.grizzly.TCPConnectorHandler;
import com.sun.grizzly.async.AsyncQueueReader;
import com.sun.grizzly.async.AsyncQueueWriter;
import com.sun.grizzly.async.TCPAsyncQueueReader;
import com.sun.grizzly.async.TCPAsyncQueueWriter;
import com.sun.grizzly.util.Cloner;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.DataStructures;
import com.sun.grizzly.util.SelectionKeyAttachment;
import com.sun.grizzly.util.State;
import com.sun.grizzly.util.StateHolder;
import com.sun.grizzly.util.Utils;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPSelectorHandler
implements SelectorHandler,
LinuxSpinningWorkaround {
    private static final Object NULL_ATTACHMENT = new Object();
    private int maxAcceptRetries = 5;
    protected ConnectorInstanceHandler connectorInstanceHandler;
    protected final Queue<SelectorHandlerTask> selectorHandlerTasks = DataStructures.getCLQinstance(SelectorHandlerTask.class);
    protected final Queue<SelectorHandlerTask> postponedTasks = new LinkedList<SelectorHandlerTask>();
    private boolean executePendingIOUsingSelectorThread = false;
    protected boolean tcpNoDelay = true;
    protected boolean reuseAddress = true;
    protected boolean isKeepAlive = false;
    protected int linger = -1;
    protected int socketTimeout = -1;
    protected Logger logger;
    protected int serverTimeout = 0;
    protected InetAddress inet;
    int port = -1;
    protected PortRange portRange = new PortRange(18888);
    protected ServerSocket serverSocket;
    protected ServerSocketChannel serverSocketChannel;
    protected Selector selector;
    protected long selectTimeout = 1000L;
    protected int ssBackLog = 4096;
    protected Role role = Role.CLIENT_SERVER;
    protected SelectionKeyHandler selectionKeyHandler;
    protected ProtocolChainInstanceHandler instanceHandler;
    protected ExecutorService threadPool;
    protected AsyncQueueWriter asyncQueueWriter;
    protected AsyncQueueReader asyncQueueReader;
    protected Map<String, Object> attributes;
    protected StateHolder<State> stateHolder = new StateHolder(true);
    protected final AtomicBoolean isShutDown = new AtomicBoolean(false);
    private long lastSpinTimestamp;
    private int emptySpinCounter;
    private final WeakHashMap<Selector, Long> spinnedSelectorsHistory;
    private final Object spinSync;
    protected int sendBufferSize = -1;
    protected int receiveBufferSize = -1;

    public TCPSelectorHandler() {
        this(Role.CLIENT_SERVER);
    }

    public TCPSelectorHandler(boolean isClient) {
        this(TCPSelectorHandler.boolean2Role(isClient));
    }

    public TCPSelectorHandler(Role role) {
        this.role = role;
        this.logger = Controller.logger();
        if (Controller.isLinux) {
            this.spinnedSelectorsHistory = new WeakHashMap();
            this.spinSync = new Object();
        } else {
            this.spinnedSelectorsHistory = null;
            this.spinSync = null;
        }
    }

    public void copyTo(Copyable copy) {
        TCPSelectorHandler copyHandler = (TCPSelectorHandler)copy;
        copyHandler.selector = this.selector;
        if (this.selectionKeyHandler != null) {
            copyHandler.setSelectionKeyHandler((SelectionKeyHandler)Cloner.clone((Copyable)this.selectionKeyHandler));
        }
        copyHandler.instanceHandler = this.instanceHandler;
        copyHandler.attributes = this.attributes;
        copyHandler.selectTimeout = this.selectTimeout;
        copyHandler.serverTimeout = this.serverTimeout;
        copyHandler.inet = this.inet;
        copyHandler.portRange = this.portRange;
        copyHandler.ssBackLog = this.ssBackLog;
        copyHandler.tcpNoDelay = this.tcpNoDelay;
        copyHandler.linger = this.linger;
        copyHandler.isKeepAlive = this.isKeepAlive;
        copyHandler.socketTimeout = this.socketTimeout;
        copyHandler.logger = this.logger;
        copyHandler.reuseAddress = this.reuseAddress;
        copyHandler.connectorInstanceHandler = this.connectorInstanceHandler;
        copyHandler.stateHolder = this.stateHolder;
        copyHandler.executePendingIOUsingSelectorThread = this.executePendingIOUsingSelectorThread;
    }

    @Override
    public Set<SelectionKey> keys() {
        if (this.selector != null) {
            return this.selector.keys();
        }
        throw new IllegalStateException("Selector is not created!");
    }

    @Override
    public boolean isOpen() {
        if (this.selector != null) {
            return this.selector.isOpen();
        }
        return false;
    }

    @Override
    public void preSelect(Context ctx) throws IOException {
        if (this.asyncQueueReader == null) {
            this.asyncQueueReader = new TCPAsyncQueueReader(this);
        }
        if (this.asyncQueueWriter == null) {
            this.asyncQueueWriter = new TCPAsyncQueueWriter(this);
        }
        if (this.selector == null) {
            this.initSelector(ctx);
        } else {
            this.processPendingOperations(ctx);
        }
    }

    private final void initSelector(Context ctx) throws IOException {
        try {
            this.isShutDown.set(false);
            this.connectorInstanceHandler = new ConnectorInstanceHandler.ConcurrentQueueDelegateCIH<ConnectorHandler>(this.getConnectorInstanceHandlerDelegate());
            this.selector = Utils.openSelector();
            if (this.role != Role.CLIENT) {
                block10: {
                    this.serverSocketChannel = ServerSocketChannel.open();
                    this.serverSocket = this.serverSocketChannel.socket();
                    if (this.receiveBufferSize > 0) {
                        try {
                            this.serverSocket.setReceiveBufferSize(this.receiveBufferSize);
                        }
                        catch (SocketException se) {
                            if (this.logger.isLoggable(Level.FINE)) {
                                this.logger.log(Level.FINE, "setReceiveBufferSize exception ", se);
                            }
                        }
                        catch (IllegalArgumentException iae) {
                            if (!this.logger.isLoggable(Level.FINE)) break block10;
                            this.logger.log(Level.FINE, "setReceiveBufferSize exception ", iae);
                        }
                    }
                }
                if (this.inet == null) {
                    this.portRange.bind(this.serverSocket, this.ssBackLog);
                } else {
                    this.portRange.bind(this.serverSocket, this.inet, this.ssBackLog);
                }
                this.serverSocketChannel.configureBlocking(false);
                this.serverSocketChannel.register(this.selector, 16);
                this.serverSocket.setSoTimeout(this.serverTimeout);
                this.port = this.serverSocket.getLocalPort();
            }
            ctx.getController().notifyReady();
        }
        catch (SocketException ex) {
            throw new BindException(ex.getMessage() + ": " + this.port + "=" + this);
        }
    }

    protected void processPendingOperations(Context ctx) throws IOException {
        this.processPendingQueue(ctx, this.postponedTasks);
        this.processPendingQueue(ctx, this.selectorHandlerTasks);
    }

    private void processPendingQueue(Context ctx, Queue<SelectorHandlerTask> tasks) throws IOException {
        SelectorHandlerTask task;
        while ((task = tasks.poll()) != null) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Processing pending task: " + task);
            }
            task.run(ctx);
        }
    }

    private SelectionKey checkIfSpinnedKey(SelectionKey key) {
        if (!key.isValid() && key.channel().isOpen() && this.spinnedSelectorsHistory.containsKey(key.selector())) {
            SelectionKey newKey = key.channel().keyFor(this.selector);
            newKey.attach(key.attachment());
            return newKey;
        }
        return key;
    }

    protected void onConnectOp(Context ctx, ConnectChannelOperation selectionKeyOp) throws IOException {
        boolean isConnected;
        SocketChannel socketChannel = (SocketChannel)selectionKeyOp.getChannel();
        SocketAddress remoteAddress = selectionKeyOp.getRemoteAddress();
        CallbackHandler callbackHandler = selectionKeyOp.getCallbackHandler();
        CallbackHandlerSelectionKeyAttachment attachment = new CallbackHandlerSelectionKeyAttachment(callbackHandler);
        SelectionKey key = socketChannel.register(this.selector, 0, (Object)attachment);
        attachment.associateKey(key);
        try {
            isConnected = socketChannel.connect(remoteAddress);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Exception occured when tried to connect socket", e);
            }
            isConnected = true;
        }
        if (isConnected) {
            this.onConnectInterest(key, ctx);
        } else {
            key.interestOps(8);
        }
    }

    @Override
    public Set<SelectionKey> select(Context ctx) throws IOException {
        if (this.postponedTasks.isEmpty()) {
            this.selector.select(this.selectTimeout);
        } else {
            this.selector.selectNow();
        }
        return this.selector.selectedKeys();
    }

    @Override
    public void postSelect(Context ctx) {
        this.selectionKeyHandler.expire(this.keys().iterator());
    }

    public void addPendingIO(Runnable runnable) {
        this.selectorHandlerTasks.add(new RunnableOperation(runnable));
        this.wakeUp();
    }

    public void addPendingKeyCancel(SelectionKey key) {
        this.selectorHandlerTasks.add(new SelectionKeyCancelOperation(key));
        this.wakeUp();
    }

    @Override
    public void register(SelectionKey key, int ops) {
        if (key == null) {
            throw new NullPointerException("SelectionKey parameter is null");
        }
        this.selectorHandlerTasks.offer(new RegisterKeyOperation(key, ops));
        this.wakeUp();
    }

    @Override
    public void register(SelectableChannel channel, int ops) {
        this.register(channel, ops, NULL_ATTACHMENT);
    }

    @Override
    public void register(SelectableChannel channel, int ops, Object attachment) {
        if (channel == null) {
            throw new NullPointerException("SelectableChannel parameter is null");
        }
        this.selectorHandlerTasks.offer(new RegisterChannelOperation(channel, ops, attachment));
        this.wakeUp();
    }

    private void wakeUp() {
        try {
            this.selector.wakeup();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler) throws IOException {
        SelectableChannel selectableChannel = this.getSelectableChannel(remoteAddress, localAddress);
        ConnectChannelOperation connectKeyOp = new ConnectChannelOperation(selectableChannel, remoteAddress, callbackHandler);
        this.selectorHandlerTasks.offer(connectKeyOp);
        this.wakeUp();
    }

    protected SelectableChannel getSelectableChannel(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        Socket newSocket;
        SocketChannel newSocketChannel;
        block12: {
            block11: {
                newSocketChannel = SocketChannel.open();
                newSocket = newSocketChannel.socket();
                if (this.receiveBufferSize > 0) {
                    try {
                        newSocket.setReceiveBufferSize(this.receiveBufferSize);
                    }
                    catch (SocketException se) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.log(Level.FINE, "setReceiveBufferSize exception ", se);
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        if (!this.logger.isLoggable(Level.FINE)) break block11;
                        this.logger.log(Level.FINE, "setReceiveBufferSize exception ", iae);
                    }
                }
            }
            if (this.sendBufferSize > 0) {
                try {
                    newSocket.setSendBufferSize(this.sendBufferSize);
                }
                catch (SocketException se) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "setSendBufferSize exception ", se);
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (!this.logger.isLoggable(Level.FINE)) break block12;
                    this.logger.log(Level.FINE, "setSendBufferSize exception ", iae);
                }
            }
        }
        newSocket.setReuseAddress(this.reuseAddress);
        if (localAddress != null) {
            newSocket.bind(localAddress);
        }
        newSocketChannel.configureBlocking(false);
        return newSocketChannel;
    }

    @Override
    public void pause() {
        this.stateHolder.setState((Object)State.PAUSED);
    }

    @Override
    public void resume() {
        if (!State.PAUSED.equals(this.stateHolder.getState(false))) {
            throw new IllegalStateException("SelectorHandler is not in PAUSED state, but: " + this.stateHolder.getState(false));
        }
        this.stateHolder.setState((Object)State.STARTED);
    }

    public StateHolder<State> getStateHolder() {
        return this.stateHolder;
    }

    @Override
    public void shutdown() {
        if (this.isShutDown.getAndSet(true)) {
            return;
        }
        this.stateHolder.setState((Object)State.STOPPED);
        if (this.selector != null) {
            try {
                boolean isContinue = true;
                while (isContinue) {
                    try {
                        for (SelectionKey selectionKey : this.selector.keys()) {
                            this.selectionKeyHandler.close(selectionKey);
                        }
                        isContinue = false;
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {}
                }
            }
            catch (ClosedSelectorException e) {
                // empty catch block
            }
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
                this.serverSocket = null;
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "serverSocket.close", ex);
        }
        try {
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
                this.serverSocketChannel = null;
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "serverSocketChannel.close", ex);
        }
        try {
            if (this.selector != null) {
                this.selector.close();
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "selector.close", ex);
        }
        if (this.asyncQueueReader != null) {
            this.asyncQueueReader.close();
            this.asyncQueueReader = null;
        }
        if (this.asyncQueueWriter != null) {
            this.asyncQueueWriter.close();
            this.asyncQueueWriter = null;
        }
        this.selectorHandlerTasks.clear();
        this.attributes = null;
    }

    @Override
    public SelectableChannel acceptWithoutRegistration(SelectionKey key) throws IOException {
        int retryNum = 0;
        while (true) {
            boolean isAccepted;
            try {
                isAccepted = true;
                return ((ServerSocketChannel)key.channel()).accept();
            }
            catch (IOException ex) {
                if (!key.isValid()) {
                    throw ex;
                }
                isAccepted = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex1) {
                    throw new IOException(ex1.getMessage());
                }
                this.logger.log(Level.WARNING, "Exception accepting channel", ex);
                if (!isAccepted && retryNum++ < this.maxAcceptRetries) continue;
                throw new IOException("Accept retries exceeded");
            }
            break;
        }
    }

    @Override
    public boolean onAcceptInterest(SelectionKey key, Context ctx) throws IOException {
        SelectableChannel channel = this.acceptWithoutRegistration(key);
        if (channel != null) {
            this.configureChannel(channel);
            SelectionKey readKey = channel.register(this.selector, 1);
            readKey.attach(System.currentTimeMillis());
        }
        return false;
    }

    @Override
    public boolean onReadInterest(SelectionKey key, Context ctx) throws IOException {
        key.interestOps(key.interestOps() & 0xFFFFFFFE);
        if (this.asyncQueueReader.isReady(key)) {
            this.invokeAsyncQueueReader(this.pollContext(ctx, key, Context.OpType.OP_READ));
            return false;
        }
        Object attach = SelectionKeyAttachment.getAttachment((SelectionKey)key);
        if (attach instanceof CallbackHandler) {
            NIOContext context = this.pollContext(ctx, key, Context.OpType.OP_READ);
            this.invokeCallbackHandler((CallbackHandler)attach, context);
            return false;
        }
        return true;
    }

    @Override
    public boolean onWriteInterest(SelectionKey key, Context ctx) throws IOException {
        key.interestOps(key.interestOps() & 0xFFFFFFFB);
        if (this.asyncQueueWriter.isReady(key)) {
            this.invokeAsyncQueueWriter(this.pollContext(ctx, key, Context.OpType.OP_WRITE));
            return false;
        }
        Object attach = SelectionKeyAttachment.getAttachment((SelectionKey)key);
        if (attach instanceof CallbackHandler) {
            NIOContext context = this.pollContext(ctx, key, Context.OpType.OP_WRITE);
            this.invokeCallbackHandler((CallbackHandler)attach, context);
            return false;
        }
        return true;
    }

    @Override
    public boolean onConnectInterest(SelectionKey key, Context ctx) throws IOException {
        block3: {
            try {
                key.interestOps(key.interestOps() & 0x10);
            }
            catch (CancelledKeyException e) {
                if (!this.logger.isLoggable(Level.FINE)) break block3;
                this.logger.log(Level.FINE, "CancelledKeyException occured when tried to change key interests", e);
            }
        }
        Object attach = SelectionKeyAttachment.getAttachment((SelectionKey)key);
        if (attach instanceof CallbackHandler) {
            NIOContext context = this.pollContext(ctx, key, Context.OpType.OP_CONNECT);
            this.invokeCallbackHandler((CallbackHandler)attach, context);
        }
        return false;
    }

    protected void invokeCallbackHandler(CallbackHandler callbackHandler, NIOContext context) throws IOException {
        IOEvent.DefaultIOEvent<Context> ioEvent = new IOEvent.DefaultIOEvent<Context>(context);
        context.setIOEvent(ioEvent);
        context.setSelectorHandler(this);
        CallbackHandlerContextTask task = context.getCallbackHandlerContextTask(callbackHandler);
        boolean isRunInSeparateThread = true;
        if (callbackHandler instanceof CallbackHandlerDescriptor) {
            isRunInSeparateThread = ((CallbackHandlerDescriptor)((Object)callbackHandler)).isRunInSeparateThread(context.getCurrentOpType());
        }
        context.execute(task, isRunInSeparateThread);
    }

    protected void invokeAsyncQueueReader(NIOContext context) throws IOException {
        context.execute(context.getAsyncQueueReaderContextTask(this.asyncQueueReader));
    }

    protected void invokeAsyncQueueWriter(NIOContext context) throws IOException {
        context.execute(context.getAsyncQueueWriterContextTask(this.asyncQueueWriter));
    }

    @Override
    public ConnectorHandler acquireConnectorHandler() {
        if (this.selector == null || !this.selector.isOpen()) {
            throw new IllegalStateException("SelectorHandler not yet started");
        }
        Object connectorHandler = this.connectorInstanceHandler.acquire();
        connectorHandler.setController(Controller.getHandlerController(this));
        return connectorHandler;
    }

    @Override
    public void releaseConnectorHandler(ConnectorHandler connectorHandler) {
        this.connectorInstanceHandler.release(connectorHandler);
    }

    @Override
    public Controller.Protocol protocol() {
        return Controller.Protocol.TCP;
    }

    @Override
    public void configureChannel(SelectableChannel channel) throws IOException {
        block29: {
            Socket socket;
            block28: {
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                block23: {
                                    socket = ((SocketChannel)channel).socket();
                                    channel.configureBlocking(false);
                                    if (!channel.isOpen()) {
                                        return;
                                    }
                                    try {
                                        if (this.socketTimeout >= 0) {
                                            socket.setSoTimeout(this.socketTimeout);
                                        }
                                    }
                                    catch (SocketException ex) {
                                        if (!this.logger.isLoggable(Level.FINE)) break block23;
                                        this.logger.log(Level.FINE, "setSoTimeout exception ", ex);
                                    }
                                }
                                try {
                                    if (this.linger >= 0) {
                                        socket.setSoLinger(true, this.linger);
                                    }
                                }
                                catch (SocketException ex) {
                                    if (!this.logger.isLoggable(Level.FINE)) break block24;
                                    this.logger.log(Level.FINE, "setSoLinger exception ", ex);
                                }
                            }
                            try {
                                socket.setKeepAlive(this.isKeepAlive);
                            }
                            catch (SocketException ex) {
                                if (!this.logger.isLoggable(Level.FINE)) break block25;
                                this.logger.log(Level.FINE, "setKeepAlive exception ", ex);
                            }
                        }
                        try {
                            socket.setTcpNoDelay(this.tcpNoDelay);
                        }
                        catch (SocketException ex) {
                            if (!this.logger.isLoggable(Level.FINE)) break block26;
                            this.logger.log(Level.FINE, "setTcpNoDelay exception ", ex);
                        }
                    }
                    if (this.receiveBufferSize > 0) {
                        try {
                            socket.setReceiveBufferSize(this.receiveBufferSize);
                        }
                        catch (SocketException se) {
                            if (this.logger.isLoggable(Level.FINE)) {
                                this.logger.log(Level.FINE, "setReceiveBufferSize exception ", se);
                            }
                        }
                        catch (IllegalArgumentException iae) {
                            if (!this.logger.isLoggable(Level.FINE)) break block27;
                            this.logger.log(Level.FINE, "setReceiveBufferSize exception ", iae);
                        }
                    }
                }
                if (this.sendBufferSize > 0) {
                    try {
                        socket.setSendBufferSize(this.sendBufferSize);
                    }
                    catch (SocketException se) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.log(Level.FINE, "setSendBufferSize exception ", se);
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        if (!this.logger.isLoggable(Level.FINE)) break block28;
                        this.logger.log(Level.FINE, "setSendBufferSize exception ", iae);
                    }
                }
            }
            try {
                socket.setReuseAddress(this.reuseAddress);
            }
            catch (SocketException ex) {
                if (!this.logger.isLoggable(Level.FINE)) break block29;
                this.logger.log(Level.FINE, "setReuseAddress exception ", ex);
            }
        }
    }

    @Override
    public final Selector getSelector() {
        return this.selector;
    }

    @Override
    public final void setSelector(Selector selector) {
        this.selector = selector;
    }

    @Override
    public AsyncQueueReader getAsyncQueueReader() {
        return this.asyncQueueReader;
    }

    @Override
    public AsyncQueueWriter getAsyncQueueWriter() {
        return this.asyncQueueWriter;
    }

    public long getSelectTimeout() {
        return this.selectTimeout;
    }

    public void setSelectTimeout(long selectTimeout) {
        this.selectTimeout = selectTimeout;
    }

    public int getServerTimeout() {
        return this.serverTimeout;
    }

    public void setServerTimeout(int serverTimeout) {
        this.serverTimeout = serverTimeout;
    }

    public InetAddress getInet() {
        return this.inet;
    }

    public void setInet(InetAddress inet) {
        this.inet = inet;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public int getPortLowLevel() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return -1;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.portRange = new PortRange(port);
    }

    public PortRange getPortRange() {
        return this.portRange;
    }

    public void setPortRange(PortRange portRange) {
        this.portRange = portRange;
    }

    public int getSsBackLog() {
        return this.ssBackLog;
    }

    public void setSsBackLog(int ssBackLog) {
        this.ssBackLog = ssBackLog;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public boolean isKeepAlive() {
        return this.isKeepAlive;
    }

    public void setKeepAlive(boolean isKeepAlive) {
        this.isKeepAlive = isKeepAlive;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    @Override
    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    @Override
    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public Class<? extends SelectionKeyHandler> getPreferredSelectionKeyHandler() {
        return DefaultSelectionKeyHandler.class;
    }

    @Override
    public SelectionKeyHandler getSelectionKeyHandler() {
        return this.selectionKeyHandler;
    }

    @Override
    public void setSelectionKeyHandler(SelectionKeyHandler selectionKeyHandler) {
        this.selectionKeyHandler = selectionKeyHandler;
        this.selectionKeyHandler.setSelectorHandler(this);
    }

    @Override
    public void setProtocolChainInstanceHandler(ProtocolChainInstanceHandler instanceHandler) {
        this.instanceHandler = instanceHandler;
    }

    @Override
    public ProtocolChainInstanceHandler getProtocolChainInstanceHandler() {
        return this.instanceHandler;
    }

    @Override
    public void closeChannel(SelectableChannel channel) {
        if (channel instanceof SocketChannel) {
            Socket socket = ((SocketChannel)channel).socket();
            try {
                if (!socket.isInputShutdown()) {
                    socket.shutdownInput();
                }
            }
            catch (IOException e) {
                this.logger.log(Level.FINEST, "Unexpected exception during channel inputShutdown", e);
            }
            try {
                if (!socket.isOutputShutdown()) {
                    socket.shutdownOutput();
                }
            }
            catch (IOException e) {
                this.logger.log(Level.FINEST, "Unexpected exception during channel outputShutdown", e);
            }
            try {
                socket.close();
            }
            catch (IOException e) {
                this.logger.log(Level.FINEST, "Unexpected exception during socket close", e);
            }
        }
        try {
            channel.close();
        }
        catch (IOException e) {
            this.logger.log(Level.FINEST, "Unexpected exception during channel close", e);
        }
        if (this.asyncQueueReader != null) {
            this.asyncQueueReader.onClose(channel);
        }
        if (this.asyncQueueWriter != null) {
            this.asyncQueueWriter.onClose(channel);
        }
    }

    protected NIOContext pollContext(Context serverContext, SelectionKey key, Context.OpType opType) {
        Controller c = serverContext.getController();
        ProtocolChain protocolChain = this.instanceHandler != null ? this.instanceHandler.poll() : c.getProtocolChainInstanceHandler().poll();
        NIOContext context = (NIOContext)c.pollContext();
        c.configureContext(key, opType, context, this);
        context.setProtocolChain(protocolChain);
        return context;
    }

    protected Callable<ConnectorHandler> getConnectorInstanceHandlerDelegate() {
        return new Callable<ConnectorHandler>(){

            @Override
            public ConnectorHandler call() throws Exception {
                return new TCPConnectorHandler();
            }
        };
    }

    public Object removeAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(key);
    }

    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    protected static Role boolean2Role(boolean isClient) {
        if (isClient) {
            return Role.CLIENT;
        }
        return Role.CLIENT_SERVER;
    }

    @Override
    public void resetSpinCounter() {
        this.emptySpinCounter = 0;
    }

    @Override
    public int getSpinRate() {
        if (this.emptySpinCounter++ == 0) {
            this.lastSpinTimestamp = System.nanoTime();
        } else if (this.emptySpinCounter == 1000) {
            long deltatime = System.nanoTime() - this.lastSpinTimestamp;
            int contspinspersec = (int)(1000000000000L / deltatime);
            this.emptySpinCounter = 0;
            return contspinspersec;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void workaroundSelectorSpin() throws IOException {
        Object object = this.spinSync;
        synchronized (object) {
            this.spinnedSelectorsHistory.put(this.selector, System.currentTimeMillis());
            SelectorHandlerRunner.switchToNewSelector(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectionKey keyFor(SelectableChannel channel) {
        if (Controller.isLinux) {
            Object object = this.spinSync;
            synchronized (object) {
                return channel.keyFor(this.selector);
            }
        }
        return channel.keyFor(this.selector);
    }

    public void setSendBufferSize(int size) {
        this.sendBufferSize = size;
    }

    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    public boolean isExecutePendingIOUsingSelectorThread() {
        return this.executePendingIOUsingSelectorThread;
    }

    public void setExecutePendingIOUsingSelectorThread(boolean executePendingIOUsingSelectorThread) {
        this.executePendingIOUsingSelectorThread = executePendingIOUsingSelectorThread;
    }

    public void setMaxAcceptRetries(int maxAcceptRetries) {
        this.maxAcceptRetries = maxAcceptRetries;
    }

    protected final class ConnectChannelOperation
    implements SelectorHandlerTask {
        private final SelectableChannel channel;
        private final SocketAddress remoteAddress;
        private final CallbackHandler callbackHandler;

        private ConnectChannelOperation(SelectableChannel channel, SocketAddress remoteAddress, CallbackHandler callbackHandler) {
            this.channel = channel;
            this.remoteAddress = remoteAddress;
            this.callbackHandler = callbackHandler;
        }

        public void run(Context context) throws IOException {
            TCPSelectorHandler.this.onConnectOp(context, this);
        }

        public CallbackHandler getCallbackHandler() {
            return this.callbackHandler;
        }

        public SelectableChannel getChannel() {
            return this.channel;
        }

        public SocketAddress getRemoteAddress() {
            return this.remoteAddress;
        }
    }

    protected final class RegisterChannelOperation
    implements SelectorHandlerTask {
        private final SelectableChannel channel;
        private final int interest;
        private final Object attachment;

        public RegisterChannelOperation(SelectableChannel channel, int interest, Object attachment) {
            this.channel = channel;
            this.interest = interest;
            this.attachment = attachment;
        }

        public void run(Context context) throws IOException {
            if (this.channel.isOpen()) {
                SelectionKey key = this.channel.keyFor(TCPSelectorHandler.this.selector);
                boolean isKeyValid = true;
                if (key == null || (isKeyValid = key.isValid())) {
                    if (this.attachment == NULL_ATTACHMENT) {
                        TCPSelectorHandler.this.selectionKeyHandler.register(this.channel, this.interest);
                    } else {
                        TCPSelectorHandler.this.selectionKeyHandler.register(this.channel, this.interest, this.attachment);
                    }
                    return;
                }
                if (!isKeyValid) {
                    TCPSelectorHandler.this.postponedTasks.add(this);
                }
            }
        }
    }

    protected final class RegisterKeyOperation
    implements SelectorHandlerTask {
        private final SelectionKey selectionKey;
        private final int interest;

        public RegisterKeyOperation(SelectionKey selectionKey, int interest) {
            this.selectionKey = selectionKey;
            this.interest = interest;
        }

        public void run(Context context) throws IOException {
            SelectionKey localSelectionKey = this.selectionKey;
            if (Controller.isLinux) {
                localSelectionKey = TCPSelectorHandler.this.checkIfSpinnedKey(this.selectionKey);
            }
            TCPSelectorHandler.this.selectionKeyHandler.register(localSelectionKey, this.interest);
        }
    }

    protected final class RunnableOperation
    implements SelectorHandlerTask {
        private final Runnable task;

        public RunnableOperation(Runnable task) {
            this.task = task;
        }

        public void run(Context context) throws IOException {
            try {
                this.task.run();
            }
            catch (Throwable t) {
                TCPSelectorHandler.this.logger.log(Level.FINEST, "doExecutePendiongIO failed.", t);
            }
        }
    }

    protected final class SelectionKeyCancelOperation
    implements SelectorHandlerTask {
        private final SelectionKey selectionKey;

        public SelectionKeyCancelOperation(SelectionKey selectionKey) {
            this.selectionKey = selectionKey;
        }

        public void run(Context context) throws IOException {
            try {
                TCPSelectorHandler.this.selectionKeyHandler.close(this.selectionKey);
            }
            catch (Throwable t) {
                TCPSelectorHandler.this.logger.log(Level.FINEST, "doExecutePendiongIO failed.", t);
            }
        }
    }
}

