/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.async;

import com.sun.grizzly.Controller;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.async.AsyncQueue;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.async.AsyncQueueWriteUnit;
import com.sun.grizzly.async.AsyncQueueWriter;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.async.ByteBufferCloner;
import com.sun.grizzly.async.OperationResult;
import com.sun.grizzly.util.FutureImpl;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAsyncQueueWriter
implements AsyncQueueWriter {
    protected final SelectorHandler selectorHandler;
    private final AsyncQueue<SelectableChannel, AsyncQueueWriteUnit> writeQueue;

    public AbstractAsyncQueueWriter(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
        this.writeQueue = new AsyncQueue();
    }

    @Override
    public Future<AsyncQueueWriteUnit> write(SelectionKey key, ByteBuffer buffer) throws IOException {
        return this.write(key, null, buffer, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> write(SelectionKey key, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        return this.write(key, null, buffer, callbackHandler, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> write(SelectionKey key, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        return this.write(key, null, buffer, callbackHandler, writePreProcessor, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> write(SelectionKey key, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, ByteBufferCloner cloner) throws IOException {
        return this.write(key, null, buffer, callbackHandler, writePreProcessor, cloner);
    }

    @Override
    public Future<AsyncQueueWriteUnit> write(SelectionKey key, SocketAddress dstAddress, ByteBuffer buffer) throws IOException {
        return this.write(key, dstAddress, buffer, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> write(SelectionKey key, SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        return this.write(key, dstAddress, buffer, callbackHandler, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> write(SelectionKey key, SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        return this.write(key, dstAddress, buffer, callbackHandler, writePreProcessor, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> write(SelectionKey key, SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, ByteBufferCloner cloner) throws IOException {
        if (key == null) {
            throw new IOException("SelectionKey is null! Probably key was cancelled or connection was closed?");
        }
        FutureImpl future = new FutureImpl();
        SelectableChannel channel = key.channel();
        AsyncQueue.AsyncQueueEntry channelEntry = this.writeQueue.obtainAsyncQueueEntry(channel);
        channelEntry.totalElementsCount.incrementAndGet();
        AsyncQueueWriteUnit record = new AsyncQueueWriteUnit();
        Queue<AsyncQueueWriteUnit> queue = channelEntry.queue;
        AtomicReference currentElement = channelEntry.currentElement;
        ReentrantLock lock = channelEntry.queuedActionLock;
        int holdState = lock.getHoldCount();
        try {
            if (currentElement.get() == null && lock.tryLock()) {
                if (currentElement.compareAndSet(null, record)) {
                    OperationResult dstResult = channelEntry.tmpResult;
                    this.doWrite((WritableByteChannel)((Object)channel), dstAddress, buffer, writePreProcessor, dstResult);
                    channelEntry.processedDataSize.addAndGet(dstResult.bytesProcessed);
                } else {
                    lock.unlock();
                }
            }
            if (buffer.hasRemaining() || lock.isHeldByCurrentThread() && writePreProcessor != null && writePreProcessor.getInternalByteBuffer().hasRemaining()) {
                if (cloner != null) {
                    buffer = cloner.clone(buffer);
                    record.setCloned(true);
                }
                channelEntry.queuedElementsCount.incrementAndGet();
                record.set(buffer, callbackHandler, writePreProcessor, dstAddress, cloner, (Future)future);
                boolean isRegisterForWriting = false;
                if (currentElement.get() != record) {
                    queue.offer(record);
                    if (!lock.isLocked()) {
                        isRegisterForWriting = true;
                    }
                } else {
                    isRegisterForWriting = true;
                    lock.unlock();
                }
                if (isRegisterForWriting) {
                    this.registerForWriting(key);
                }
            } else {
                record.set(buffer, callbackHandler, writePreProcessor, dstAddress, cloner, (Future)future);
                future.setResult((Object)record);
                channelEntry.processedElementsCount.incrementAndGet();
                if (callbackHandler != null) {
                    callbackHandler.onWriteCompleted(key, record);
                }
                if (lock.isHeldByCurrentThread()) {
                    AsyncQueueWriteUnit nextRecord = queue.poll();
                    if (nextRecord != null) {
                        currentElement.set(nextRecord);
                        lock.unlock();
                        this.registerForWriting(key);
                    } else {
                        currentElement.set(null);
                        lock.unlock();
                        if (queue.peek() != null) {
                            this.registerForWriting(key);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            if (record.callbackHandler != null) {
                record.callbackHandler.onException(e, key, buffer, queue);
            }
            this.onClose(channel);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
        finally {
            if (lock.isHeldByCurrentThread() && holdState < lock.getHoldCount()) {
                lock.unlock();
            }
        }
        return future;
    }

    @Override
    public boolean isReady(SelectionKey key) {
        AsyncQueue.AsyncQueueEntry channelEntry = this.writeQueue.getAsyncQueueEntry(key.channel());
        return channelEntry != null && (channelEntry.currentElement.get() != null || channelEntry.queue != null && !channelEntry.queue.isEmpty());
    }

    @Override
    public AsyncQueue.AsyncQueueEntry getAsyncQueue(SelectionKey key) {
        return this.writeQueue.getAsyncQueueEntry(key.channel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onWrite(SelectionKey key) throws IOException {
        SelectableChannel channel = key.channel();
        AsyncQueue.AsyncQueueEntry channelEntry = this.writeQueue.obtainAsyncQueueEntry(channel);
        Queue<AsyncQueueWriteUnit> queue = channelEntry.queue;
        AtomicReference currentElement = channelEntry.currentElement;
        ReentrantLock lock = channelEntry.queuedActionLock;
        if (currentElement.get() == null) {
            AsyncQueueWriteUnit nextRecord = (AsyncQueueWriteUnit)queue.peek();
            if (nextRecord == null || !lock.tryLock()) return;
            if (!queue.isEmpty() && currentElement.compareAndSet(null, nextRecord)) {
                queue.remove();
            }
        } else if (!lock.tryLock()) {
            return;
        }
        try {
            OperationResult dstResult = channelEntry.tmpResult;
            while (currentElement.get() != null) {
                AsyncQueueWriteUnit queueRecord = (AsyncQueueWriteUnit)currentElement.get();
                ByteBuffer byteBuffer = queueRecord.byteBuffer;
                AsyncQueueDataProcessor writePreProcessor = queueRecord.writePreProcessor;
                try {
                    this.doWrite((WritableByteChannel)((Object)channel), queueRecord.dstAddress, byteBuffer, writePreProcessor, dstResult);
                    channelEntry.processedDataSize.addAndGet(dstResult.bytesProcessed);
                }
                catch (Exception e) {
                    ((FutureImpl)queueRecord.future).setException((Throwable)e);
                    if (queueRecord.callbackHandler != null) {
                        queueRecord.callbackHandler.onException(e, key, byteBuffer, queue);
                    } else {
                        Controller.logger().log(Level.SEVERE, "Exception occured when executing asynchronous queue writing", e);
                    }
                    this.onClose(channel);
                }
                if (!(byteBuffer.hasRemaining() || writePreProcessor != null && writePreProcessor.getInternalByteBuffer().hasRemaining())) {
                    channelEntry.processedElementsCount.incrementAndGet();
                    if (queueRecord.callbackHandler != null) {
                        queueRecord.callbackHandler.onWriteCompleted(key, queueRecord);
                    }
                    currentElement.set(queue.poll());
                    if (currentElement.get() != null) continue;
                    lock.unlock();
                    AsyncQueueWriteUnit nextRecord = queue.peek();
                    if (nextRecord == null || !lock.tryLock()) return;
                    if (queue.isEmpty() || !currentElement.compareAndSet(null, nextRecord)) continue;
                    queue.remove();
                    continue;
                }
                lock.unlock();
                this.registerForWriting(key);
                return;
            }
            return;
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                channelEntry.queuedActionLock.unlock();
            }
        }
    }

    @Override
    public void onClose(SelectableChannel channel) {
        this.writeQueue.removeEntry(channel);
    }

    @Override
    public void close() {
        this.writeQueue.clear();
    }

    protected OperationResult doWrite(WritableByteChannel channel, SocketAddress dstAddress, ByteBuffer byteBuffer, AsyncQueueDataProcessor writePreProcessor, OperationResult dstResult) throws IOException {
        if (writePreProcessor != null) {
            ByteBuffer resultByteBuffer = null;
            int written = 0;
            do {
                if (byteBuffer.hasRemaining()) {
                    writePreProcessor.process(byteBuffer);
                }
                if ((resultByteBuffer = writePreProcessor.getInternalByteBuffer()) == null) continue;
                this.doWrite(channel, dstAddress, resultByteBuffer, dstResult);
                written += dstResult.bytesProcessed;
            } while (byteBuffer.hasRemaining() && (resultByteBuffer == null || !resultByteBuffer.hasRemaining()));
            dstResult.bytesProcessed = written;
            return dstResult;
        }
        return this.doWrite(channel, dstAddress, byteBuffer, dstResult);
    }

    protected abstract OperationResult doWrite(WritableByteChannel var1, SocketAddress var2, ByteBuffer var3, OperationResult var4) throws IOException;

    protected void registerForWriting(SelectionKey key) {
        this.selectorHandler.register(key, 4);
    }
}

