/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FrameType {
    TEXT{

        public boolean accept(byte delim) {
            return delim == 0;
        }

        public byte[] unframe(ByteBuffer buffer) {
            ByteArrayOutputStream raw = new ByteArrayOutputStream();
            int b = 0;
            while (buffer.hasRemaining()) {
                byte by = buffer.get();
                b = by;
                if (by == -1) break;
                raw.write(b);
            }
            if (b != -1) {
                throw new RuntimeException("Malformed frame.  Missing frame end delimiter: " + b);
            }
            return raw.toByteArray();
        }

        public byte[] frame(byte[] data) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(data.length + 2);
            out.write(0);
            out.write(data, 0, data.length);
            out.write(-1);
            return out.toByteArray();
        }
    };


    public abstract boolean accept(byte var1);

    public abstract byte[] unframe(ByteBuffer var1) throws IOException;

    public abstract byte[] frame(byte[] var1);
}

