/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.MimeHeaders;
import com.sun.grizzly.util.net.URL;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class HandShake {
    static final Logger logger = Logger.getLogger("websocket");
    private final String origin;
    private final String serverHostName;
    protected String port = "80";
    private final boolean secure;
    private final String resourcePath;
    private final String location;
    private final String protocol;

    public HandShake(MimeHeaders headers, boolean isSecure, String path) {
        int i;
        this.secure = isSecure;
        this.origin = this.readHeader(headers, "origin");
        String header = this.readHeader(headers, "host");
        int n = i = header == null ? -1 : header.indexOf(":");
        if (i == -1) {
            this.serverHostName = header;
            this.port = "80";
        } else {
            this.serverHostName = header.substring(0, i);
            this.port = header.substring(i + 1);
        }
        this.resourcePath = path;
        this.protocol = headers.getHeader("WebSocket-Protocol");
        this.location = this.buildLocation(isSecure);
    }

    public HandShake(boolean isSecure, String origin, String serverHostName, String path) {
        this.origin = origin;
        this.serverHostName = serverHostName;
        this.secure = isSecure;
        try {
            URL url = new URL(origin);
            int portNumber = url.getPort();
            if (portNumber != -1) {
                this.port = String.valueOf(portNumber);
            }
        }
        catch (MalformedURLException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.resourcePath = path;
        this.protocol = null;
        this.location = this.buildLocation(isSecure);
    }

    private String buildLocation(boolean isSecure) {
        StringBuilder builder = new StringBuilder((isSecure ? "wss" : "ws") + "://" + this.serverHostName);
        if (!"80".equals(this.port)) {
            builder.append(":" + this.port);
        }
        if (this.resourcePath == null || !this.resourcePath.startsWith("/") && !"".equals(this.resourcePath)) {
            builder.append("/");
        }
        builder.append(this.resourcePath);
        return builder.toString();
    }

    final String readHeader(MimeHeaders headers, String name) {
        MessageBytes value = headers.getValue(name);
        return value == null ? null : value.toString();
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getServerHostName() {
        return this.serverHostName;
    }

    public String getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }
}

