/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.arp.AsyncExecutor;
import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.InternalOutputBuffer;
import com.sun.grizzly.tcp.http11.OutputFilter;
import com.sun.grizzly.util.SelectionKeyActionAttachment;
import com.sun.grizzly.util.http.MimeHeaders;
import com.sun.grizzly.websockets.BaseServerWebSocket;
import com.sun.grizzly.websockets.ClientHandShake;
import com.sun.grizzly.websockets.ServerHandShake;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketApplication;
import com.sun.grizzly.websockets.WebSocketOutputFilter;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocketEngine {
    private static final Logger logger = Logger.getLogger("websocket");
    private static final WebSocketEngine engine = new WebSocketEngine();
    private final Map<String, WebSocketApplication> applications = new HashMap<String, WebSocketApplication>();
    static final int INITIAL_BUFFER_SIZE = 8192;

    public static WebSocketEngine getEngine() {
        return engine;
    }

    public WebSocketApplication getApplication(String uri) {
        return this.applications.get(uri);
    }

    public boolean handle(AsyncExecutor asyncExecutor) {
        WebSocket socket = null;
        try {
            Request request = asyncExecutor.getProcessorTask().getRequest();
            if ("WebSocket".equals(request.getHeader("Upgrade"))) {
                socket = this.getWebSocket(asyncExecutor, request);
                ((HttpWorkerThread)Thread.currentThread()).getAttachment().setTimeout(Long.MIN_VALUE);
            }
        }
        catch (IOException e) {
            return false;
        }
        return socket != null;
    }

    protected WebSocket getWebSocket(AsyncExecutor asyncExecutor, Request request) throws IOException {
        WebSocketApplication app = WebSocketEngine.getEngine().getApplication(request.requestURI().toString());
        BaseServerWebSocket socket = null;
        try {
            Response response = request.getResponse();
            this.handshake(request, response);
            ProcessorTask task = asyncExecutor.getProcessorTask();
            if (app != null) {
                socket = (BaseServerWebSocket)app.createSocket(request, response);
                app.onConnect(socket);
                SelectionKey key = task.getSelectionKey();
                this.register(asyncExecutor, socket, key);
                this.enableRead(task, key);
            } else {
                ((InternalOutputBuffer)response.getOutputBuffer()).addActiveFilter((OutputFilter)new WebSocketOutputFilter());
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return socket;
    }

    private void register(final AsyncExecutor asyncExecutor, final BaseServerWebSocket socket, SelectionKey selectionKey) {
        selectionKey.attach(new SelectionKeyActionAttachment(){

            public void process(SelectionKey key) {
                if (key.isValid() && key.isReadable()) {
                    ProcessorTask task = asyncExecutor.getProcessorTask();
                    try {
                        socket.doRead();
                    }
                    catch (IOException e) {
                        task.setAptCancelKey(true);
                        task.terminateProcess();
                        logger.log(Level.INFO, e.getMessage(), e);
                    }
                    WebSocketEngine.this.enableRead(task, key);
                }
            }

            public void postProcess(SelectionKey selectionKey1) {
            }
        });
    }

    final void enableRead(ProcessorTask task, SelectionKey key) {
        task.getSelectorHandler().register(key, 1);
    }

    private void handshake(Request request, Response response) throws IOException {
        MimeHeaders headers = request.getMimeHeaders();
        ClientHandShake client = new ClientHandShake(headers, false, request.requestURI().toString());
        ServerHandShake server = new ServerHandShake(headers, client);
        server.prepare(response);
        response.flush();
    }

    public void register(String name, WebSocketApplication app) {
        this.applications.put(name, app);
    }
}

