/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.client.acc.AppClientInfo;
import org.glassfish.appclient.client.acc.ClassFileAppClientInfo;
import org.glassfish.appclient.client.acc.NestedAppClientInfo;
import org.glassfish.appclient.client.acc.StandAloneAppClientInfo;
import org.glassfish.appclient.client.acc.UserError;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.SAXParseException;

@Service
public class AppClientInfoFactory {
    @Inject
    private static ArchivistFactory archivistFactory;
    protected static final StringManager localStrings;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppClientInfo buildAppClientInfo(boolean isJWS, Logger logger, File locationFile, String mainClassFromCommandLine, String displayNameFromCommandLine, String classFileFromCommandLine, URL[] persistenceURLs) throws IOException, SAXParseException, ClassNotFoundException, URISyntaxException, AnnotationProcessorException, Exception, UserError {
        void var7_11;
        Object var7_7 = null;
        if (classFileFromCommandLine != null) {
            ClassFileAppClientInfo classFileAppClientInfo = new ClassFileAppClientInfo(isJWS, logger, mainClassFromCommandLine, classFileFromCommandLine);
        } else {
            ArchiveFactory archiveFactory = new ArchiveFactory();
            ReadableArchive archive = archiveFactory.openArchive(locationFile);
            Archivist archivist = AppClientInfoFactory.prepareArchivist(archive);
            if (archivist == null) throw new UserError(localStrings.getString("appclient.invalidArchive", (Object)locationFile.getAbsolutePath()));
            if (archivist instanceof AppClientArchivist) {
                StandAloneAppClientInfo standAloneAppClientInfo = new StandAloneAppClientInfo(isJWS, logger, archive, mainClassFromCommandLine);
            } else {
                if (!(archivist instanceof ApplicationArchivist)) throw new UserError(localStrings.getString("appclient.unexpectedArchive", (Object)locationFile.getAbsolutePath()));
                NestedAppClientInfo nestedAppClientInfo = new NestedAppClientInfo(isJWS, logger, locationFile, archivist, mainClassFromCommandLine, displayNameFromCommandLine);
            }
        }
        var7_11.completeInit();
        if (!logger.isLoggable(Level.FINE)) return var7_11;
        logger.fine(var7_11.toString());
        return var7_11;
    }

    private static Archivist prepareArchivist(ReadableArchive archive) throws IOException {
        Archivist result = null;
        result = archivistFactory.getArchivist(archive, Thread.currentThread().getContextClassLoader());
        return result;
    }

    static {
        localStrings = StringManager.getManager(AppClientInfoFactory.class);
    }
}

