/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.jws.boot;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarFile;
import org.glassfish.appclient.client.jws.boot.ClassPathManager;

public class ClassPathManager16
extends ClassPathManager {
    private Class jnlpClassLoaderClass;
    private Method getJarFileMethod;

    protected ClassPathManager16(ClassLoader loader, boolean keepJWSClassLoader) {
        super(loader, keepJWSClassLoader);
        try {
            this.prepareIntrospectionInfo();
        }
        catch (Throwable thr) {
            throw new RuntimeException(thr);
        }
    }

    private void prepareIntrospectionInfo() throws ClassNotFoundException, NoSuchMethodException {
        this.jnlpClassLoaderClass = this.getJNLPClassLoader().loadClass("com.sun.jnlp.JNLPClassLoader");
        this.getJarFileMethod = this.jnlpClassLoaderClass.getDeclaredMethod("getJarFile", URL.class);
        this.getJarFileMethod.setAccessible(true);
    }

    public ClassLoader getParentClassLoader() {
        return this.keepJWSClassLoader() ? this.getJnlpClassLoader() : this.getJNLPClassLoader().getParent();
    }

    public File findContainingJar(URL resourceURL) throws IllegalArgumentException, URISyntaxException, MalformedURLException, IllegalAccessException, InvocationTargetException {
        File result = null;
        if (resourceURL != null) {
            URI resourceURI = resourceURL.toURI();
            String ssp = resourceURI.getSchemeSpecificPart();
            String jarOnlySSP = ssp.substring(0, ssp.indexOf(33));
            URL jarOnlyURL = new URL(jarOnlySSP).toURI().toURL();
            JarFile jarFile = (JarFile)this.getJarFileMethod.invoke((Object)this.getJNLPClassLoader(), jarOnlyURL);
            if (jarFile == null) {
                throw new IllegalArgumentException(resourceURL.toExternalForm());
            }
            result = new File(jarFile.getName());
        }
        return result;
    }
}

