/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.annotations.OrderCorrectionType;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.DirectColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataHelper;
import org.eclipse.persistence.mappings.CollectionMapping;

public class OrderColumnMetadata
extends DirectColumnMetadata {
    private static final String _ORDER = "_ORDER";
    private String m_correctionType;

    public OrderColumnMetadata() {
        super("<order-column>");
    }

    public OrderColumnMetadata(MetadataAnnotation orderColumn, MetadataAccessibleObject accessibleObject, String correctionType) {
        super(orderColumn, accessibleObject);
        this.m_correctionType = correctionType;
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof OrderColumnMetadata) {
            OrderColumnMetadata orderColumn = (OrderColumnMetadata)objectToCompare;
            return this.valuesMatch(this.m_correctionType, orderColumn.getCorrectionType());
        }
        return false;
    }

    public String getCorrectionType() {
        return this.m_correctionType;
    }

    public void process(CollectionMapping mapping, MetadataDescriptor descriptor) {
        if (((MetadataAnnotatedElement)this.getAccessibleObject()).getRawClass(descriptor).isList()) {
            DatabaseField orderField = this.getDatabaseField();
            boolean useDelimitedIdentifier = descriptor.getProject() != null ? descriptor.getProject().useDelimitedIdentifier() : false;
            orderField.setName(MetadataHelper.getName(this.getName(), mapping.getAttributeName() + _ORDER, "metadata_default_order_column", descriptor.getLogger(), this.getAccessibleObject().toString()), Helper.getDefaultStartDatabaseDelimiter(), Helper.getDefaultEndDatabaseDelimiter());
            if (useDelimitedIdentifier) {
                orderField.setUseDelimiters(useDelimitedIdentifier);
            } else if (descriptor.getProject().getShouldForceFieldNamesToUpperCase() && !orderField.shouldUseDelimiters()) {
                orderField.setName(orderField.getName().toUpperCase());
            }
            mapping.setListOrderField(orderField);
            if (this.m_correctionType != null) {
                OrderCorrectionType[] values = OrderCorrectionType.values();
                for (int i = 0; i < values.length; ++i) {
                    if (!values[i].name().equals(this.m_correctionType)) continue;
                    mapping.setOrderCorrectionType(values[i]);
                    break;
                }
            }
        } else {
            throw ValidationException.invalidAttributeTypeForOrderColumn((String)mapping.getAttributeName(), (Object)descriptor.getJavaClass());
        }
    }

    public void setCorrectionType(String correctionType) {
        this.m_correctionType = correctionType;
    }
}

