/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;

public class QueryRedirectorsMetadata
extends ORMetadata {
    protected String defaultQueryRedirector;
    protected String defaultReadAllQueryRedirector;
    protected String defaultReadObjectQueryRedirector;
    protected String defaultReportQueryRedirector;
    protected String defaultUpdateObjectQueryRedirector;
    protected String defaultInsertObjectQueryRedirector;
    protected String defaultDeleteObjectQueryRedirector;

    public QueryRedirectorsMetadata() {
        super("<query-redirectors>");
    }

    public QueryRedirectorsMetadata(MetadataAnnotation redirectors, MetadataAccessibleObject accessibleObject) {
        super(redirectors, accessibleObject);
        this.defaultQueryRedirector = (String)redirectors.getAttribute("allQueries");
        this.defaultReadAllQueryRedirector = (String)redirectors.getAttribute("readAll");
        this.defaultReadObjectQueryRedirector = (String)redirectors.getAttribute("readObject");
        this.defaultInsertObjectQueryRedirector = (String)redirectors.getAttribute("insert");
        this.defaultDeleteObjectQueryRedirector = (String)redirectors.getAttribute("delete");
        this.defaultUpdateObjectQueryRedirector = (String)redirectors.getAttribute("update");
        this.defaultReportQueryRedirector = (String)redirectors.getAttribute("report");
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof QueryRedirectorsMetadata) {
            QueryRedirectorsMetadata queryRedirectors = (QueryRedirectorsMetadata)objectToCompare;
            if (!this.valuesMatch(this.defaultQueryRedirector, queryRedirectors.getDefaultQueryRedirector())) {
                return false;
            }
            if (!this.valuesMatch(this.defaultReadAllQueryRedirector, queryRedirectors.defaultReadAllQueryRedirector)) {
                return false;
            }
            if (!this.valuesMatch(this.defaultReadObjectQueryRedirector, queryRedirectors.getDefaultReadObjectQueryRedirector())) {
                return false;
            }
            if (!this.valuesMatch(this.defaultReportQueryRedirector, queryRedirectors.getDefaultReportQueryRedirector())) {
                return false;
            }
            if (!this.valuesMatch(this.defaultUpdateObjectQueryRedirector, queryRedirectors.getDefaultUpdateObjectQueryRedirector())) {
                return false;
            }
            if (!this.valuesMatch(this.defaultInsertObjectQueryRedirector, queryRedirectors.getDefaultInsertObjectQueryRedirector())) {
                return false;
            }
            return this.valuesMatch(this.defaultDeleteObjectQueryRedirector, queryRedirectors.getDefaultDeleteObjectQueryRedirector());
        }
        return false;
    }

    public String getDefaultDeleteObjectQueryRedirector() {
        return this.defaultDeleteObjectQueryRedirector;
    }

    public String getDefaultInsertObjectQueryRedirector() {
        return this.defaultInsertObjectQueryRedirector;
    }

    public String getDefaultQueryRedirector() {
        return this.defaultQueryRedirector;
    }

    public String getDefaultReadAllQueryRedirector() {
        return this.defaultReadAllQueryRedirector;
    }

    public String getDefaultReadObjectQueryRedirector() {
        return this.defaultReadObjectQueryRedirector;
    }

    public String getDefaultReportQueryRedirector() {
        return this.defaultReportQueryRedirector;
    }

    public String getDefaultUpdateObjectQueryRedirector() {
        return this.defaultUpdateObjectQueryRedirector;
    }

    public void process(MetadataDescriptor descriptor, MetadataClass javaClass) {
        descriptor.setHasDefaultRedirectors();
        ClassDescriptor classDescriptor = descriptor.getClassDescriptor();
        if (!this.defaultQueryRedirector.equals(Void.TYPE.getName())) {
            classDescriptor.setDefaultQueryRedirectorClassName(this.defaultQueryRedirector);
        }
        if (!this.defaultReadAllQueryRedirector.equals(Void.TYPE.getName())) {
            classDescriptor.setDefaultReadAllQueryRedirectorClassName(this.defaultReadAllQueryRedirector);
        }
        if (!this.defaultReadObjectQueryRedirector.equals(Void.TYPE.getName())) {
            classDescriptor.setDefaultReadObjectQueryRedirectorClassName(this.defaultReadObjectQueryRedirector);
        }
        if (!this.defaultReportQueryRedirector.equals(Void.TYPE.getName())) {
            classDescriptor.setDefaultReportQueryRedirectorClassName(this.defaultReportQueryRedirector);
        }
        if (!this.defaultInsertObjectQueryRedirector.equals(Void.TYPE.getName())) {
            classDescriptor.setDefaultInsertObjectQueryRedirectorClassName(this.defaultInsertObjectQueryRedirector);
        }
        if (!this.defaultUpdateObjectQueryRedirector.equals(Void.TYPE.getName())) {
            classDescriptor.setDefaultUpdateObjectQueryRedirectorClassName(this.defaultUpdateObjectQueryRedirector);
        }
        if (!this.defaultDeleteObjectQueryRedirector.equals(Void.TYPE.getName())) {
            classDescriptor.setDefaultDeleteObjectQueryRedirectorClassName(this.defaultDeleteObjectQueryRedirector);
        }
    }

    public void setDefaultDeleteObjectQueryRedirector(String defaultDeleteObjectQueryRedirector) {
        this.defaultDeleteObjectQueryRedirector = defaultDeleteObjectQueryRedirector;
    }

    public void setDefaultInsertObjectQueryRedirector(String defaultInsertObjectQueryRedirector) {
        this.defaultInsertObjectQueryRedirector = defaultInsertObjectQueryRedirector;
    }

    public void setDefaultQueryRedirector(String defaultQueryRedirector) {
        this.defaultQueryRedirector = defaultQueryRedirector;
    }

    public void setDefaultReadAllQueryRedirector(String defaultReadAllQueryRedirector) {
        this.defaultReadAllQueryRedirector = defaultReadAllQueryRedirector;
    }

    public void setDefaultReadObjectQueryRedirector(String defaultReadObjectQueryRedirector) {
        this.defaultReadObjectQueryRedirector = defaultReadObjectQueryRedirector;
    }

    public void setDefaultReportQueryRedirector(String defaultReportQueryRedirector) {
        this.defaultReportQueryRedirector = defaultReportQueryRedirector;
    }

    public void setDefaultUpdateObjectQueryRedirector(String defaultUpdateObjectQueryRedirector) {
        this.defaultUpdateObjectQueryRedirector = defaultUpdateObjectQueryRedirector;
    }
}

