/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade;

import com.sun.enterprise.tools.upgrade.common.ArgsParser;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DomainsProcessor;
import com.sun.enterprise.tools.upgrade.common.GUICmdLineInput;
import com.sun.enterprise.tools.upgrade.common.HarnessException;
import com.sun.enterprise.tools.upgrade.common.InteractiveInputImpl;
import com.sun.enterprise.tools.upgrade.common.TargetAppSrvObj;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_V;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_c;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_console;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_h;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_help;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_m;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_masterpassword;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_version;
import com.sun.enterprise.tools.upgrade.common.arguments.ArgumentHandler;
import com.sun.enterprise.tools.upgrade.gui.MainFrame;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.util.i18n.StringManager;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeToolMain {
    private static final Logger logger = LogService.getLogger();
    private static final StringManager sm;
    private CommonInfoModel commonInfo = CommonInfoModel.getInstance();

    public UpgradeToolMain() {
        logger.log(Level.INFO, sm.getString("enterprise.tools.upgrade.start_upgrade_tool"));
        new ASenvPropertyReader();
        String rawTargetDomainRoot = System.getProperty("com.sun.aas.domainRoot");
        if (rawTargetDomainRoot == null) {
            rawTargetDomainRoot = "";
        }
        String targetDomainRoot = null;
        try {
            targetDomainRoot = new File(rawTargetDomainRoot).getCanonicalPath();
        }
        catch (IOException ioe) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("Will not create canonical path for target: %s", ioe.getLocalizedMessage()));
            }
            targetDomainRoot = new File(rawTargetDomainRoot).getAbsolutePath();
        }
        this.commonInfo.getTarget().setInstallDir(targetDomainRoot);
    }

    public void startGUI(String[] args) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, sm.getString("enterprise.tools.upgrade.start_upgrade_tool_gui"));
        }
        if (args.length > 0) {
            GUICmdLineInput guiIn = new GUICmdLineInput();
            guiIn.processArguments(guiIn.parse(args));
        }
        final UpgradeToolMain thisToolMain = this;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainFrame(thisToolMain).setVisible(true);
            }
        });
    }

    public void startCLI(String[] args) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, sm.getString("enterprise.tools.upgrade.start_upgrade_tool_cli"));
        }
        try {
            this.cliParse(args);
        }
        catch (Exception e) {
            logger.log(Level.INFO, sm.getString("enterprise.tools.upgrade.unexpected_parsing"), e);
            System.exit(1);
        }
        this.upgrade();
    }

    private void cliParse(String[] args) {
        ArgsParser ap = new ArgsParser();
        ArrayList<ArgumentHandler> aList = ap.parse(args);
        InteractiveInputImpl tmpI = new InteractiveInputImpl();
        tmpI.processArguments(aList);
        if (logger.isLoggable(Level.FINE)) {
            this.printArgs(aList);
        }
    }

    private void printArgs(ArrayList<ArgumentHandler> aList) {
        StringBuilder sb = new StringBuilder();
        for (ArgumentHandler tmpAh : aList) {
            if (tmpAh instanceof ARG_m || tmpAh instanceof ARG_masterpassword) {
                sb.append("-" + tmpAh.getCmd() + " " + tmpAh.getRawParameter().replaceAll(".", "*"));
            } else if (tmpAh instanceof ARG_c || tmpAh instanceof ARG_console || tmpAh instanceof ARG_h || tmpAh instanceof ARG_help || tmpAh instanceof ARG_V || tmpAh instanceof ARG_version) {
                sb.append("-" + tmpAh.getCmd());
            } else {
                sb.append("-" + tmpAh.getCmd() + " " + tmpAh.getRawParameter());
            }
            sb.append(" ");
        }
        logger.fine("asupgrade " + sb.toString());
    }

    private void upgrade() {
        try {
            this.commonInfo.setupTasks();
            try {
                DomainsProcessor dProcessor = new DomainsProcessor(this.commonInfo);
                TargetAppSrvObj _target = this.commonInfo.getTarget();
                dProcessor.copyUserLibFiles();
                int exitValue = dProcessor.startDomain(_target.getDomainName());
                if (exitValue != 0) {
                    logger.warning(sm.getString("enterprise.tools.upgrade.processExitValue", exitValue));
                } else {
                    logger.info(sm.getString("enterprise.tools.upgrade.done"));
                }
            }
            catch (HarnessException he) {
                logger.log(Level.SEVERE, sm.getString("enterprise.tools.upgrade.generalException", he));
            }
            logger.log(Level.FINE, sm.getString("enterprise.tools.upgrade.deletingTempPasswordFiles"));
            this.commonInfo.getSource().getDomainCredentials().deletePasswordFile();
        }
        catch (Exception e) {
            logger.log(Level.INFO, e.getMessage());
        }
    }

    public static void main(String[] args) {
        UpgradeToolMain main = new UpgradeToolMain();
        boolean isCLIcmd = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-c") || args[i].equals("--console")) {
                isCLIcmd = true;
            }
            if (!args[i].equals("-h") && !args[i].equals("--help")) continue;
            ARG_help tmpH = new ARG_help();
            tmpH.exec();
            System.exit(0);
        }
        if (isCLIcmd) {
            main.startCLI(args);
            System.exit(0);
        } else {
            main.startGUI(args);
        }
    }

    public void performUpgrade() {
        this.upgrade();
    }

    static {
        String domainRoot = System.getProperty("com.sun.aas.domainRoot");
        if (domainRoot == null) {
            System.err.println("Configuration Error: AS_DEFS_DOMAINS_PATH is not set.");
            System.exit(1);
        }
        sm = StringManager.getManager(UpgradeToolMain.class);
    }
}

