/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.cluster.CreateLocalInstanceFilesystemCommand;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.ArrayList;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-local-instance")
@Scoped(value=PerLookup.class)
public final class CreateLocalInstanceCommand
extends CreateLocalInstanceFilesystemCommand {
    @Param(name="filesystemonly", optional=true, defaultValue="false")
    private boolean filesystemOnly = false;
    @Param(name="config", optional=true)
    private String configName;
    @Param(name="cluster", optional=true)
    private String clusterName;
    @Param(name="systemproperties", optional=true, separator=58)
    private String systemProperties;
    private static final LocalStringsImpl strings = new LocalStringsImpl(CreateLocalInstanceCommand.class);

    protected void validate() throws CommandException, CommandValidationException {
        if (this.configName != null && this.clusterName != null) {
            throw new CommandValidationException(strings.get("ConfigClusterConflict"));
        }
        super.validate();
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        if (!this.filesystemOnly) {
            this.registerToDAS();
        }
        return super.executeCommand();
    }

    private int registerToDAS() throws CommandException {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(0, "create-instance");
        if (this.clusterName != null) {
            argsList.add("--cluster");
            argsList.add(this.clusterName);
        }
        if (this.configName != null) {
            argsList.add("--config");
            argsList.add(this.configName);
        }
        if (this.nodeAgent != null) {
            argsList.add("--nodeagent");
            argsList.add(this.nodeAgent);
        }
        if (this.systemProperties != null) {
            argsList.add("--systemproperties");
            argsList.add(this.systemProperties);
        }
        argsList.add(this.instanceName);
        String[] argsArray = new String[argsList.size()];
        argsArray = argsList.toArray(argsArray);
        Environment currEnv = new Environment();
        ProgramOptions po = new ProgramOptions(currEnv);
        RemoteCommand rc = new RemoteCommand("create-instance", po, currEnv);
        return rc.execute(argsArray);
    }
}

