/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby.monitor;

import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.StringStatistic;
import org.glassfish.external.statistics.annotations.Reset;
import org.glassfish.external.statistics.impl.StringStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="jruby-application-mon", group="monitoring")
@ManagedObject
@Description(value="JRuby Application Statistics")
public class JRubyApplicationStatsProvider {
    private final Logger logger = Logger.getLogger(JRubyApplicationStatsProvider.class.getName());
    private final StringStatisticImpl appName = new StringStatisticImpl("ApplicationName", null, "Ruby application name");
    private final StringStatisticImpl framework = new StringStatisticImpl("RubyApplicationFramework", null, "Ruby application Framework");
    private final StringStatisticImpl environment = new StringStatisticImpl("ApplicationEnvironment", null, "Ruby application environment");
    private final StringStatisticImpl jrubyVersion = new StringStatisticImpl("JRubyVersion", null, "JRuby version");
    private final StringStatisticImpl contextPath = new StringStatisticImpl("ContextPath", null, "Context path of Ruby application");

    public JRubyApplicationStatsProvider(String appName, String contextPath) {
        this.contextPath.setCurrent(contextPath);
        this.appName.setCurrent(appName);
    }

    @ProbeListener(value="glassfish:jruby:jruby-container:jrubyModuleStartedEvent")
    public void jrubyModuleStartedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="applicationType") String applicationType, @ProbeParam(value="environment") String environment, @ProbeParam(value="jrubyVersion") String jrubyVersion) {
        if (appName == null) {
            this.logger.warning("appName is null in jrubyModuleStartedEvent! Looks like the event is not triggered properly, ignoring this monitoring event.");
        } else if (this.appName.getCurrent().equals(appName)) {
            this.logger.fine("JRubyApplicationStatsProvider:jrubyModuleStartedEvent invoked");
            this.appName.setCurrent(appName);
            this.framework.setCurrent(applicationType);
            this.environment.setCurrent(environment);
            this.jrubyVersion.setCurrent(jrubyVersion);
        }
    }

    @ProbeListener(value="glassfish:jruby:jruby-container:jrubyModuleStoppedEvent")
    public void jrubyModuleStoppedEvent(@ProbeParam(value="appName") String appName) {
        if (appName == null) {
            this.logger.warning("appName is null in jrubyModuleStoppedEvent! Looks like the event is not triggered properly, ignoring this monitoring event.");
            return;
        }
        this.logger.fine("JRubyApplicationStatsProvider:jrubyModuleStoppedEvent invoked");
        if (appName.equals(this.appName.getCurrent())) {
            this.appName.reset();
            this.framework.reset();
            this.environment.reset();
            this.jrubyVersion.reset();
            this.contextPath.reset();
        }
    }

    @ManagedAttribute(id="appname")
    @Description(value="Ruby application name")
    public StringStatistic getAppName() {
        return this.appName;
    }

    @ManagedAttribute(id="contextpath")
    @Description(value="Application context-path")
    public StringStatistic getContextPath() {
        return this.contextPath;
    }

    @ManagedAttribute(id="rubyframework")
    public StringStatistic getRubyFramework() {
        return this.framework;
    }

    @ManagedAttribute(id="environment")
    public StringStatistic getEnvironment() {
        return this.environment;
    }

    @ManagedAttribute(id="jrubyversion")
    public StringStatistic getJrubyVersion() {
        return this.jrubyVersion;
    }

    @Reset
    public void reset() {
    }
}

