/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.osgijavaeebase.JarHelper;
import org.glassfish.osgiweb.SunWebXmlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WARManifestProcessor {
    private static Logger logger = Logger.getLogger(WARManifestProcessor.class.getPackage().getName());
    private static final String DEFAULT_MAN_VERSION = "2";
    private static final String DEFAULT_IMPORT_PACKAGE = "javax.servlet; javax.servlet.http; version=2.5, javax.servlet.jsp; javax.servlet.jsp.tagext;javax.el; javax.servlet.jsp.el; version=2.1";
    private static final String DEFAULT_BUNDLE_CP = "WEB-INF/classes/";
    static AtomicInteger id = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest processManifest(URL url) throws IOException {
        final JarInputStream jis = new JarInputStream(url.openStream());
        try {
            final ArrayList<String> libs = new ArrayList<String>();
            final StringBuilder contextRootFromSunDD = new StringBuilder();
            JarHelper.accept(jis, new JarHelper.Visitor(){

                public void visit(JarEntry je) {
                    String contextRoot1;
                    String jarName;
                    String name = je.getName();
                    String LIB_DIR = "WEB-INF/lib/";
                    String JAR_EXT = ".jar";
                    if (!je.isDirectory() && name.startsWith(LIB_DIR) && name.endsWith(JAR_EXT) && !(jarName = name.substring(LIB_DIR.length())).contains("/")) {
                        libs.add(name);
                    }
                    String GF_WEB_XML = "WEB-INF/glassfish-web.xml";
                    String SUN_WEB_XML = "WEB-INF/sun-web.xml";
                    if (!je.isDirectory() && je.getName().equals(GF_WEB_XML)) {
                        String contextRoot12 = WARManifestProcessor.parseContextRoot(jis);
                        if (contextRoot12 != null) {
                            contextRootFromSunDD.append(contextRoot12);
                        }
                    } else if (!je.isDirectory() && je.getName().equals(SUN_WEB_XML) && (contextRoot1 = WARManifestProcessor.parseContextRoot(jis)) != null) {
                        contextRootFromSunDD.append(contextRoot1);
                    }
                }
            });
            Properties queryParams = WARManifestProcessor.readQueryParams(url);
            Manifest oldManifest = jis.getManifest();
            Manifest newManifest = new Manifest(oldManifest);
            Attributes attrs = newManifest.getMainAttributes();
            String defaultContextRoot = contextRootFromSunDD.length() == 0 ? WARManifestProcessor.generateContextRoot(url) : contextRootFromSunDD.toString();
            WARManifestProcessor.process(queryParams, attrs, "Web-ContextPath", defaultContextRoot);
            WARManifestProcessor.process(queryParams, attrs, "Bundle-ManifestVersion", DEFAULT_MAN_VERSION);
            String actualContextRoot = attrs.getValue("Web-ContextPath");
            String defaultSymName = actualContextRoot.startsWith("/") ? actualContextRoot.substring(1) : actualContextRoot;
            WARManifestProcessor.process(queryParams, attrs, "Bundle-SymbolicName", defaultSymName);
            WARManifestProcessor.process(queryParams, attrs, "Bundle-Version", null);
            String cp = WARManifestProcessor.convertToCP(libs);
            cp = cp.length() > 0 ? DEFAULT_BUNDLE_CP.concat(",").concat(cp) : DEFAULT_BUNDLE_CP;
            WARManifestProcessor.process(queryParams, attrs, "Bundle-ClassPath", cp);
            WARManifestProcessor.process(queryParams, attrs, "Web-JSPExtractLocation", null);
            WARManifestProcessor.process(queryParams, attrs, "Import-Package", DEFAULT_IMPORT_PACKAGE);
            WARManifestProcessor.process(queryParams, attrs, "Export-Package", null);
            attrs.putValue("DynamicImport-Package", "*");
            Manifest manifest = newManifest;
            return manifest;
        }
        finally {
            jis.close();
        }
    }

    private static String generateContextRoot(URL url) {
        String file = url.getPath();
        if (file.endsWith("/")) {
            file = file.substring(0, file.length());
        }
        int slash = file.lastIndexOf("/");
        int dot = file.lastIndexOf(".");
        String contextRoot = slash != -1 ? (dot != -1 && dot > slash ? file.substring(slash, dot) : file.substring(slash)) : "/osgiwar" + id.getAndIncrement();
        return contextRoot;
    }

    private static String parseContextRoot(JarInputStream jis) {
        try {
            SunWebXmlParser parser = new SunWebXmlParser(jis);
            return parser.getContextRoot();
        }
        catch (Exception e) {
            logger.logp(Level.WARNING, "WARManifestProcessor", "getContextRoot", "e = {0}", new Object[]{e});
            return null;
        }
    }

    private static String convertToCP(List<String> jars) {
        StringBuilder cp = new StringBuilder();
        for (int i = 0; i < jars.size(); ++i) {
            cp.append(jars.get(i));
            if (i >= jars.size() - 1) continue;
            cp.append(",");
        }
        return cp.toString();
    }

    private static Properties readQueryParams(URL url) {
        Properties queryParams = new Properties();
        String query = url.getQuery();
        if (query != null) {
            StringTokenizer st = new StringTokenizer(query, "&");
            while (st.hasMoreTokens()) {
                String next = st.nextToken();
                int eq = next.indexOf("=");
                String name = next;
                String value = null;
                if (eq != -1) {
                    name = next.substring(0, eq);
                    if (eq + 1 < next.length()) {
                        value = next.substring(eq + 1);
                    }
                }
                queryParams.put(name, value);
            }
            logger.logp(Level.INFO, "WARManifestProcessor", "readQueryParams", "queryParams = {0}", new Object[]{queryParams});
        }
        return queryParams;
    }

    private static void process(Properties deployerOptions, Attributes developerOptions, String key, String defaultOption) {
        String deployerOption = deployerOptions.getProperty(key);
        String developerOption = developerOptions.getValue(key);
        String finalOption = defaultOption;
        if (deployerOption != null) {
            finalOption = deployerOption;
        } else if (developerOption != null) {
            finalOption = developerOption;
        }
        if (finalOption != developerOption) {
            developerOptions.putValue(key, finalOption);
        }
    }
}

