/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.Transport;
import com.sun.grizzly.config.dom.Transports;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-transport")
@Scoped(value=PerLookup.class)
@I18n(value="create.transport")
public class CreateTransport
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateTransport.class);
    @Param(name="transportname", primary=true)
    String transportName;
    @Param(name="acceptorthreads", optional=true, defaultValue="-1")
    String acceptorThreads;
    @Param(name="buffersizebytes", optional=true, defaultValue="8192")
    String bufferSizeBytes;
    @Param(name="bytebuffertype", optional=true, defaultValue="HEAP")
    String byteBufferType;
    @Param(name="classname", optional=true, defaultValue="com.sun.grizzly.TCPSelectorHandler")
    String className;
    @Param(name="displayconfiguration", optional=true, defaultValue="false")
    Boolean displayConfiguration;
    @Param(name="enablesnoop", optional=true, defaultValue="false")
    Boolean enableSnoop;
    @Param(name="idlekeytimeoutseconds", optional=true, defaultValue="30")
    String idleKeyTimeoutSeconds;
    @Param(name="maxconnectionscount", optional=true, defaultValue="4096")
    String maxConnectionsCount;
    @Param(name="readtimeoutmillis", optional=true, defaultValue="30000")
    String readTimeoutMillis;
    @Param(name="writetimeoutmillis", optional=true, defaultValue="30000")
    String writeTimeoutMillis;
    @Param(name="selectionkeyhandler", optional=true)
    String selectionKeyHandler;
    @Param(name="selectorpolltimeoutmillis", optional=true, defaultValue="1000")
    String selectorPollTimeoutMillis;
    @Param(name="tcpnodelay", optional=true, defaultValue="false")
    Boolean tcpNoDelay;
    @Inject(name="default-instance-name")
    Config config;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        Transports transports = networkConfig.getTransports();
        for (Transport transport : transports.getTransport()) {
            if (this.transportName == null || !this.transportName.equalsIgnoreCase(transport.getName())) continue;
            report.setMessage(localStrings.getLocalString("create.transport.fail.duplicate", "{0} transport already exists. Cannot add duplicate transport"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Transports>(){

                @Override
                public Object run(Transports param) throws PropertyVetoException, TransactionFailure {
                    boolean docrootAdded = false;
                    boolean accessLogAdded = false;
                    Transport newTransport = (Transport)param.createChild(Transport.class);
                    newTransport.setName(CreateTransport.this.transportName);
                    newTransport.setAcceptorThreads(CreateTransport.this.acceptorThreads);
                    newTransport.setBufferSizeBytes(CreateTransport.this.bufferSizeBytes);
                    newTransport.setByteBufferType(CreateTransport.this.byteBufferType);
                    newTransport.setClassname(CreateTransport.this.className);
                    newTransport.setDisplayConfiguration(CreateTransport.this.displayConfiguration.toString());
                    newTransport.setEnableSnoop(CreateTransport.this.enableSnoop.toString());
                    newTransport.setIdleKeyTimeoutSeconds(CreateTransport.this.idleKeyTimeoutSeconds);
                    newTransport.setMaxConnectionsCount(CreateTransport.this.maxConnectionsCount);
                    newTransport.setName(CreateTransport.this.transportName);
                    newTransport.setReadTimeoutMillis(CreateTransport.this.readTimeoutMillis);
                    newTransport.setSelectionKeyHandler(CreateTransport.this.selectionKeyHandler);
                    newTransport.setSelectorPollTimeoutMillis(CreateTransport.this.selectorPollTimeoutMillis);
                    newTransport.setWriteTimeoutMillis(CreateTransport.this.writeTimeoutMillis);
                    newTransport.setTcpNoDelay(CreateTransport.this.tcpNoDelay.toString());
                    param.getTransport().add(newTransport);
                    return newTransport;
                }
            }, transports);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.transport.fail", "Failed to create transport {0} ", new Object[]{this.transportName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

