/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding.fast;

import com.sun.corba.ee.impl.encoding.fast.ClassAnalyzer;
import com.sun.corba.ee.impl.encoding.fast.ClassMarshaler;
import com.sun.corba.ee.impl.encoding.fast.LookupTable;
import com.sun.corba.ee.impl.io.ObjectStreamClass;
import com.sun.corba.ee.impl.io.ObjectStreamField;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import sun.corba.Bridge;

public class ClassAnalyzerImpl
implements ClassAnalyzer {
    private static final Bridge bridge = AccessController.doPrivileged(new PrivilegedAction<Bridge>(){

        @Override
        public Bridge run() {
            return Bridge.get();
        }
    });
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static final ObjectStreamField[] serialPersistentFields = NO_FIELDS;
    private Class cl;
    private String name;
    private char[] nameChar;
    private volatile Long suid = 0L;
    private boolean isProxy;
    private boolean isEnum;
    private boolean serializable;
    private boolean externalizable;
    private ObjectStreamField[] fields;
    private Constructor cons;
    private Method writeObjectMethod;
    private Method readObjectMethod;
    private Method readObjectNoDataMethod;
    private Method writeReplaceMethod;
    private Method readResolveMethod;
    private ClassAnalyzer superDesc;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public char[] getNameAsCharArray() {
        return this.nameChar;
    }

    @Override
    public Class<?> forClass() {
        return this.cl;
    }

    @Override
    public ObjectStreamField[] getFields() {
        return this.getFields(true);
    }

    public ObjectStreamField getField(String name) {
        return this.getField(name, null);
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public ClassAnalyzer getSuperClassAnalyzer() {
        return this.superDesc;
    }

    public ClassAnalyzerImpl(LookupTable<Class, ClassMarshaler> lt, final Class cl) {
        this.cl = cl;
        this.name = cl.getName();
        this.nameChar = this.name.toCharArray();
        this.isProxy = Proxy.isProxyClass(cl);
        this.isEnum = Enum.class.isAssignableFrom(cl);
        this.serializable = Serializable.class.isAssignableFrom(cl);
        this.externalizable = Externalizable.class.isAssignableFrom(cl);
        Class superCl = cl.getSuperclass();
        if (superCl != null && superCl.isAssignableFrom(Serializable.class)) {
            this.superDesc = lt.lookup(null, superCl).getClassAnalyzer();
        }
        if (this.serializable) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (ClassAnalyzerImpl.this.isEnum) {
                        ClassAnalyzerImpl.this.suid = new Long(0L);
                        ClassAnalyzerImpl.access$202(ClassAnalyzerImpl.this, NO_FIELDS);
                        return null;
                    }
                    try {
                        ClassAnalyzerImpl.access$202(ClassAnalyzerImpl.this, ClassAnalyzerImpl.getSerialFields(cl));
                    }
                    catch (InvalidClassException invalidClassException) {
                        // empty catch block
                    }
                    if (ClassAnalyzerImpl.this.externalizable) {
                        ClassAnalyzerImpl.this.cons = ClassAnalyzerImpl.getExternalizableConstructor(cl);
                    } else {
                        ClassAnalyzerImpl.this.cons = ClassAnalyzerImpl.getSerializableConstructor(cl);
                        ClassAnalyzerImpl.this.writeObjectMethod = ClassAnalyzerImpl.getPrivateMethod(cl, "writeObject", new Class[]{ObjectOutputStream.class}, Void.TYPE);
                        ClassAnalyzerImpl.this.readObjectMethod = ClassAnalyzerImpl.getPrivateMethod(cl, "readObject", new Class[]{ObjectInputStream.class}, Void.TYPE);
                        ClassAnalyzerImpl.this.readObjectNoDataMethod = ClassAnalyzerImpl.getPrivateMethod(cl, "readObjectNoData", new Class[0], Void.TYPE);
                    }
                    ClassAnalyzerImpl.this.writeReplaceMethod = ClassAnalyzerImpl.getInheritableMethod(cl, "writeReplace", new Class[0], Object.class);
                    ClassAnalyzerImpl.this.readResolveMethod = ClassAnalyzerImpl.getInheritableMethod(cl, "readResolve", new Class[0], Object.class);
                    return null;
                }
            });
        } else {
            this.suid = new Long(0L);
            this.fields = NO_FIELDS;
        }
    }

    ObjectStreamField[] getFields(boolean copy) {
        return copy ? (ObjectStreamField[])this.fields.clone() : this.fields;
    }

    ObjectStreamField getField(String name, Class type) {
        for (int i = 0; i < this.fields.length; ++i) {
            ObjectStreamField f = this.fields[i];
            if (!f.getName().equals(name)) continue;
            if (type == null || type == Object.class && !f.isPrimitive()) {
                return f;
            }
            Class ftype = f.getType();
            if (ftype == null || !type.isAssignableFrom(ftype)) continue;
            return f;
        }
        return null;
    }

    @Override
    public boolean isProxy() {
        return this.isProxy;
    }

    @Override
    public boolean isEnum() {
        return this.isEnum;
    }

    @Override
    public boolean isExternalizable() {
        return this.externalizable;
    }

    @Override
    public boolean isSerializable() {
        return this.serializable;
    }

    @Override
    public boolean isInstantiable() {
        return this.cons != null;
    }

    @Override
    public boolean hasWriteObjectMethod() {
        return this.writeObjectMethod != null;
    }

    @Override
    public boolean hasReadObjectMethod() {
        return this.readObjectMethod != null;
    }

    @Override
    public boolean hasReadObjectNoDataMethod() {
        return this.readObjectNoDataMethod != null;
    }

    @Override
    public boolean hasWriteReplaceMethod() {
        return this.writeReplaceMethod != null;
    }

    @Override
    public boolean hasReadResolveMethod() {
        return this.readResolveMethod != null;
    }

    @Override
    public Object newInstance() throws InstantiationException, InvocationTargetException, UnsupportedOperationException {
        if (this.cons != null) {
            try {
                return this.cons.newInstance(new Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void invokeWriteObject(Object obj, ObjectOutputStream out) throws IOException, UnsupportedOperationException {
        if (this.writeObjectMethod != null) {
            try {
                this.writeObjectMethod.invoke(obj, out);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                ClassAnalyzerImpl.throwMiscException(th);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void invokeReadObject(Object obj, ObjectInputStream in) throws ClassNotFoundException, IOException, UnsupportedOperationException {
        if (this.readObjectMethod != null) {
            try {
                this.readObjectMethod.invoke(obj, in);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (th instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)th;
                }
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                ClassAnalyzerImpl.throwMiscException(th);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void invokeReadObjectNoData(Object obj) throws IOException, UnsupportedOperationException {
        if (this.readObjectNoDataMethod != null) {
            try {
                this.readObjectNoDataMethod.invoke(obj, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (th instanceof ObjectStreamException) {
                    throw (ObjectStreamException)th;
                }
                ClassAnalyzerImpl.throwMiscException(th);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Object invokeWriteReplace(Object obj) throws IOException, UnsupportedOperationException {
        if (this.writeReplaceMethod != null) {
            try {
                return this.writeReplaceMethod.invoke(obj, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (th instanceof ObjectStreamException) {
                    throw (ObjectStreamException)th;
                }
                ClassAnalyzerImpl.throwMiscException(th);
                throw new InternalError();
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object invokeReadResolve(Object obj) throws IOException, UnsupportedOperationException {
        if (this.readResolveMethod != null) {
            try {
                return this.readResolveMethod.invoke(obj, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (th instanceof ObjectStreamException) {
                    throw (ObjectStreamException)th;
                }
                ClassAnalyzerImpl.throwMiscException(th);
                throw new InternalError();
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        }
        throw new UnsupportedOperationException();
    }

    private static Constructor getExternalizableConstructor(Class cl) {
        try {
            Constructor cons = cl.getDeclaredConstructor(new Class[0]);
            cons.setAccessible(true);
            return (cons.getModifiers() & 1) != 0 ? cons : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static Constructor getSerializableConstructor(Class cl) {
        Class initCl = cl;
        while (Serializable.class.isAssignableFrom(initCl)) {
            if ((initCl = initCl.getSuperclass()) != null) continue;
            return null;
        }
        try {
            Constructor cons = initCl.getDeclaredConstructor(new Class[0]);
            int mods = cons.getModifiers();
            if ((mods & 2) != 0 || (mods & 5) == 0 && !ClassAnalyzerImpl.packageEquals(cl, initCl)) {
                return null;
            }
            cons = bridge.newConstructorForSerialization(cl, cons);
            cons.setAccessible(true);
            return cons;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static Method getInheritableMethod(Class cl, String name, Class[] argTypes, Class returnType) {
        Class defCl;
        Method meth = null;
        for (defCl = cl; defCl != null; defCl = defCl.getSuperclass()) {
            try {
                meth = defCl.getDeclaredMethod(name, argTypes);
                break;
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
        }
        if (meth == null || meth.getReturnType() != returnType) {
            return null;
        }
        meth.setAccessible(true);
        int mods = meth.getModifiers();
        if ((mods & 0x408) != 0) {
            return null;
        }
        if ((mods & 5) != 0) {
            return meth;
        }
        if ((mods & 2) != 0) {
            return cl == defCl ? meth : null;
        }
        return ClassAnalyzerImpl.packageEquals(cl, defCl) ? meth : null;
    }

    private static Method getPrivateMethod(Class cl, String name, Class[] argTypes, Class returnType) {
        try {
            Method meth = cl.getDeclaredMethod(name, argTypes);
            meth.setAccessible(true);
            int mods = meth.getModifiers();
            return meth.getReturnType() == returnType && (mods & 8) == 0 && (mods & 2) != 0 ? meth : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static boolean packageEquals(Class cl1, Class cl2) {
        return cl1.getClassLoader() == cl2.getClassLoader() && ClassAnalyzerImpl.getPackageName(cl1).equals(ClassAnalyzerImpl.getPackageName(cl2));
    }

    private static String getPackageName(Class cl) {
        String s = cl.getName();
        int i = s.lastIndexOf(91);
        if (i >= 0) {
            s = s.substring(i + 2);
        }
        return (i = s.lastIndexOf(46)) >= 0 ? s.substring(0, i) : "";
    }

    private static boolean classNamesEqual(String name1, String name2) {
        name1 = name1.substring(name1.lastIndexOf(46) + 1);
        name2 = name2.substring(name2.lastIndexOf(46) + 1);
        return name1.equals(name2);
    }

    private static void throwMiscException(Throwable th) throws IOException {
        if (th instanceof RuntimeException) {
            throw (RuntimeException)th;
        }
        if (th instanceof Error) {
            throw (Error)th;
        }
        IOException ex = new IOException("unexpected exception type");
        ex.initCause(th);
        throw ex;
    }

    private static ObjectStreamField[] getSerialFields(Class cl) throws InvalidClassException {
        Object[] fields;
        if (Serializable.class.isAssignableFrom(cl) && !Externalizable.class.isAssignableFrom(cl) && !Proxy.isProxyClass(cl) && !cl.isInterface()) {
            fields = ClassAnalyzerImpl.getDeclaredSerialFields(cl);
            if (fields == null) {
                fields = ClassAnalyzerImpl.getDefaultSerialFields(cl);
            }
            Arrays.sort(fields);
        } else {
            fields = NO_FIELDS;
        }
        return fields;
    }

    private static ObjectStreamField[] getDeclaredSerialFields(Class cl) throws InvalidClassException {
        ObjectStreamField[] serialPersistentFields = null;
        try {
            Field f = cl.getDeclaredField("serialPersistentFields");
            int mask = 26;
            if ((f.getModifiers() & mask) == mask) {
                f.setAccessible(true);
                java.io.ObjectStreamField[] javaSPF = (java.io.ObjectStreamField[])f.get(null);
                serialPersistentFields = ObjectStreamClass.translateFields(javaSPF);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (serialPersistentFields == null) {
            return null;
        }
        if (serialPersistentFields.length == 0) {
            return NO_FIELDS;
        }
        ObjectStreamField[] boundFields = new ObjectStreamField[serialPersistentFields.length];
        HashSet<String> fieldNames = new HashSet<String>(serialPersistentFields.length);
        for (int i = 0; i < serialPersistentFields.length; ++i) {
            ObjectStreamField spf = serialPersistentFields[i];
            String fname = spf.getName();
            if (fieldNames.contains(fname)) {
                throw new InvalidClassException("multiple serializable fields named " + fname);
            }
            fieldNames.add(fname);
            try {
                Field f = cl.getDeclaredField(fname);
                if (f.getType() == spf.getType() && (f.getModifiers() & 8) == 0) {
                    boundFields[i] = new ObjectStreamField(f);
                }
            }
            catch (NoSuchFieldException ex) {
                // empty catch block
            }
            if (boundFields[i] != null) continue;
            boundFields[i] = new ObjectStreamField(fname, spf.getType());
        }
        return boundFields;
    }

    private static ObjectStreamField[] getDefaultSerialFields(Class cl) {
        Field[] clFields = cl.getDeclaredFields();
        ArrayList<ObjectStreamField> list = new ArrayList<ObjectStreamField>();
        int mask = 136;
        for (int i = 0; i < clFields.length; ++i) {
            if ((clFields[i].getModifiers() & mask) != 0) continue;
            list.add(new ObjectStreamField(clFields[i]));
        }
        int size = list.size();
        return size == 0 ? NO_FIELDS : list.toArray(new ObjectStreamField[size]);
    }

    static /* synthetic */ ObjectStreamField[] access$202(ClassAnalyzerImpl x0, ObjectStreamField[] x1) {
        x0.fields = x1;
        return x1;
    }
}

