/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding.fast;

import com.sun.corba.ee.impl.encoding.fast.EmergeCode;

public final class EmergeCodeFactory {
    public static final int MIN_VALID_INT_CODE = 0;
    public static final int MAX_VALID_INT_CODE = 255;
    public static final int MESSAGE_CONTEXT_ID = 0;
    public static final int SESSION_CONTEXT_ID = 1;
    public static final int SENDER_IMMUTABLE_CONTEXT_ID = 2;
    public static final int FIRST_GLOBAL_CONTEXT_ID = 3;
    private static final int NUM_BITS_PER_BYTE = 8;
    private static final int NUM_CODE_BITS = 5;
    private static final int NUM_VALUE_BITS = 3;
    private static byte NO_ENCODED_VALUE;
    private static final EmergeCode[] emergeCodes;
    private static final byte BOOL_CODE;
    static final byte BOOL_TRUE;
    static final byte BOOL_FALSE;
    public static final int NUM_BITS_PER_VAR_OCTET = 7;
    public static final int MAX_VALUE_PER_VAR_OCTET = 128;
    public static final int VAR_OCTET_MASK = 127;
    public static final int MAX_OCTETS_FOR_VAR_OCTET = 9;
    private static final long MAX_FOR_1_OCTET = 128L;
    private static final long MAX_FOR_2_OCTET = 16384L;
    private static final long MAX_FOR_3_OCTET = 0x200000L;
    private static final long MAX_FOR_4_OCTET = 0x10000000L;
    private static final long MAX_FOR_5_OCTET = 0x800000000L;
    private static final long MAX_FOR_6_OCTET = 0x40000000000L;
    private static final long MAX_FOR_7_OCTET = 0x2000000000000L;
    private static final long MAX_FOR_8_OCTET = 0x100000000000000L;
    private static final long MAX_FOR_9_OCTET = Long.MIN_VALUE;

    private EmergeCodeFactory() {
    }

    private static int getCodeValue(EmergeCode.EmergeKind kind) {
        return kind.ordinal() << 3;
    }

    private static void initializeInvalid(EmergeCode.EmergeKind kind) {
        int cv = EmergeCodeFactory.getCodeValue(kind);
        for (int ctr = 0; ctr <= NO_ENCODED_VALUE; ++ctr) {
            EmergeCodeFactory.emergeCodes[cv + ctr] = new EmergeCodeInvalidImpl(cv + ctr);
        }
    }

    private static void initializeSimple(EmergeCode.EmergeKind kind, CodeClass cc) {
        int code = kind.ordinal() << 3;
        EmergeCodeFactory.emergeCodes[code] = new EmergeCodeSimpleImpl(code, kind, cc);
        for (int ctr = 1; ctr <= NO_ENCODED_VALUE; ++ctr) {
            EmergeCodeFactory.emergeCodes[code + ctr] = new EmergeCodeInvalidImpl(code + ctr);
        }
    }

    public static EmergeCode getByteCode(byte code) {
        byte index = code;
        if (code < 0) {
            code = (byte)(code + 256);
        }
        return emergeCodes[index];
    }

    public static EmergeCode getCode(int code) {
        return emergeCodes[code];
    }

    public static EmergeCode getCode(EmergeCode.EmergeKind kind, Object value) {
        int offset = NO_ENCODED_VALUE;
        int ordinal = 0;
        switch (kind) {
            case CHAR: {
                if (value != null) {
                    throw new IllegalArgumentException("CHAR cannot encode a value");
                }
                return emergeCodes[(kind.ordinal() << 3) + NO_ENCODED_VALUE];
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                offset = NO_ENCODED_VALUE;
                if (value != null) {
                    if (!(value instanceof Number)) {
                        throw new IllegalArgumentException("value must be a number");
                    }
                    int numValue = ((Number)value).intValue();
                    if (numValue >= -1 && numValue <= 5) {
                        offset = numValue + 1;
                    }
                }
                return emergeCodes[(kind.ordinal() << 3) + offset];
            }
            case FLOAT: 
            case DOUBLE: {
                offset = NO_ENCODED_VALUE;
                if (value != null) {
                    if (!(value instanceof Number)) {
                        throw new IllegalArgumentException("value must be a number");
                    }
                    float floatValue = ((Number)value).floatValue();
                    if ((double)floatValue == -1.0) {
                        offset = 0;
                    } else if ((double)floatValue == 0.0) {
                        offset = 1;
                    } else if ((double)floatValue == 1.0) {
                        offset = 2;
                    }
                }
                return emergeCodes[(kind.ordinal() << 3) + offset];
            }
            case BOOL: {
                if (!(value instanceof Boolean)) {
                    throw new IllegalArgumentException("BOOL requires Boolean value");
                }
                int index = EmergeCode.EmergeKind.BOOL.ordinal() << 3;
                if (((Boolean)value).booleanValue()) {
                    return emergeCodes[index + 1];
                }
                return emergeCodes[index];
            }
            case TUPLE: {
                if (!(value instanceof EmergeCode.TupleCode)) {
                    throw new IllegalArgumentException("TUPLE value must be a TupleCode");
                }
                ordinal = ((Enum)value).ordinal();
                return emergeCodes[(kind.ordinal() << 3) + ordinal];
            }
            case PART: {
                if (!(value instanceof EmergeCode.PartCode)) {
                    throw new IllegalArgumentException("PART value must be a PartCode");
                }
                ordinal = ((Enum)value).ordinal();
                return emergeCodes[(kind.ordinal() << 3) + ordinal];
            }
            case MSG: {
                if (!(value instanceof EmergeCode.MsgCode)) {
                    throw new IllegalArgumentException("MSG value must be a MsgCode");
                }
                ordinal = ((Enum)value).ordinal();
                return emergeCodes[(kind.ordinal() << 3) + ordinal];
            }
            case LABEL_MSG: {
                if (!(value instanceof EmergeCode.LabelMsg)) {
                    throw new IllegalArgumentException("LABEL value must be a LabelMsg");
                }
                ordinal = ((Enum)value).ordinal();
                return emergeCodes[(kind.ordinal() << 3) + ordinal];
            }
            case NULL: 
            case INDIR: 
            case BOOL_ARR: 
            case BYTE_ARR: 
            case CHAR_ARR: 
            case SHORT_ARR: 
            case INT_ARR: 
            case LONG_ARR: 
            case FLOAT_ARR: 
            case DOUBLE_ARR: 
            case REF_ARR: 
            case FLIST: 
            case CLOSE_SESSION: 
            case REJECT_REQUEST: 
            case REF: {
                if (value != null) {
                    throw new IllegalArgumentException("EmergeKind cannot have a value");
                }
                return emergeCodes[kind.ordinal() << 3];
            }
            case KIND_UNUSED_7: 
            case KIND_UNUSED_13: 
            case KIND_UNUSED_14: 
            case KIND_UNUSED_15: 
            case KIND_UNUSED_31: {
                throw new IllegalArgumentException((Object)((Object)kind) + " is an unused EmergeKind");
            }
        }
        return null;
    }

    public static int varOctetSize(long data) {
        if (data < 0L) {
            throw new IllegalArgumentException("var-octet cannot encode a negative long");
        }
        if (data < 128L) {
            return 1;
        }
        if (data < 16384L) {
            return 2;
        }
        if (data < 0x200000L) {
            return 3;
        }
        if (data < 0x10000000L) {
            return 4;
        }
        if (data < 0x800000000L) {
            return 5;
        }
        if (data < 0x40000000000L) {
            return 6;
        }
        if (data < 0x2000000000000L) {
            return 7;
        }
        if (data < 0x100000000000000L) {
            return 8;
        }
        if (data < Long.MIN_VALUE) {
            return 9;
        }
        throw new IllegalArgumentException("varOctetSize should not throw an exception!");
    }

    static {
        int ctr;
        int ctr2;
        int ctr3;
        int ctr4;
        int ctr5;
        NO_ENCODED_VALUE = (byte)7;
        emergeCodes = new EmergeCode[256];
        int start = EmergeCode.EmergeKind.BYTE.ordinal() << 3;
        for (ctr5 = 0; ctr5 < NO_ENCODED_VALUE; ++ctr5) {
            EmergeCodeFactory.emergeCodes[start + ctr5] = new EmergeCodeOptionalValueImpl(start + ctr5, EmergeCode.EmergeKind.BYTE, (byte)(ctr5 - 1));
        }
        EmergeCodeFactory.emergeCodes[start + EmergeCodeFactory.NO_ENCODED_VALUE] = new EmergeCodeOptionalValueImpl(start + NO_ENCODED_VALUE, EmergeCode.EmergeKind.BYTE, null);
        start = EmergeCode.EmergeKind.CHAR.ordinal() << 3;
        for (ctr5 = 0; ctr5 < NO_ENCODED_VALUE; ++ctr5) {
            EmergeCodeFactory.emergeCodes[start + ctr5] = new EmergeCodeInvalidImpl(start + ctr5);
        }
        EmergeCodeFactory.emergeCodes[start + EmergeCodeFactory.NO_ENCODED_VALUE] = new EmergeCodeSimpleImpl(start + NO_ENCODED_VALUE, EmergeCode.EmergeKind.CHAR, CodeClass.PRIMITIVE);
        start = EmergeCode.EmergeKind.SHORT.ordinal() << 3;
        for (ctr5 = 0; ctr5 < NO_ENCODED_VALUE; ++ctr5) {
            EmergeCodeFactory.emergeCodes[start + ctr5] = new EmergeCodeOptionalValueImpl(start + ctr5, EmergeCode.EmergeKind.SHORT, (byte)(ctr5 - 1));
        }
        EmergeCodeFactory.emergeCodes[start + EmergeCodeFactory.NO_ENCODED_VALUE] = new EmergeCodeOptionalValueImpl(start + NO_ENCODED_VALUE, EmergeCode.EmergeKind.SHORT, null);
        start = EmergeCode.EmergeKind.INT.ordinal() << 3;
        for (ctr5 = 0; ctr5 < NO_ENCODED_VALUE; ++ctr5) {
            EmergeCodeFactory.emergeCodes[start + ctr5] = new EmergeCodeOptionalValueImpl(start + ctr5, EmergeCode.EmergeKind.INT, (byte)(ctr5 - 1));
        }
        EmergeCodeFactory.emergeCodes[start + EmergeCodeFactory.NO_ENCODED_VALUE] = new EmergeCodeOptionalValueImpl(start + NO_ENCODED_VALUE, EmergeCode.EmergeKind.INT, null);
        start = EmergeCode.EmergeKind.LONG.ordinal() << 3;
        for (ctr5 = 0; ctr5 < NO_ENCODED_VALUE; ++ctr5) {
            EmergeCodeFactory.emergeCodes[start + ctr5] = new EmergeCodeOptionalValueImpl(start + ctr5, EmergeCode.EmergeKind.LONG, (byte)(ctr5 - 1));
        }
        EmergeCodeFactory.emergeCodes[start + EmergeCodeFactory.NO_ENCODED_VALUE] = new EmergeCodeOptionalValueImpl(start + NO_ENCODED_VALUE, EmergeCode.EmergeKind.LONG, null);
        start = EmergeCode.EmergeKind.FLOAT.ordinal() << 3;
        EmergeCodeFactory.emergeCodes[start + 0] = new EmergeCodeOptionalValueImpl(start + 0, EmergeCode.EmergeKind.FLOAT, Float.valueOf(-1.0f));
        EmergeCodeFactory.emergeCodes[start + 1] = new EmergeCodeOptionalValueImpl(start + 1, EmergeCode.EmergeKind.FLOAT, Float.valueOf(0.0f));
        EmergeCodeFactory.emergeCodes[start + 2] = new EmergeCodeOptionalValueImpl(start + 2, EmergeCode.EmergeKind.FLOAT, Float.valueOf(1.0f));
        for (ctr5 = 3; ctr5 < NO_ENCODED_VALUE; ++ctr5) {
            EmergeCodeFactory.emergeCodes[start + ctr5] = new EmergeCodeInvalidImpl(start + ctr5);
        }
        EmergeCodeFactory.emergeCodes[start + EmergeCodeFactory.NO_ENCODED_VALUE] = new EmergeCodeOptionalValueImpl(start + NO_ENCODED_VALUE, EmergeCode.EmergeKind.FLOAT);
        start = EmergeCode.EmergeKind.DOUBLE.ordinal() << 3;
        EmergeCodeFactory.emergeCodes[start + 0] = new EmergeCodeOptionalValueImpl(start + 0, EmergeCode.EmergeKind.DOUBLE, -1.0);
        EmergeCodeFactory.emergeCodes[start + 1] = new EmergeCodeOptionalValueImpl(start + 1, EmergeCode.EmergeKind.DOUBLE, 0.0);
        EmergeCodeFactory.emergeCodes[start + 2] = new EmergeCodeOptionalValueImpl(start + 2, EmergeCode.EmergeKind.DOUBLE, 1.0);
        for (ctr5 = 3; ctr5 < NO_ENCODED_VALUE; ++ctr5) {
            EmergeCodeFactory.emergeCodes[start + ctr5] = new EmergeCodeInvalidImpl(start + ctr5);
        }
        EmergeCodeFactory.emergeCodes[start + EmergeCodeFactory.NO_ENCODED_VALUE] = new EmergeCodeOptionalValueImpl(start + NO_ENCODED_VALUE, EmergeCode.EmergeKind.DOUBLE);
        start = EmergeCode.EmergeKind.BOOL.ordinal() << 3;
        EmergeCodeFactory.emergeCodes[start] = new EmergeCodeEncodedImpl(start, EmergeCode.EmergeKind.BOOL, false, CodeClass.PRIMITIVE);
        EmergeCodeFactory.emergeCodes[start + 1] = new EmergeCodeEncodedImpl(start + 1, EmergeCode.EmergeKind.BOOL, true, CodeClass.PRIMITIVE);
        for (ctr5 = 2; ctr5 <= NO_ENCODED_VALUE; ++ctr5) {
            EmergeCodeFactory.emergeCodes[start + ctr5] = new EmergeCodeInvalidImpl(start + ctr5);
        }
        start = EmergeCode.EmergeKind.TUPLE.ordinal() << 3;
        EmergeCode.TupleCode[] tupleEnums = EmergeCode.TupleCode.values();
        for (ctr4 = 0; ctr4 < tupleEnums.length; ++ctr4) {
            EmergeCodeFactory.emergeCodes[start + ctr4] = new EmergeCodeEncodedImpl(start + ctr4, EmergeCode.EmergeKind.TUPLE, (Object)tupleEnums[ctr4]);
        }
        for (ctr4 = tupleEnums.length; ctr4 <= NO_ENCODED_VALUE; ++ctr4) {
            EmergeCodeFactory.emergeCodes[start + ctr4] = new EmergeCodeInvalidImpl(start + ctr4);
        }
        start = EmergeCode.EmergeKind.PART.ordinal() << 3;
        EmergeCode.PartCode[] partEnums = EmergeCode.PartCode.values();
        for (ctr3 = 0; ctr3 < partEnums.length; ++ctr3) {
            EmergeCodeFactory.emergeCodes[start + ctr3] = new EmergeCodeEncodedImpl(start + ctr3, EmergeCode.EmergeKind.PART, (Object)partEnums[ctr3]);
        }
        for (ctr3 = partEnums.length; ctr3 <= NO_ENCODED_VALUE; ++ctr3) {
            EmergeCodeFactory.emergeCodes[start + ctr3] = new EmergeCodeInvalidImpl(start + ctr3);
        }
        start = EmergeCode.EmergeKind.MSG.ordinal() << 3;
        EmergeCode.MsgCode[] msgCodeEnums = EmergeCode.MsgCode.values();
        for (ctr2 = 0; ctr2 < msgCodeEnums.length; ++ctr2) {
            EmergeCodeFactory.emergeCodes[start + ctr2] = new EmergeCodeEncodedImpl(start + ctr2, EmergeCode.EmergeKind.MSG, (Object)msgCodeEnums[ctr2]);
        }
        for (ctr2 = msgCodeEnums.length; ctr2 <= NO_ENCODED_VALUE; ++ctr2) {
            EmergeCodeFactory.emergeCodes[start + ctr2] = new EmergeCodeInvalidImpl(start + ctr2);
        }
        start = EmergeCode.EmergeKind.LABEL_MSG.ordinal() << 3;
        EmergeCode.LabelMsg[] labelMsgEnums = EmergeCode.LabelMsg.values();
        for (ctr = 0; ctr < labelMsgEnums.length; ++ctr) {
            EmergeCode.LabelMsg lm;
            EmergeCodeFactory.emergeCodes[start + ctr] = new EmergeCodeEncodedImpl(start + ctr, EmergeCode.EmergeKind.LABEL_MSG, (Object)lm, (lm = labelMsgEnums[ctr]) != EmergeCode.LabelMsg.REPLY_GOOD ? CodeClass.SIMPLE_MESSAGE : CodeClass.NONE);
        }
        for (ctr = labelMsgEnums.length; ctr <= NO_ENCODED_VALUE; ++ctr) {
            EmergeCodeFactory.emergeCodes[start + ctr] = new EmergeCodeInvalidImpl(start + ctr);
        }
        EmergeCodeFactory.initializeSimple(EmergeCode.EmergeKind.NULL, CodeClass.PRIMITIVE);
        EmergeCodeFactory.initializeSimple(EmergeCode.EmergeKind.INDIR, CodeClass.PRIMITIVE);
        EmergeCodeFactory.initializeSimple(EmergeCode.EmergeKind.BOOL_ARR, CodeClass.ARRAY);
        EmergeCodeFactory.initializeSimple(EmergeCode.EmergeKind.BYTE_ARR, CodeClass.ARRAY);
        EmergeCodeFactory.initializeSimple(EmergeCode.EmergeKind.SHORT_ARR, CodeClass.ARRAY);
        EmergeCodeFactory.initializeSimple(EmergeCode.EmergeKind.CHAR_ARR, CodeClass.ARRAY);
        EmergeCodeFactory.initializeSimple(EmergeCode.EmergeKind.INT_ARR, CodeClass.ARRAY);
        EmergeCodeFactory.initializeSimple(EmergeCode.EmergeKind.LONG_ARR, CodeClass.ARRAY);
        EmergeCodeFactory.initializeSimple(EmergeCode.EmergeKind.FLOAT_ARR, CodeClass.ARRAY);
        EmergeCodeFactory.initializeSimple(EmergeCode.EmergeKind.DOUBLE_ARR, CodeClass.ARRAY);
        EmergeCodeFactory.initializeSimple(EmergeCode.EmergeKind.REF_ARR, CodeClass.ARRAY);
        EmergeCodeFactory.initializeSimple(EmergeCode.EmergeKind.FLIST, CodeClass.SIMPLE_MESSAGE);
        EmergeCodeFactory.initializeSimple(EmergeCode.EmergeKind.CLOSE_SESSION, CodeClass.SIMPLE_MESSAGE);
        EmergeCodeFactory.initializeSimple(EmergeCode.EmergeKind.REJECT_REQUEST, CodeClass.SIMPLE_MESSAGE);
        EmergeCodeFactory.initializeSimple(EmergeCode.EmergeKind.REF, CodeClass.NONE);
        EmergeCodeFactory.initializeInvalid(EmergeCode.EmergeKind.KIND_UNUSED_7);
        EmergeCodeFactory.initializeInvalid(EmergeCode.EmergeKind.KIND_UNUSED_13);
        EmergeCodeFactory.initializeInvalid(EmergeCode.EmergeKind.KIND_UNUSED_14);
        EmergeCodeFactory.initializeInvalid(EmergeCode.EmergeKind.KIND_UNUSED_15);
        EmergeCodeFactory.initializeInvalid(EmergeCode.EmergeKind.KIND_UNUSED_31);
        BOOL_CODE = (byte)EmergeCodeFactory.getCodeValue(EmergeCode.EmergeKind.BOOL);
        BOOL_TRUE = (byte)(BOOL_CODE & 1);
        BOOL_FALSE = (byte)(BOOL_CODE & 0);
    }

    private static enum CodeClass {
        NONE,
        PRIMITIVE,
        ARRAY,
        SIMPLE_MESSAGE;

    }

    private static abstract class EmergeCodeBase
    implements EmergeCode {
        private int code;
        private EmergeCode.EmergeKind kind;
        private Object value;
        private CodeClass cc;

        public String toString() {
            return "EmergeCode[" + this.code + " (" + (Object)((Object)this.kind) + ")" + (this.value == null ? "" : " " + this.value) + "]";
        }

        EmergeCodeBase(int code, EmergeCode.EmergeKind kind, Object value) {
            this(code, kind, value, CodeClass.NONE);
        }

        EmergeCodeBase(int code, EmergeCode.EmergeKind kind, Object value, CodeClass cc) {
            if (code < 0 || code > 255) {
                // empty if block
            }
            this.code = code;
            this.kind = kind;
            this.value = value;
            this.cc = cc;
        }

        EmergeCodeBase() {
            this(0, null, null);
        }

        @Override
        public <T> T getValue(Class<T> cls) {
            if (this.value == null) {
                throw new IllegalArgumentException(this + " does not contain a value");
            }
            return cls.cast(this.value);
        }

        @Override
        public int code() {
            return this.code;
        }

        @Override
        public byte byteCode() {
            if (this.code < 128) {
                return (byte)this.code;
            }
            return (byte)(this.code - 256);
        }

        @Override
        public EmergeCode.EmergeKind getKind() {
            return this.kind;
        }

        @Override
        public boolean hasEncodedValue() {
            return this.value != null;
        }

        @Override
        public boolean isValidEmergeCode() {
            return true;
        }

        @Override
        public boolean isPrimitive() {
            return this.cc == CodeClass.PRIMITIVE;
        }

        @Override
        public boolean isArray() {
            return this.cc == CodeClass.ARRAY;
        }

        @Override
        public boolean isSimpleMessage() {
            return this.cc == CodeClass.SIMPLE_MESSAGE;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof EmergeCodeBase)) {
                return false;
            }
            EmergeCodeBase other = (EmergeCodeBase)obj;
            return other.code == this.code;
        }

        public int hashCode() {
            return this.code;
        }
    }

    private static final class EmergeCodeEncodedImpl
    extends EmergeCodeBase {
        EmergeCodeEncodedImpl(int code, EmergeCode.EmergeKind kind, Object value, CodeClass cc) {
            super(code, kind, value, cc);
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
        }

        EmergeCodeEncodedImpl(int code, EmergeCode.EmergeKind kind, Object value) {
            this(code, kind, value, CodeClass.NONE);
        }

        @Override
        public EmergeCode.EmergeType getType() {
            return EmergeCode.EmergeType.ENCODED;
        }
    }

    private static final class EmergeCodeInvalidImpl
    extends EmergeCodeBase {
        EmergeCodeInvalidImpl(int code) {
            super(code, null, null);
        }

        @Override
        public EmergeCode.EmergeType getType() {
            throw new IllegalArgumentException(this.code() + " is not a valid Emerge code");
        }

        @Override
        public EmergeCode.EmergeKind getKind() {
            throw new IllegalArgumentException(this.code() + " is not a valid Emerge code");
        }

        @Override
        public <T> T getValue(Class<T> cls) {
            throw new IllegalArgumentException(this.code() + " is not a valid Emerge code");
        }

        @Override
        public boolean hasEncodedValue() {
            throw new IllegalArgumentException(this.code() + " is not a valid Emerge code");
        }

        @Override
        public boolean isValidEmergeCode() {
            return false;
        }

        @Override
        public boolean isPrimitive() {
            throw new IllegalArgumentException(this.code() + " is not a valid Emerge code");
        }

        @Override
        public boolean isArray() {
            throw new IllegalArgumentException(this.code() + " is not a valid Emerge code");
        }

        @Override
        public boolean isSimpleMessage() {
            throw new IllegalArgumentException(this.code() + " is not a valid Emerge code");
        }
    }

    private static final class EmergeCodeOptionalValueImpl
    extends EmergeCodeBase {
        EmergeCodeOptionalValueImpl(int code, EmergeCode.EmergeKind kind) {
            this(code, kind, null);
        }

        EmergeCodeOptionalValueImpl(int code, EmergeCode.EmergeKind kind, Object value) {
            super(code, kind, value, CodeClass.PRIMITIVE);
        }

        @Override
        public EmergeCode.EmergeType getType() {
            return EmergeCode.EmergeType.OPTIONAL_VALUE;
        }
    }

    private static final class EmergeCodeSimpleImpl
    extends EmergeCodeBase {
        EmergeCodeSimpleImpl(int code, EmergeCode.EmergeKind kind, CodeClass cc) {
            super(code, kind, null, cc);
        }

        EmergeCodeSimpleImpl(int code, EmergeCode.EmergeKind kind) {
            super(code, kind, null, CodeClass.NONE);
        }

        @Override
        public EmergeCode.EmergeType getType() {
            return EmergeCode.EmergeType.SIMPLE;
        }
    }
}

