/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding.fast;

import com.sun.corba.ee.impl.encoding.fast.EmergeCode;
import com.sun.corba.ee.impl.encoding.fast.EmergeCodeFactory;
import com.sun.corba.ee.impl.encoding.fast.EmergeLLP;
import com.sun.corba.ee.impl.encoding.fast.EmergeStreamEventHandler;
import com.sun.corba.ee.impl.encoding.fast.LabelManager;
import com.sun.corba.ee.impl.encoding.fast.VarOctetUtility;
import com.sun.corba.ee.impl.encoding.fast.bytebuffer.Reader;

public class EmergeStreamParser {
    private EmergeLLP fsm;
    private Reader reader;

    public EmergeStreamParser(Reader reader) {
        this.reader = reader;
        this.fsm = new EmergeLLP();
    }

    public void parse(EmergeStreamEventHandler handler) {
        long offset = 0L;
        long length = 0L;
        byte bytecode = this.reader.getByte();
        EmergeCode ec = EmergeCodeFactory.getByteCode(bytecode);
        this.fsm.checkState(ec);
        block0 : switch (ec.getKind()) {
            case BYTE: {
                byte byteResult = 0;
                byteResult = ec.hasEncodedValue() ? ec.getValue(Byte.class).byteValue() : this.reader.getByte();
                handler.byteEvent(byteResult);
                break;
            }
            case CHAR: {
                char charResult = '\u0000';
                charResult = ec.hasEncodedValue() ? ec.getValue(Character.class).charValue() : this.reader.getChar();
                handler.charEvent(charResult);
                break;
            }
            case SHORT: {
                short shortResult = 0;
                shortResult = ec.hasEncodedValue() ? ec.getValue(Short.class).shortValue() : this.reader.getShort();
                handler.shortEvent(shortResult);
                break;
            }
            case INT: {
                int intResult = 0;
                intResult = ec.hasEncodedValue() ? ec.getValue(Integer.class).intValue() : this.reader.getInt();
                handler.intEvent(intResult);
                break;
            }
            case LONG: {
                long longResult = 0L;
                longResult = ec.hasEncodedValue() ? ec.getValue(Long.class).longValue() : this.reader.getLong();
                handler.longEvent(longResult);
                break;
            }
            case FLOAT: {
                float floatResult = 0.0f;
                floatResult = ec.hasEncodedValue() ? ec.getValue(Float.class).floatValue() : this.reader.getFloat();
                handler.floatEvent(floatResult);
                break;
            }
            case DOUBLE: {
                double doubleResult = 0.0;
                doubleResult = ec.hasEncodedValue() ? ec.getValue(Double.class).doubleValue() : this.reader.getDouble();
                handler.doubleEvent(doubleResult);
                break;
            }
            case BOOL: {
                boolean boolResult = false;
                boolResult = ec.hasEncodedValue() ? ec.getValue(Boolean.class).booleanValue() : this.reader.getBoolean();
                handler.boolEvent(boolResult);
                break;
            }
            case TUPLE: {
                EmergeCode.TupleCode tc = ec.getValue(EmergeCode.TupleCode.class);
                if (tc == EmergeCode.TupleCode.TUPLE_START) {
                    handler.tupleStartEvent();
                    break;
                }
                if (tc != EmergeCode.TupleCode.TUPLE_START) break;
                handler.tupleEndEvent();
                break;
            }
            case PART: {
                LabelManager.Label typeLabel = new LabelManager.Label(this.reader);
                offset = VarOctetUtility.get(this.reader);
                length = VarOctetUtility.get(this.reader);
                this.fsm.setDataCtr(length);
                EmergeCode.PartCode pc = ec.getValue(EmergeCode.PartCode.class);
                if (pc == EmergeCode.PartCode.NO_CUSTOM) {
                    handler.simplePartEvent(typeLabel, offset, length);
                    break;
                }
                if (pc != EmergeCode.PartCode.HAS_CUSTOM) break;
                handler.customPartEvent(typeLabel, offset, length);
                break;
            }
            case MSG: {
                long requestId = VarOctetUtility.get(this.reader);
                long sessionId = VarOctetUtility.get(this.reader);
                long fiberId = VarOctetUtility.get(this.reader);
                long numArgs = VarOctetUtility.get(this.reader);
                EmergeCode.MsgCode mc = ec.getValue(EmergeCode.MsgCode.class);
                if (mc == EmergeCode.MsgCode.MSG_START) {
                    handler.messageStartEvent(requestId, sessionId, fiberId, numArgs);
                    break;
                }
                if (mc != EmergeCode.MsgCode.MSG_END) break;
                handler.messageEndEvent(requestId, sessionId, fiberId, numArgs);
                break;
            }
            case LABEL_MSG: {
                LabelManager.Label label = new LabelManager.Label(this.reader);
                switch (ec.getValue(EmergeCode.LabelMsg.class)) {
                    case REQUEST: {
                        handler.labelMessageRequestEvent(label);
                        break block0;
                    }
                    case REPLY_GOOD: {
                        handler.labelMessageReplyGoodEvent(label);
                        break block0;
                    }
                    case REPLY_ERROR: {
                        long category = VarOctetUtility.get(this.reader);
                        long minorCode = VarOctetUtility.get(this.reader);
                        handler.labelMessageReplyBadEvent(label, category, minorCode);
                        break block0;
                    }
                }
                break;
            }
            case NULL: {
                handler.nullEvent();
                break;
            }
            case INDIR: {
                LabelManager.Label label2 = new LabelManager.Label(this.reader);
                handler.indirEvent(label2);
                break;
            }
            case BOOL_ARR: {
                LabelManager.Label selfLabel = new LabelManager.Label(this.reader);
                offset = VarOctetUtility.get(this.reader);
                length = VarOctetUtility.get(this.reader);
                boolean[] booleanValue = new boolean[(int)length];
                this.reader.getBooleanArray(booleanValue);
                handler.boolArrEvent(selfLabel, offset, length, booleanValue);
                break;
            }
            case BYTE_ARR: {
                LabelManager.Label selfLabel = new LabelManager.Label(this.reader);
                offset = VarOctetUtility.get(this.reader);
                length = VarOctetUtility.get(this.reader);
                byte[] byteVale = new byte[(int)length];
                this.reader.getByteArray(byteVale);
                handler.byteArrEvent(selfLabel, offset, length, byteVale);
                break;
            }
            case CHAR_ARR: {
                LabelManager.Label selfLabel = new LabelManager.Label(this.reader);
                offset = VarOctetUtility.get(this.reader);
                length = VarOctetUtility.get(this.reader);
                char[] charValue = new char[(int)length];
                this.reader.getCharArray(charValue);
                handler.charArrEvent(selfLabel, offset, length, charValue);
                break;
            }
            case SHORT_ARR: {
                LabelManager.Label selfLabel = new LabelManager.Label(this.reader);
                offset = VarOctetUtility.get(this.reader);
                length = VarOctetUtility.get(this.reader);
                short[] shortValue = new short[(int)length];
                this.reader.getShortArray(shortValue);
                handler.shortArrEvent(selfLabel, offset, length, shortValue);
                break;
            }
            case INT_ARR: {
                LabelManager.Label selfLabel = new LabelManager.Label(this.reader);
                offset = VarOctetUtility.get(this.reader);
                length = VarOctetUtility.get(this.reader);
                int[] intValue = new int[(int)length];
                this.reader.getIntArray(intValue);
                handler.intArrEvent(selfLabel, offset, length, intValue);
                break;
            }
            case LONG_ARR: {
                LabelManager.Label selfLabel = new LabelManager.Label(this.reader);
                offset = VarOctetUtility.get(this.reader);
                length = VarOctetUtility.get(this.reader);
                long[] longValue = new long[(int)length];
                this.reader.getLongArray(longValue);
                handler.longArrEvent(selfLabel, offset, length, longValue);
                break;
            }
            case FLOAT_ARR: {
                LabelManager.Label selfLabel = new LabelManager.Label(this.reader);
                offset = VarOctetUtility.get(this.reader);
                length = VarOctetUtility.get(this.reader);
                float[] floatValue = new float[(int)length];
                this.reader.getFloatArray(floatValue);
                handler.floatArrEvent(selfLabel, offset, length, floatValue);
                break;
            }
            case DOUBLE_ARR: {
                LabelManager.Label selfLabel = new LabelManager.Label(this.reader);
                offset = VarOctetUtility.get(this.reader);
                length = VarOctetUtility.get(this.reader);
                double[] doubleValue = new double[(int)length];
                this.reader.getDoubleArray(doubleValue);
                handler.doubleArrEvent(selfLabel, offset, length, doubleValue);
                break;
            }
            case REF_ARR: {
                LabelManager.Label selfLabel = new LabelManager.Label(this.reader);
                LabelManager.Label typeLabel = new LabelManager.Label(this.reader);
                offset = VarOctetUtility.get(this.reader);
                length = VarOctetUtility.get(this.reader);
                LabelManager.Label[] refValue = new LabelManager.Label[(int)length];
                int ctr = 0;
                while ((long)ctr < length) {
                    refValue[ctr] = new LabelManager.Label(this.reader);
                    ++ctr;
                }
                handler.refArrEvent(selfLabel, typeLabel, offset, length, refValue);
                break;
            }
            case FLIST: {
                length = VarOctetUtility.get(this.reader);
                long[] flistValue = new long[(int)length];
                int ctr = 0;
                while ((long)ctr < length) {
                    flistValue[ctr] = VarOctetUtility.get(this.reader);
                    ++ctr;
                }
                handler.fiberListMessageEvent(flistValue);
                break;
            }
            case CLOSE_SESSION: {
                long sessionId = VarOctetUtility.get(this.reader);
                handler.closeSessionMessageEvent(sessionId);
                break;
            }
            case REJECT_REQUEST: {
                long category = VarOctetUtility.get(this.reader);
                long minorCode = VarOctetUtility.get(this.reader);
                handler.rejectRequestMessageEvent(category, minorCode);
                break;
            }
            case REF: {
                LabelManager.Label selfLabel = new LabelManager.Label(this.reader);
                length = VarOctetUtility.get(this.reader);
                this.fsm.setPartCtr(length);
                handler.refEvent(selfLabel, length);
                break;
            }
        }
    }
}

